/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import java.io.IOException;

public final class HttpRequestFactory {
    private final HttpTransport transport;
    private final HttpRequestInitializer initializer;

    HttpRequestFactory(HttpTransport transport, HttpRequestInitializer initializer) {
        this.transport = transport;
        this.initializer = initializer;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public HttpRequestInitializer getInitializer() {
        return this.initializer;
    }

    public HttpRequest buildRequest(String requestMethod, GenericUrl url, HttpContent content2) throws IOException {
        HttpRequest request = this.transport.buildRequest();
        if (this.initializer != null) {
            this.initializer.initialize(request);
        }
        request.setRequestMethod(requestMethod);
        if (url != null) {
            request.setUrl(url);
        }
        if (content2 != null) {
            request.setContent(content2);
        }
        return request;
    }

    public HttpRequest buildDeleteRequest(GenericUrl url) throws IOException {
        return this.buildRequest("DELETE", url, null);
    }

    public HttpRequest buildGetRequest(GenericUrl url) throws IOException {
        return this.buildRequest("GET", url, null);
    }

    public HttpRequest buildPostRequest(GenericUrl url, HttpContent content2) throws IOException {
        return this.buildRequest("POST", url, content2);
    }

    public HttpRequest buildPutRequest(GenericUrl url, HttpContent content2) throws IOException {
        return this.buildRequest("PUT", url, content2);
    }

    public HttpRequest buildPatchRequest(GenericUrl url, HttpContent content2) throws IOException {
        return this.buildRequest("PATCH", url, content2);
    }

    public HttpRequest buildHeadRequest(GenericUrl url) throws IOException {
        return this.buildRequest("HEAD", url, null);
    }
}

