/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.images;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.images.ConfigureImageDialog;
import org.intellij.plugins.markdown.editor.images.ConfigureImageLineMarkerProviderBase;
import org.intellij.plugins.markdown.editor.images.ImageUtils;
import org.intellij.plugins.markdown.editor.images.MarkdownImageData;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0000\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0014\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/editor/images/ConfigureHtmlImageLineMarkerProvider;", "Lorg/intellij/plugins/markdown/editor/images/ConfigureImageLineMarkerProviderBase;", "Lcom/intellij/psi/html/HtmlTag;", "()V", "applyChanges", "", "element", "Lcom/intellij/psi/PsiElement;", "imageData", "Lorg/intellij/plugins/markdown/editor/images/MarkdownImageData;", "convertToMarkdown", "image", "createDialog", "Lorg/intellij/plugins/markdown/editor/images/ConfigureImageDialog;", "getName", "", "obtainLeafElement", "obtainOuterElement", "obtainPathText", "updateAttributes", "setAttributeIfNotEmpty", "attributeName", "value", "Companion", "intellij.markdown"})
public final class ConfigureHtmlImageLineMarkerProvider
extends ConfigureImageLineMarkerProviderBase<HtmlTag> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getName() {
        String string = MarkdownBundle.message("markdown.configure.html.image.line.marker.provider.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026ne.marker.provider.name\")");
        return string;
    }

    @Override
    @Nullable
    public PsiElement obtainLeafElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiFile psiFile = element2.getContainingFile();
        if (Intrinsics.areEqual((Object)(psiFile != null && (psiFile = psiFile.getViewProvider()) != null ? psiFile.getBaseLanguage() : null), (Object)((Object)MarkdownLanguage.INSTANCE)) ^ true) {
            return null;
        }
        PsiElement psiElement = element2;
        boolean bl = false;
        boolean bl2 = false;
        PsiElement it = psiElement;
        boolean bl3 = false;
        return Companion.getImageByNameElement(element2) != null ? psiElement : null;
    }

    @Override
    @Nullable
    public HtmlTag obtainOuterElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (element2 instanceof HtmlTag && Intrinsics.areEqual((Object)((HtmlTag)element2).getName(), (Object)"img")) {
            return (HtmlTag)element2;
        }
        return Companion.getImageByNameElement(element2);
    }

    @Override
    @Nullable
    public String obtainPathText(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        HtmlTag htmlTag = this.obtainOuterElement(element2);
        return htmlTag != null ? htmlTag.getAttributeValue("src") : null;
    }

    @Override
    @NotNull
    public ConfigureImageDialog createDialog(@NotNull HtmlTag element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Project project = element2.getProject();
        String string = MarkdownBundle.message("markdown.configure.image.title.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026figure.image.title.text\")");
        return new ConfigureImageDialog(project, string, this.obtainPathText((PsiElement)element2), element2.getAttributeValue("width"), element2.getAttributeValue("height"), element2.getAttributeValue("title"), element2.getAttributeValue("alt"), true);
    }

    @Override
    public void applyChanges(@NotNull PsiElement element2, @NotNull MarkdownImageData imageData) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        HtmlTag htmlTag = this.obtainOuterElement(element2);
        if (htmlTag == null) {
            return;
        }
        HtmlTag image = htmlTag;
        if (imageData.getShouldConvertToHtml()) {
            this.updateAttributes(image, imageData);
        } else {
            this.convertToMarkdown(image, imageData);
        }
    }

    private final void updateAttributes(HtmlTag image, MarkdownImageData imageData) {
        Runnable action2 = new Runnable(this, image, imageData){
            final /* synthetic */ ConfigureHtmlImageLineMarkerProvider this$0;
            final /* synthetic */ HtmlTag $image;
            final /* synthetic */ MarkdownImageData $imageData;

            public final void run() {
                ConfigureHtmlImageLineMarkerProvider.access$setAttributeIfNotEmpty(this.this$0, this.$image, "src", this.$imageData.getPath());
                ConfigureHtmlImageLineMarkerProvider.access$setAttributeIfNotEmpty(this.this$0, this.$image, "width", this.$imageData.getWidth());
                ConfigureHtmlImageLineMarkerProvider.access$setAttributeIfNotEmpty(this.this$0, this.$image, "height", this.$imageData.getHeight());
                ConfigureHtmlImageLineMarkerProvider.access$setAttributeIfNotEmpty(this.this$0, this.$image, "title", this.$imageData.getTitle());
                ConfigureHtmlImageLineMarkerProvider.access$setAttributeIfNotEmpty(this.this$0, this.$image, "alt", this.$imageData.getDescription());
            }
            {
                this.this$0 = configureHtmlImageLineMarkerProvider;
                this.$image = htmlTag;
                this.$imageData = markdownImageData;
            }
        };
        WriteCommandAction.runWriteCommandAction((Project)image.getProject(), (String)MarkdownBundle.message("markdown.configure.image.line.marker.update.html.image.attributes.command.name", new Object[0]), null, (Runnable)action2, (PsiFile[])new PsiFile[0]);
    }

    private final void convertToMarkdown(HtmlTag image, MarkdownImageData imageData) {
        Runnable action2 = new Runnable(imageData, image){
            final /* synthetic */ MarkdownImageData $imageData;
            final /* synthetic */ HtmlTag $image;

            public final void run() {
                String text = ImageUtils.createMarkdownImageText(this.$imageData.getDescription(), this.$imageData.getPath(), this.$imageData.getTitle());
                XmlElementFactory.getInstance((Project)this.$image.getProject()).createDisplayText(text);
                this.$image.replace((PsiElement)XmlElementFactory.getInstance((Project)this.$image.getProject()).createDisplayText(text));
            }
            {
                this.$imageData = markdownImageData;
                this.$image = htmlTag;
            }
        };
        WriteCommandAction.runWriteCommandAction((Project)image.getProject(), (String)MarkdownBundle.message("markdown.configure.image.line.marker.convert.html.to.markdown.command.name", new Object[0]), null, (Runnable)action2, (PsiFile[])new PsiFile[0]);
    }

    private final void setAttributeIfNotEmpty(HtmlTag $this$setAttributeIfNotEmpty, String attributeName, String value) {
        CharSequence charSequence = value;
        boolean bl = false;
        if (charSequence.length() == 0 && $this$setAttributeIfNotEmpty.getAttribute(attributeName) == null) {
            return;
        }
        $this$setAttributeIfNotEmpty.setAttribute(attributeName, value);
    }

    public static final /* synthetic */ void access$setAttributeIfNotEmpty(ConfigureHtmlImageLineMarkerProvider $this, HtmlTag $this$access_u24setAttributeIfNotEmpty, String attributeName, String value) {
        $this.setAttributeIfNotEmpty($this$access_u24setAttributeIfNotEmpty, attributeName, value);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lorg/intellij/plugins/markdown/editor/images/ConfigureHtmlImageLineMarkerProvider$Companion;", "", "()V", "getImageByNameElement", "Lcom/intellij/psi/html/HtmlTag;", "element", "Lcom/intellij/psi/PsiElement;", "isImgTagName", "", "intellij.markdown"})
    public static final class Companion {
        public final boolean isImgTagName(@NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            IElementType iElementType = XmlTokenType.XML_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"XmlTokenType.XML_NAME");
            return PsiUtilsKt.hasType(element2, iElementType) && Intrinsics.areEqual((Object)element2.getText(), (Object)"img");
        }

        @Nullable
        public final HtmlTag getImageByNameElement(@NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            if (!this.isImgTagName(element2)) {
                return null;
            }
            PsiElement psiElement = element2.getParent();
            if (!(psiElement instanceof HtmlTag)) {
                psiElement = null;
            }
            return (HtmlTag)psiElement;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

