/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.editor.lists.ListRenumberUtils;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListImpl;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListItemCreatingTypedHandlerDelegate;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "()V", "charTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.markdown"})
public final class MarkdownListItemCreatingTypedHandlerDelegate
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof MarkdownFile) || c != ' ' || !MarkdownSettings.Companion.getInstance(project).isEnhancedEditingEnabled()) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Caret caret = caretModel.getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.currentCaret");
        Caret caret2 = caret;
        PsiElement element2 = file.findElementAt(caret2.getOffset() - 1);
        if (element2 == null || !MarkdownTokenTypeSets.LIST_MARKERS.contains(PsiTreeUtilKt.getElementType((PsiElement)element2))) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (caret2.getOffset() <= ListUtils.INSTANCE.getLineIndentRange(document2, caret2.getLogicalPosition().line).getEndOffset()) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        int markerEnd = UtilsKt.getEndOffset((PsiElement)element2) - 1;
        if (CharArrayUtil.shiftBackward((CharSequence)document2.getCharsSequence(), (int)markerEnd, (String)" ") < markerEnd - 1) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        PsiElement $this$parentOfType$iv = element2;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownListImpl.class, (boolean)true);
        Intrinsics.checkNotNull((Object)psiElement);
        ListRenumberUtils.INSTANCE.renumberInBulk((MarkdownListImpl)psiElement, document2, false, false);
        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        PsiElement psiElement2 = file.findElementAt(caret2.getOffset() - 1);
        caret2.moveToOffset(psiElement2 != null ? UtilsKt.getEndOffset((PsiElement)psiElement2) : caret2.getOffset());
        return TypedHandlerDelegate.Result.STOP;
    }
}

