/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang.StringUtils;
import org.intellij.plugins.markdown.editor.tables.TableFormattingUtils;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCellImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001.B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J6\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J#\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u001aJ8\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0014H\u0002J0\u0010#\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0014H\u0002J*\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\"\u001a\u00020\u0014J\"\u0010\u0003\u001a\u00020\u0004*\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0012\u0010*\u001a\u00020\u0014*\u00020)2\u0006\u0010+\u001a\u00020,J:\u0010-\u001a\u00020\u001c*\u00020)2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\"\u001a\u00020\u0014\u00a8\u0006/"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/TableFormattingUtils;", "", "()V", "buildCellState", "Lorg/intellij/plugins/markdown/editor/tables/TableFormattingUtils$CellContentState;", "range", "Lcom/intellij/openapi/util/TextRange;", "document", "Lcom/intellij/openapi/editor/Document;", "carets", "", "Lcom/intellij/openapi/editor/Caret;", "calculateContentsMaxWidth", "", "cells", "", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableCellImpl;", "cellsContentsWithCarets", "separatorCellRange", "trimToMaxContent", "", "calculateNewCaretsPositions", "", "content", "", "cellRange", "(Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;)[Ljava/lang/Integer;", "processCell", "", "cell", "state", "maxCellWidth", "alignment", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow$CellAlignment;", "preventExpand", "processSeparator", "separatorRow", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow;", "columnIndex", "reformatAllColumns", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableImpl;", "isSoftWrapping", "editor", "Lcom/intellij/openapi/editor/Editor;", "reformatColumnOnChange", "CellContentState", "intellij.markdown"})
public final class TableFormattingUtils {
    @NotNull
    public static final TableFormattingUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final CellContentState buildCellState(TextRange range, Document document, Iterable<? extends Caret> carets) {
        boolean bl;
        List caretsOffsets;
        String content2;
        Caret[] caretsInside;
        block11: {
            void $this$mapTo$iv$iv;
            void $this$toTypedArray$iv;
            Collection $this$sortedBy$iv;
            int n;
            Caret it;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv = carets;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv22 = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (Caret)element$iv$iv;
                n = 0;
                if (!range.containsOffset(it.getOffset())) continue;
                destination$iv$iv22.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv22;
            boolean $i$f$sortedBy = false;
            boolean $this$filterTo$iv$iv2 = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Caret it = (Caret)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getOffset());
                    it = (Caret)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getOffset();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            });
            boolean $i$f$toTypedArray22 = false;
            void thisCollection$iv22 = $this$toTypedArray$iv;
            Caret[] caretArray = thisCollection$iv22.toArray(new Caret[0]);
            if (caretArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            caretsInside = caretArray;
            Caret[] caretArray2 = document.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)caretArray2, (String)"document.charsSequence");
            Caret[] $i$f$toTypedArray22 = caretArray2;
            int thisCollection$iv22 = range.getStartOffset();
            int destination$iv$iv22 = range.getEndOffset();
            $i$f$filterTo22 = false;
            content2 = ((Object)$i$f$toTypedArray22.subSequence(thisCollection$iv22, destination$iv$iv22)).toString();
            $i$f$toTypedArray22 = caretsInside;
            thisCollection$iv22 = 0;
            if ($i$f$toTypedArray22.length == 0) {
                return new CellContentState(content2, null, 2, null);
            }
            Caret[] $this$map$iv = caretsInside;
            boolean $i$f$map = false;
            Caret[] $i$f$filterTo22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            it = $this$mapTo$iv$iv;
            n = ((Caret)it).length;
            for (int j = 0; j < n; ++j) {
                void it2;
                Caret item$iv$iv;
                Caret caret = item$iv$iv = it[j];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Integer n2 = it2.getOffset() - range.getStartOffset();
                collection.add(n2);
            }
            caretsOffsets = (List)destination$iv$iv;
            Iterable $this$all$iv = caretsOffsets;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    int it3 = ((Number)element$iv).intValue();
                    boolean bl3 = false;
                    if (it3 <= content2.length()) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        boolean $this$all$iv = bl;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!$this$all$iv) {
            boolean bl6 = false;
            String string = "Content indices: " + StringsKt.getIndices((CharSequence)content2) + "; Carets offsets: " + caretsOffsets;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl4 = false;
        bl5 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl7 = false;
        boolean bl8 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl9 = false;
        int previousOffset = 0;
        Iterator iterator = caretsOffsets.iterator();
        while (iterator.hasNext()) {
            int caretOffset = ((Number)iterator.next()).intValue();
            String string = content2;
            boolean bl10 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(previousOffset, caretOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            $this$buildString.append(string3);
            $this$buildString.append('\n');
            previousOffset = caretOffset;
        }
        String string = content2;
        int n = content2.length();
        boolean bl11 = false;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(previousOffset, n);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        $this$buildString.append(string5);
        String string6 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"StringBuilder().apply(builderAction).toString()");
        String contentWithReplacements = string6;
        return new CellContentState(contentWithReplacements, caretsInside);
    }

    private final CellContentState buildCellState(MarkdownTableCellImpl $this$buildCellState, Document document, Iterable<? extends Caret> carets) {
        TextRange textRange = $this$buildCellState.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"textRange");
        return this.buildCellState(textRange, document, carets);
    }

    private final int calculateContentsMaxWidth(Collection<? extends MarkdownTableCellImpl> cells, Iterable<CellContentState> cellsContentsWithCarets, TextRange separatorCellRange, boolean trimToMaxContent) {
        Integer n;
        Object it;
        Iterator iterator;
        boolean bl;
        Iterable iterable;
        if (trimToMaxContent) {
            Object object;
            iterable = SequencesKt.map((Sequence)CollectionsKt.asSequence(cellsContentsWithCarets), (Function1)calculateContentsMaxWidth.contentCellsWidth.1.INSTANCE);
            bl = false;
            iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                object = null;
            } else {
                it = (String)iterator.next();
                boolean bl2 = false;
                it = ((String)it).length() + 2;
                while (iterator.hasNext()) {
                    Object it2 = (String)iterator.next();
                    $i$a$-maxOfOrNull-TableFormattingUtils$calculateContentsMaxWidth$contentCellsWidth$2 = false;
                    if (it.compareTo(it2 = (Comparable)Integer.valueOf(((String)it2).length() + 2)) >= 0) continue;
                    it = it2;
                }
                object = it;
            }
            n = (Integer)object;
        } else {
            Comparable comparable;
            iterable = cells;
            bl = false;
            iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                it = (MarkdownTableCellImpl)iterator.next();
                boolean bl3 = false;
                TextRange textRange = it.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"it.textRange");
                Comparable comparable2 = Integer.valueOf(textRange.getLength());
                while (iterator.hasNext()) {
                    MarkdownTableCellImpl it3 = (MarkdownTableCellImpl)iterator.next();
                    $i$a$-maxOfOrNull-TableFormattingUtils$calculateContentsMaxWidth$contentCellsWidth$3 = false;
                    TextRange textRange2 = it3.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"it.textRange");
                    Comparable comparable3 = Integer.valueOf(textRange2.getLength());
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            n = (Integer)comparable;
        }
        Integer contentCellsWidth2 = n;
        boolean bl4 = false;
        bl = false;
        bl = false;
        boolean bl5 = false;
        if (contentCellsWidth2 == null) {
            boolean bl6 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        TextRange textRange = separatorCellRange;
        return Integer.max(Integer.max(contentCellsWidth2, textRange != null ? textRange.getLength() : -1), 5);
    }

    /*
     * WARNING - void declaration
     */
    private final Integer[] calculateNewCaretsPositions(String content2, TextRange cellRange) {
        void $this$toTypedArray$iv22;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        int it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = (Iterable)StringsKt.getIndices((CharSequence)content2);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(content2.charAt(it) == '\n')) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it + cellRange.getStartOffset();
            collection.add(n);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv22;
        Integer[] integerArray = thisCollection$iv.toArray(new Integer[0]);
        if (integerArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Integer[] positions = integerArray;
        int $this$toTypedArray$iv22 = 0;
        int n = positions.length;
        while ($this$toTypedArray$iv22 < n) {
            void index;
            void v1 = index;
            positions[v1] = positions[v1] - index;
            ++index;
        }
        return positions;
    }

    /*
     * WARNING - void declaration
     */
    private final void processCell(Document document, MarkdownTableCellImpl cell, CellContentState state, int maxCellWidth, MarkdownTableSeparatorRow.CellAlignment alignment, boolean preventExpand) {
        String expectedContent = TableModificationUtils.INSTANCE.buildRealignedCellContent(state.getTrimmedContentWithCarets(), maxCellWidth + state.getCaretsInside().length, alignment);
        TextRange range = cell.getTextRange();
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.charsSequence");
        CharSequence charSequence2 = charSequence;
        TextRange textRange = range;
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range");
        int n = textRange.getStartOffset();
        int n2 = range.getEndOffset();
        boolean bl = false;
        String cellContent = ((Object)charSequence2.subSequence(n, n2)).toString();
        if (preventExpand && cellContent.length() < maxCellWidth) {
            return;
        }
        String expectedContentWithoutCarets = StringsKt.replace$default((String)expectedContent, (String)String.valueOf('\n'), (String)"", (boolean)false, (int)4, null);
        if (Intrinsics.areEqual((Object)cellContent, (Object)expectedContentWithoutCarets) ^ true) {
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)expectedContentWithoutCarets);
            Object[] caretsPositions = this.calculateNewCaretsPositions(expectedContent, range);
            n2 = caretsPositions.length == state.getCaretsInside().length ? 1 : 0;
            bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (n2 == 0) {
                boolean bl4 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            for (Pair pair : SequencesKt.zip((Sequence)ArraysKt.asSequence((Object[])state.getCaretsInside()), (Sequence)ArraysKt.asSequence((Object[])caretsPositions))) {
                void caret;
                Caret caret2 = (Caret)pair.component1();
                int position = ((Number)pair.component2()).intValue();
                caret.moveToOffset(position);
            }
        }
    }

    private final void processSeparator(Document document, MarkdownTableSeparatorRow separatorRow, int columnIndex, int maxCellWidth, boolean preventExpand) {
        TextRange textRange = MarkdownTableSeparatorRow.getCellRange$default(separatorRow, columnIndex, false, 2, null);
        Intrinsics.checkNotNull((Object)textRange);
        TextRange range = textRange;
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.charsSequence");
        CharSequence charSequence2 = charSequence;
        int n = range.getStartOffset();
        int n2 = range.getEndOffset();
        boolean bl = false;
        String content2 = ((Object)charSequence2.subSequence(n, n2)).toString();
        if (preventExpand && content2.length() < maxCellWidth) {
            return;
        }
        MarkdownTableSeparatorRow.CellAlignment alignment = separatorRow.getCellAlignment(columnIndex);
        String expectedContent = TableModificationUtils.INSTANCE.buildSeparatorCellContent(alignment, maxCellWidth);
        if (Intrinsics.areEqual((Object)content2, (Object)expectedContent) ^ true) {
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)expectedContent);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void reformatColumnOnChange(@NotNull MarkdownTableImpl $this$reformatColumnOnChange, @NotNull Document document, @NotNull Iterable<? extends Caret> carets, int columnIndex, boolean trimToMaxContent, boolean preventExpand) {
        boolean bl;
        Iterable iterable;
        TextRange destination$iv$iv322;
        MarkdownTableSeparatorRow separatorRow;
        List cellsStates;
        Object object;
        Object object2;
        List cells;
        block6: {
            TextRange separatorCellRange;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)$this$reformatColumnOnChange, (String)"$this$reformatColumnOnChange");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter(carets, (String)"carets");
            cells = CollectionsKt.asReversed(TableUtils.INSTANCE.getColumnCells($this$reformatColumnOnChange, columnIndex, true));
            Iterable $this$map$iv = cells;
            boolean $i$f$map22 = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv322 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                MarkdownTableCellImpl markdownTableCellImpl = (MarkdownTableCellImpl)item$iv$iv2;
                object2 = destination$iv$iv322;
                boolean bl2 = false;
                object = INSTANCE.buildCellState((MarkdownTableCellImpl)it, document, carets);
                object2.add(object);
            }
            cellsStates = (List)destination$iv$iv322;
            MarkdownTableSeparatorRow $i$f$map22 = TableUtils.INSTANCE.getSeparatorRow($this$reformatColumnOnChange);
            boolean $this$mapTo$iv$iv2 = false;
            boolean destination$iv$iv322 = false;
            destination$iv$iv322 = false;
            $i$f$mapTo2 = false;
            if ($i$f$map22 == null) {
                boolean bl3 = false;
                String $i$f$mapTo2 = "Required value was null.";
                throw (Throwable)new IllegalStateException($i$f$mapTo2.toString());
            }
            separatorRow = $i$f$map22;
            TextRange textRange = MarkdownTableSeparatorRow.getCellRange$default(separatorRow, columnIndex, false, 2, null);
            Intrinsics.checkNotNull((Object)textRange);
            destination$iv$iv322 = separatorCellRange = textRange;
            $i$f$mapTo2 = false;
            boolean bl4 = false;
            item$iv$iv2 = destination$iv$iv322;
            iterable = cellsStates;
            object = cells;
            object2 = this;
            boolean bl5 = false;
            Iterable<? extends Caret> $this$any$iv = carets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<? extends Caret> iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    Caret element$iv;
                    Caret it = element$iv = iterator.next();
                    boolean bl6 = false;
                    if (!separatorCellRange.containsOffset(it.getOffset())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean bl7 = bl;
        int maxCellWidth = super.calculateContentsMaxWidth((Collection<? extends MarkdownTableCellImpl>)object, iterable, (TextRange)(bl7 ? destination$iv$iv322 : null), trimToMaxContent);
        MarkdownTableSeparatorRow.CellAlignment alignment = TableUtils.INSTANCE.getColumnAlignment($this$reformatColumnOnChange, columnIndex);
        Sequence contentCells2 = SequencesKt.takeWhile((Sequence)SequencesKt.zip((Sequence)CollectionsKt.asSequence((Iterable)cells), (Sequence)CollectionsKt.asSequence((Iterable)cellsStates)), (Function1)reformatColumnOnChange.contentCells.1.INSTANCE);
        for (Pair pair : contentCells2) {
            void cell;
            MarkdownTableCellImpl bl5 = (MarkdownTableCellImpl)pair.component1();
            CellContentState state = (CellContentState)pair.component2();
            this.processCell(document, (MarkdownTableCellImpl)cell, state, maxCellWidth, alignment, preventExpand);
        }
        this.processSeparator(document, separatorRow, columnIndex, maxCellWidth, preventExpand);
        this.processCell(document, (MarkdownTableCellImpl)CollectionsKt.last((List)cells), (CellContentState)CollectionsKt.last((List)cellsStates), maxCellWidth, alignment, preventExpand);
    }

    public static /* synthetic */ void reformatColumnOnChange$default(TableFormattingUtils tableFormattingUtils, MarkdownTableImpl markdownTableImpl, Document document, Iterable iterable, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        tableFormattingUtils.reformatColumnOnChange(markdownTableImpl, document, iterable, n, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public final void reformatAllColumns(@NotNull MarkdownTableImpl table, @NotNull Document document, boolean trimToMaxContent, boolean preventExpand) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        IntRange columnsIndices = TableUtils.INSTANCE.getColumnsIndices(table);
        int tableOffset = UtilsKt.getStartOffset((PsiElement)((PsiElement)table));
        IntRange intRange = columnsIndices;
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        if (n <= n2) {
            while (true) {
                void columnIndex;
                MarkdownTableImpl currentTable;
                PsiDocumentManager.getInstance((Project)table.getProject()).commitDocument(document);
                PsiFile psiFile = table.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"table.containingFile");
                if (TableUtils.findTable(psiFile, tableOffset) == null) {
                    break;
                }
                if (!TableUtils.INSTANCE.getColumnsIndices(currentTable).contains((int)columnIndex)) break;
                this.reformatColumnOnChange(currentTable, document, CollectionsKt.emptyList(), (int)columnIndex, trimToMaxContent, preventExpand);
                if (columnIndex == n2) break;
                ++columnIndex;
            }
        }
    }

    public static /* synthetic */ void reformatAllColumns$default(TableFormattingUtils tableFormattingUtils, MarkdownTableImpl markdownTableImpl, Document document, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        tableFormattingUtils.reformatAllColumns(markdownTableImpl, document, bl, bl2);
    }

    public final boolean isSoftWrapping(@NotNull MarkdownTableImpl $this$isSoftWrapping, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)$this$isSoftWrapping, (String)"$this$isSoftWrapping");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        TextRange range = $this$isSoftWrapping.getTextRange();
        SoftWrapModel softWrapModel = editor2.getSoftWrapModel();
        TextRange textRange = range;
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range");
        List list = softWrapModel.getSoftWrapsForRange(textRange.getStartOffset(), range.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"editor.softWrapModel.get\u2026tOffset, range.endOffset)");
        Collection collection = list;
        boolean bl = false;
        return !collection.isEmpty();
    }

    private TableFormattingUtils() {
    }

    static {
        TableFormattingUtils tableFormattingUtils;
        INSTANCE = tableFormattingUtils = new TableFormattingUtils();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000e\u0010\fR\u001b\u0010\u0011\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/TableFormattingUtils$CellContentState;", "", "contentWithCarets", "", "caretsInside", "", "Lcom/intellij/openapi/editor/Caret;", "(Ljava/lang/String;[Lcom/intellij/openapi/editor/Caret;)V", "getCaretsInside", "()[Lcom/intellij/openapi/editor/Caret;", "[Lcom/intellij/openapi/editor/Caret;", "getContentWithCarets", "()Ljava/lang/String;", "trimmedContentWithCarets", "getTrimmedContentWithCarets", "trimmedContentWithCarets$delegate", "Lkotlin/Lazy;", "trimmedContentWithoutCarets", "getTrimmedContentWithoutCarets", "trimmedContentWithoutCarets$delegate", "intellij.markdown"})
    private static final class CellContentState {
        @NotNull
        private final Lazy trimmedContentWithCarets$delegate;
        @NotNull
        private final Lazy trimmedContentWithoutCarets$delegate;
        @NotNull
        private final String contentWithCarets;
        @NotNull
        private final Caret[] caretsInside;

        @NotNull
        public final String getTrimmedContentWithCarets() {
            Lazy lazy = this.trimmedContentWithCarets$delegate;
            CellContentState cellContentState = this;
            Object var3_3 = null;
            boolean bl = false;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String getTrimmedContentWithoutCarets() {
            Lazy lazy = this.trimmedContentWithoutCarets$delegate;
            CellContentState cellContentState = this;
            Object var3_3 = null;
            boolean bl = false;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String getContentWithCarets() {
            return this.contentWithCarets;
        }

        @NotNull
        public final Caret[] getCaretsInside() {
            return this.caretsInside;
        }

        public CellContentState(@NotNull String contentWithCarets, @NotNull Caret[] caretsInside) {
            Intrinsics.checkNotNullParameter((Object)contentWithCarets, (String)"contentWithCarets");
            Intrinsics.checkNotNullParameter((Object)caretsInside, (String)"caretsInside");
            this.contentWithCarets = contentWithCarets;
            this.caretsInside = caretsInside;
            this.trimmedContentWithCarets$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ CellContentState this$0;

                @NotNull
                public final String invoke() {
                    return StringsKt.trim((String)this.this$0.getContentWithCarets(), (char[])new char[]{' '});
                }
                {
                    this.this$0 = cellContentState;
                    super(0);
                }
            }));
            this.trimmedContentWithoutCarets$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ CellContentState this$0;

                public final String invoke() {
                    return StringUtils.remove((String)this.this$0.getTrimmedContentWithCarets(), (char)'\n');
                }
                {
                    this.this$0 = cellContentState;
                    super(0);
                }
            }));
        }

        public /* synthetic */ CellContentState(String string, Caret[] caretArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                caretArray = new Caret[]{};
            }
            this(string, caretArray);
        }
    }
}

