/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.importFrom.googleDocs;

import com.google.api.client.auth.oauth2.Credential;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.importFrom.docx.MarkdownImportDocxDialog;
import org.intellij.plugins.markdown.fileActions.importFrom.googleDocs.GoogleDocsFileLoader;
import org.intellij.plugins.markdown.fileActions.importFrom.googleDocs.GoogleDocsImportTask;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/fileActions/importFrom/googleDocs/GoogleDocsImportTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "project", "Lcom/intellij/openapi/project/Project;", "credential", "Lcom/google/api/client/auth/oauth2/Credential;", "docsId", "", "suggestedFilePath", "(Lcom/intellij/openapi/project/Project;Lcom/google/api/client/auth/oauth2/Credential;Ljava/lang/String;Ljava/lang/String;)V", "loadedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "deleteFile", "", "onFinished", "onSuccess", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.markdown"})
public final class GoogleDocsImportTask
extends Task.Modal {
    private VirtualFile loadedFile;
    private final Credential credential;
    private final String docsId;
    private final String suggestedFilePath;

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ApplicationManager.getApplication().invokeAndWait(new Runnable(this){
            final /* synthetic */ GoogleDocsImportTask this$0;

            public final void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(this){
                    final /* synthetic */ run.1 this$0;

                    public final void run() {
                        GoogleDocsImportTask.access$setLoadedFile$p(this.this$0.this$0, new GoogleDocsFileLoader().loadFile(GoogleDocsImportTask.access$getCredential$p(this.this$0.this$0), GoogleDocsImportTask.access$getDocsId$p(this.this$0.this$0)));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = googleDocsImportTask;
            }
        });
    }

    public void onFinished() {
        if (this.loadedFile != null) {
            VirtualFile virtualFile = this.loadedFile;
            Intrinsics.checkNotNull((Object)virtualFile);
            if (virtualFile.exists()) {
                this.deleteFile();
            }
        }
    }

    public void onSuccess() {
        if (this.loadedFile != null) {
            String string = MarkdownBundle.message("markdown.google.docs.import.task.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026.docs.import.task.title\")");
            String importTaskTitle = string;
            String string2 = MarkdownBundle.message("markdown.google.docs.import.dialog.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MarkdownBundle.message(\"\u2026ocs.import.dialog.title\")");
            String importDialogTitle = string2;
            VirtualFile virtualFile = this.loadedFile;
            Intrinsics.checkNotNull((Object)virtualFile);
            String fullFilePath = new File(this.suggestedFilePath, virtualFile.getName()).getPath();
            VirtualFile virtualFile2 = this.loadedFile;
            Intrinsics.checkNotNull((Object)virtualFile2);
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            String string3 = fullFilePath;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fullFilePath");
            new MarkdownImportDocxDialog(virtualFile2, importTaskTitle, importDialogTitle, project, string3).show();
            this.deleteFile();
        }
    }

    private final void deleteFile() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(this){
            final /* synthetic */ GoogleDocsImportTask this$0;

            public final void run() {
                VirtualFile virtualFile = GoogleDocsImportTask.access$getLoadedFile$p(this.this$0);
                Intrinsics.checkNotNull((Object)virtualFile);
                virtualFile.delete((Object)((Object)this.this$0));
            }
            {
                this.this$0 = googleDocsImportTask;
            }
        });
    }

    public GoogleDocsImportTask(@NotNull Project project, @NotNull Credential credential, @NotNull String docsId, @NotNull String suggestedFilePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        Intrinsics.checkNotNullParameter((Object)docsId, (String)"docsId");
        Intrinsics.checkNotNullParameter((Object)suggestedFilePath, (String)"suggestedFilePath");
        super(project, MarkdownBundle.message("markdown.google.load.file.progress.title", new Object[0]), true);
        this.credential = credential;
        this.docsId = docsId;
        this.suggestedFilePath = suggestedFilePath;
    }

    public /* synthetic */ GoogleDocsImportTask(Project project, Credential credential, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            String string3 = project.getBasePath();
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        }
        this(project, credential, string, string2);
    }

    public static final /* synthetic */ VirtualFile access$getLoadedFile$p(GoogleDocsImportTask $this) {
        return $this.loadedFile;
    }

    public static final /* synthetic */ void access$setLoadedFile$p(GoogleDocsImportTask $this, VirtualFile virtualFile) {
        $this.loadedFile = virtualFile;
    }

    public static final /* synthetic */ Credential access$getCredential$p(GoogleDocsImportTask $this) {
        return $this.credential;
    }

    public static final /* synthetic */ String access$getDocsId$p(GoogleDocsImportTask $this) {
        return $this.docsId;
    }
}

