/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.collect.ImmutableMap;
import org.owasp.html.Trie;

final class HtmlEntities {
    public static final Trie<String> ENTITY_TRIE;
    private static final int LONGEST_ENTITY_NAME;

    public static int appendDecodedEntity(String html2, int offset, int limit, StringBuilder sb) {
        char ch = html2.charAt(offset);
        if ('&' != ch) {
            sb.append(ch);
            return offset + 1;
        }
        int entityLimit = Math.min(limit, offset + LONGEST_ENTITY_NAME + 2);
        int end = -1;
        int tail = -1;
        if (entityLimit == limit) {
            end = tail = entityLimit;
        }
        block12: for (int i2 = offset + 1; i2 < entityLimit; ++i2) {
            switch (html2.charAt(i2)) {
                case ';': {
                    end = i2;
                    tail = end + 1;
                    break block12;
                }
                case '#': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    continue block12;
                }
                case '=': {
                    sb.append('&');
                    return offset + 1;
                }
                default: {
                    end = i2;
                    tail = i2;
                    break block12;
                }
            }
        }
        if (end < 0 || offset + 2 >= end) {
            sb.append('&');
            return offset + 1;
        }
        char ch1 = html2.charAt(offset + 1);
        char ch2 = html2.charAt(offset + 2);
        int codepoint = -1;
        if ('#' == ch1) {
            if ('x' == ch2 || 'X' == ch2) {
                if (end == offset + 3) {
                    sb.append('&');
                    return offset + 1;
                }
                codepoint = 0;
                block13: for (int i3 = offset + 3; i3 < end; ++i3) {
                    char digit = html2.charAt(i3);
                    switch (digit & 0xFFF8) {
                        case 48: 
                        case 56: {
                            int decDig = digit & 0xF;
                            if (decDig < 10) {
                                codepoint = codepoint << 4 | decDig;
                                continue block13;
                            }
                            codepoint = -1;
                            break block13;
                        }
                        case 64: 
                        case 96: {
                            int hexDig = digit & 7;
                            if (hexDig != 0 && hexDig < 7) {
                                codepoint = codepoint << 4 | hexDig + 9;
                                continue block13;
                            }
                            codepoint = -1;
                            break block13;
                        }
                        default: {
                            codepoint = -1;
                            break block13;
                        }
                    }
                }
                if (codepoint > 0x10FFFF) {
                    codepoint = 65533;
                }
            } else {
                codepoint = 0;
                block14: for (int i4 = offset + 2; i4 < end; ++i4) {
                    char digit = html2.charAt(i4);
                    switch (digit & 0xFFF8) {
                        case 48: 
                        case 56: {
                            int decDig = digit - 48;
                            if (decDig < 10) {
                                codepoint = codepoint * 10 + decDig;
                                continue block14;
                            }
                            codepoint = -1;
                            break block14;
                        }
                        default: {
                            codepoint = -1;
                            break block14;
                        }
                    }
                }
                if (codepoint > 0x10FFFF) {
                    codepoint = 65533;
                }
            }
        } else {
            char nameChar;
            int i5;
            Trie<String> t = ENTITY_TRIE;
            for (i5 = offset + 1; i5 < end && (t = t.lookup(nameChar = html2.charAt(i5))) != null; ++i5) {
            }
            if (t == null) {
                t = ENTITY_TRIE;
                for (i5 = offset + 1; i5 < end; ++i5) {
                    nameChar = html2.charAt(i5);
                    if ('Z' >= nameChar && nameChar >= 'A') {
                        nameChar = (char)(nameChar | 0x20);
                    }
                    if ((t = t.lookup(nameChar)) == null) break;
                }
            }
            if (t != null && t.isTerminal()) {
                sb.append(t.getValue());
                return tail;
            }
        }
        if (codepoint < 0) {
            sb.append('&');
            return offset + 1;
        }
        sb.appendCodePoint(codepoint);
        return tail;
    }

    private HtmlEntities() {
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"AElig", (Object)"\u00c6");
        builder.put((Object)"AMP", (Object)"&");
        builder.put((Object)"Aacute", (Object)"\u00c1");
        builder.put((Object)"Abreve", (Object)"\u0102");
        builder.put((Object)"Acirc", (Object)"\u00c2");
        builder.put((Object)"Acy", (Object)"\u0410");
        builder.put((Object)"Afr", (Object)"\ud835\udd04");
        builder.put((Object)"Agrave", (Object)"\u00c0");
        builder.put((Object)"Alpha", (Object)"\u0391");
        builder.put((Object)"Amacr", (Object)"\u0100");
        builder.put((Object)"And", (Object)"\u2a53");
        builder.put((Object)"Aogon", (Object)"\u0104");
        builder.put((Object)"Aopf", (Object)"\ud835\udd38");
        builder.put((Object)"ApplyFunction", (Object)"\u2061");
        builder.put((Object)"Aring", (Object)"\u00c5");
        builder.put((Object)"Ascr", (Object)"\ud835\udc9c");
        builder.put((Object)"Assign", (Object)"\u2254");
        builder.put((Object)"Atilde", (Object)"\u00c3");
        builder.put((Object)"Auml", (Object)"\u00c4");
        builder.put((Object)"Backslash", (Object)"\u2216");
        builder.put((Object)"Barv", (Object)"\u2ae7");
        builder.put((Object)"Barwed", (Object)"\u2306");
        builder.put((Object)"Bcy", (Object)"\u0411");
        builder.put((Object)"Because", (Object)"\u2235");
        builder.put((Object)"Bernoullis", (Object)"\u212c");
        builder.put((Object)"Beta", (Object)"\u0392");
        builder.put((Object)"Bfr", (Object)"\ud835\udd05");
        builder.put((Object)"Bopf", (Object)"\ud835\udd39");
        builder.put((Object)"Breve", (Object)"\u02d8");
        builder.put((Object)"Bscr", (Object)"\u212c");
        builder.put((Object)"Bumpeq", (Object)"\u224e");
        builder.put((Object)"CHcy", (Object)"\u0427");
        builder.put((Object)"COPY", (Object)"\u00a9");
        builder.put((Object)"Cacute", (Object)"\u0106");
        builder.put((Object)"Cap", (Object)"\u22d2");
        builder.put((Object)"CapitalDifferentialD", (Object)"\u2145");
        builder.put((Object)"Cayleys", (Object)"\u212d");
        builder.put((Object)"Ccaron", (Object)"\u010c");
        builder.put((Object)"Ccedil", (Object)"\u00c7");
        builder.put((Object)"Ccirc", (Object)"\u0108");
        builder.put((Object)"Cconint", (Object)"\u2230");
        builder.put((Object)"Cdot", (Object)"\u010a");
        builder.put((Object)"Cedilla", (Object)"\u00b8");
        builder.put((Object)"CenterDot", (Object)"\u00b7");
        builder.put((Object)"Cfr", (Object)"\u212d");
        builder.put((Object)"Chi", (Object)"\u03a7");
        builder.put((Object)"CircleDot", (Object)"\u2299");
        builder.put((Object)"CircleMinus", (Object)"\u2296");
        builder.put((Object)"CirclePlus", (Object)"\u2295");
        builder.put((Object)"CircleTimes", (Object)"\u2297");
        builder.put((Object)"ClockwiseContourIntegral", (Object)"\u2232");
        builder.put((Object)"CloseCurlyDoubleQuote", (Object)"\u201d");
        builder.put((Object)"CloseCurlyQuote", (Object)"\u2019");
        builder.put((Object)"Colon", (Object)"\u2237");
        builder.put((Object)"Colone", (Object)"\u2a74");
        builder.put((Object)"Congruent", (Object)"\u2261");
        builder.put((Object)"Conint", (Object)"\u222f");
        builder.put((Object)"ContourIntegral", (Object)"\u222e");
        builder.put((Object)"Copf", (Object)"\u2102");
        builder.put((Object)"Coproduct", (Object)"\u2210");
        builder.put((Object)"CounterClockwiseContourIntegral", (Object)"\u2233");
        builder.put((Object)"Cross", (Object)"\u2a2f");
        builder.put((Object)"Cscr", (Object)"\ud835\udc9e");
        builder.put((Object)"Cup", (Object)"\u22d3");
        builder.put((Object)"CupCap", (Object)"\u224d");
        builder.put((Object)"DD", (Object)"\u2145");
        builder.put((Object)"DDotrahd", (Object)"\u2911");
        builder.put((Object)"DJcy", (Object)"\u0402");
        builder.put((Object)"DScy", (Object)"\u0405");
        builder.put((Object)"DZcy", (Object)"\u040f");
        builder.put((Object)"Dagger", (Object)"\u2021");
        builder.put((Object)"Darr", (Object)"\u21a1");
        builder.put((Object)"Dashv", (Object)"\u2ae4");
        builder.put((Object)"Dcaron", (Object)"\u010e");
        builder.put((Object)"Dcy", (Object)"\u0414");
        builder.put((Object)"Del", (Object)"\u2207");
        builder.put((Object)"Delta", (Object)"\u0394");
        builder.put((Object)"Dfr", (Object)"\ud835\udd07");
        builder.put((Object)"DiacriticalAcute", (Object)"\u00b4");
        builder.put((Object)"DiacriticalDot", (Object)"\u02d9");
        builder.put((Object)"DiacriticalDoubleAcute", (Object)"\u02dd");
        builder.put((Object)"DiacriticalGrave", (Object)"`");
        builder.put((Object)"DiacriticalTilde", (Object)"\u02dc");
        builder.put((Object)"Diamond", (Object)"\u22c4");
        builder.put((Object)"DifferentialD", (Object)"\u2146");
        builder.put((Object)"Dopf", (Object)"\ud835\udd3b");
        builder.put((Object)"Dot", (Object)"\u00a8");
        builder.put((Object)"DotDot", (Object)"\u20dc");
        builder.put((Object)"DotEqual", (Object)"\u2250");
        builder.put((Object)"DoubleContourIntegral", (Object)"\u222f");
        builder.put((Object)"DoubleDot", (Object)"\u00a8");
        builder.put((Object)"DoubleDownArrow", (Object)"\u21d3");
        builder.put((Object)"DoubleLeftArrow", (Object)"\u21d0");
        builder.put((Object)"DoubleLeftRightArrow", (Object)"\u21d4");
        builder.put((Object)"DoubleLeftTee", (Object)"\u2ae4");
        builder.put((Object)"DoubleLongLeftArrow", (Object)"\u27f8");
        builder.put((Object)"DoubleLongLeftRightArrow", (Object)"\u27fa");
        builder.put((Object)"DoubleLongRightArrow", (Object)"\u27f9");
        builder.put((Object)"DoubleRightArrow", (Object)"\u21d2");
        builder.put((Object)"DoubleRightTee", (Object)"\u22a8");
        builder.put((Object)"DoubleUpArrow", (Object)"\u21d1");
        builder.put((Object)"DoubleUpDownArrow", (Object)"\u21d5");
        builder.put((Object)"DoubleVerticalBar", (Object)"\u2225");
        builder.put((Object)"DownArrow", (Object)"\u2193");
        builder.put((Object)"DownArrowBar", (Object)"\u2913");
        builder.put((Object)"DownArrowUpArrow", (Object)"\u21f5");
        builder.put((Object)"DownBreve", (Object)"\u0311");
        builder.put((Object)"DownLeftRightVector", (Object)"\u2950");
        builder.put((Object)"DownLeftTeeVector", (Object)"\u295e");
        builder.put((Object)"DownLeftVector", (Object)"\u21bd");
        builder.put((Object)"DownLeftVectorBar", (Object)"\u2956");
        builder.put((Object)"DownRightTeeVector", (Object)"\u295f");
        builder.put((Object)"DownRightVector", (Object)"\u21c1");
        builder.put((Object)"DownRightVectorBar", (Object)"\u2957");
        builder.put((Object)"DownTee", (Object)"\u22a4");
        builder.put((Object)"DownTeeArrow", (Object)"\u21a7");
        builder.put((Object)"Downarrow", (Object)"\u21d3");
        builder.put((Object)"Dscr", (Object)"\ud835\udc9f");
        builder.put((Object)"Dstrok", (Object)"\u0110");
        builder.put((Object)"ENG", (Object)"\u014a");
        builder.put((Object)"ETH", (Object)"\u00d0");
        builder.put((Object)"Eacute", (Object)"\u00c9");
        builder.put((Object)"Ecaron", (Object)"\u011a");
        builder.put((Object)"Ecirc", (Object)"\u00ca");
        builder.put((Object)"Ecy", (Object)"\u042d");
        builder.put((Object)"Edot", (Object)"\u0116");
        builder.put((Object)"Efr", (Object)"\ud835\udd08");
        builder.put((Object)"Egrave", (Object)"\u00c8");
        builder.put((Object)"Element", (Object)"\u2208");
        builder.put((Object)"Emacr", (Object)"\u0112");
        builder.put((Object)"EmptySmallSquare", (Object)"\u25fb");
        builder.put((Object)"EmptyVerySmallSquare", (Object)"\u25ab");
        builder.put((Object)"Eogon", (Object)"\u0118");
        builder.put((Object)"Eopf", (Object)"\ud835\udd3c");
        builder.put((Object)"Epsilon", (Object)"\u0395");
        builder.put((Object)"Equal", (Object)"\u2a75");
        builder.put((Object)"EqualTilde", (Object)"\u2242");
        builder.put((Object)"Equilibrium", (Object)"\u21cc");
        builder.put((Object)"Escr", (Object)"\u2130");
        builder.put((Object)"Esim", (Object)"\u2a73");
        builder.put((Object)"Eta", (Object)"\u0397");
        builder.put((Object)"Euml", (Object)"\u00cb");
        builder.put((Object)"Exists", (Object)"\u2203");
        builder.put((Object)"ExponentialE", (Object)"\u2147");
        builder.put((Object)"Fcy", (Object)"\u0424");
        builder.put((Object)"Ffr", (Object)"\ud835\udd09");
        builder.put((Object)"FilledSmallSquare", (Object)"\u25fc");
        builder.put((Object)"FilledVerySmallSquare", (Object)"\u25aa");
        builder.put((Object)"Fopf", (Object)"\ud835\udd3d");
        builder.put((Object)"ForAll", (Object)"\u2200");
        builder.put((Object)"Fouriertrf", (Object)"\u2131");
        builder.put((Object)"Fscr", (Object)"\u2131");
        builder.put((Object)"GJcy", (Object)"\u0403");
        builder.put((Object)"GT", (Object)">");
        builder.put((Object)"Gamma", (Object)"\u0393");
        builder.put((Object)"Gammad", (Object)"\u03dc");
        builder.put((Object)"Gbreve", (Object)"\u011e");
        builder.put((Object)"Gcedil", (Object)"\u0122");
        builder.put((Object)"Gcirc", (Object)"\u011c");
        builder.put((Object)"Gcy", (Object)"\u0413");
        builder.put((Object)"Gdot", (Object)"\u0120");
        builder.put((Object)"Gfr", (Object)"\ud835\udd0a");
        builder.put((Object)"Gg", (Object)"\u22d9");
        builder.put((Object)"Gopf", (Object)"\ud835\udd3e");
        builder.put((Object)"GreaterEqual", (Object)"\u2265");
        builder.put((Object)"GreaterEqualLess", (Object)"\u22db");
        builder.put((Object)"GreaterFullEqual", (Object)"\u2267");
        builder.put((Object)"GreaterGreater", (Object)"\u2aa2");
        builder.put((Object)"GreaterLess", (Object)"\u2277");
        builder.put((Object)"GreaterSlantEqual", (Object)"\u2a7e");
        builder.put((Object)"GreaterTilde", (Object)"\u2273");
        builder.put((Object)"Gscr", (Object)"\ud835\udca2");
        builder.put((Object)"Gt", (Object)"\u226b");
        builder.put((Object)"HARDcy", (Object)"\u042a");
        builder.put((Object)"Hacek", (Object)"\u02c7");
        builder.put((Object)"Hat", (Object)"^");
        builder.put((Object)"Hcirc", (Object)"\u0124");
        builder.put((Object)"Hfr", (Object)"\u210c");
        builder.put((Object)"HilbertSpace", (Object)"\u210b");
        builder.put((Object)"Hopf", (Object)"\u210d");
        builder.put((Object)"HorizontalLine", (Object)"\u2500");
        builder.put((Object)"Hscr", (Object)"\u210b");
        builder.put((Object)"Hstrok", (Object)"\u0126");
        builder.put((Object)"HumpDownHump", (Object)"\u224e");
        builder.put((Object)"HumpEqual", (Object)"\u224f");
        builder.put((Object)"IEcy", (Object)"\u0415");
        builder.put((Object)"IJlig", (Object)"\u0132");
        builder.put((Object)"IOcy", (Object)"\u0401");
        builder.put((Object)"Iacute", (Object)"\u00cd");
        builder.put((Object)"Icirc", (Object)"\u00ce");
        builder.put((Object)"Icy", (Object)"\u0418");
        builder.put((Object)"Idot", (Object)"\u0130");
        builder.put((Object)"Ifr", (Object)"\u2111");
        builder.put((Object)"Igrave", (Object)"\u00cc");
        builder.put((Object)"Im", (Object)"\u2111");
        builder.put((Object)"Imacr", (Object)"\u012a");
        builder.put((Object)"ImaginaryI", (Object)"\u2148");
        builder.put((Object)"Implies", (Object)"\u21d2");
        builder.put((Object)"Int", (Object)"\u222c");
        builder.put((Object)"Integral", (Object)"\u222b");
        builder.put((Object)"Intersection", (Object)"\u22c2");
        builder.put((Object)"InvisibleComma", (Object)"\u2063");
        builder.put((Object)"InvisibleTimes", (Object)"\u2062");
        builder.put((Object)"Iogon", (Object)"\u012e");
        builder.put((Object)"Iopf", (Object)"\ud835\udd40");
        builder.put((Object)"Iota", (Object)"\u0399");
        builder.put((Object)"Iscr", (Object)"\u2110");
        builder.put((Object)"Itilde", (Object)"\u0128");
        builder.put((Object)"Iukcy", (Object)"\u0406");
        builder.put((Object)"Iuml", (Object)"\u00cf");
        builder.put((Object)"Jcirc", (Object)"\u0134");
        builder.put((Object)"Jcy", (Object)"\u0419");
        builder.put((Object)"Jfr", (Object)"\ud835\udd0d");
        builder.put((Object)"Jopf", (Object)"\ud835\udd41");
        builder.put((Object)"Jscr", (Object)"\ud835\udca5");
        builder.put((Object)"Jsercy", (Object)"\u0408");
        builder.put((Object)"Jukcy", (Object)"\u0404");
        builder.put((Object)"KHcy", (Object)"\u0425");
        builder.put((Object)"KJcy", (Object)"\u040c");
        builder.put((Object)"Kappa", (Object)"\u039a");
        builder.put((Object)"Kcedil", (Object)"\u0136");
        builder.put((Object)"Kcy", (Object)"\u041a");
        builder.put((Object)"Kfr", (Object)"\ud835\udd0e");
        builder.put((Object)"Kopf", (Object)"\ud835\udd42");
        builder.put((Object)"Kscr", (Object)"\ud835\udca6");
        builder.put((Object)"LJcy", (Object)"\u0409");
        builder.put((Object)"LT", (Object)"<");
        builder.put((Object)"Lacute", (Object)"\u0139");
        builder.put((Object)"Lambda", (Object)"\u039b");
        builder.put((Object)"Lang", (Object)"\u27ea");
        builder.put((Object)"Laplacetrf", (Object)"\u2112");
        builder.put((Object)"Larr", (Object)"\u219e");
        builder.put((Object)"Lcaron", (Object)"\u013d");
        builder.put((Object)"Lcedil", (Object)"\u013b");
        builder.put((Object)"Lcy", (Object)"\u041b");
        builder.put((Object)"LeftAngleBracket", (Object)"\u27e8");
        builder.put((Object)"LeftArrow", (Object)"\u2190");
        builder.put((Object)"LeftArrowBar", (Object)"\u21e4");
        builder.put((Object)"LeftArrowRightArrow", (Object)"\u21c6");
        builder.put((Object)"LeftCeiling", (Object)"\u2308");
        builder.put((Object)"LeftDoubleBracket", (Object)"\u27e6");
        builder.put((Object)"LeftDownTeeVector", (Object)"\u2961");
        builder.put((Object)"LeftDownVector", (Object)"\u21c3");
        builder.put((Object)"LeftDownVectorBar", (Object)"\u2959");
        builder.put((Object)"LeftFloor", (Object)"\u230a");
        builder.put((Object)"LeftRightArrow", (Object)"\u2194");
        builder.put((Object)"LeftRightVector", (Object)"\u294e");
        builder.put((Object)"LeftTee", (Object)"\u22a3");
        builder.put((Object)"LeftTeeArrow", (Object)"\u21a4");
        builder.put((Object)"LeftTeeVector", (Object)"\u295a");
        builder.put((Object)"LeftTriangle", (Object)"\u22b2");
        builder.put((Object)"LeftTriangleBar", (Object)"\u29cf");
        builder.put((Object)"LeftTriangleEqual", (Object)"\u22b4");
        builder.put((Object)"LeftUpDownVector", (Object)"\u2951");
        builder.put((Object)"LeftUpTeeVector", (Object)"\u2960");
        builder.put((Object)"LeftUpVector", (Object)"\u21bf");
        builder.put((Object)"LeftUpVectorBar", (Object)"\u2958");
        builder.put((Object)"LeftVector", (Object)"\u21bc");
        builder.put((Object)"LeftVectorBar", (Object)"\u2952");
        builder.put((Object)"Leftarrow", (Object)"\u21d0");
        builder.put((Object)"Leftrightarrow", (Object)"\u21d4");
        builder.put((Object)"LessEqualGreater", (Object)"\u22da");
        builder.put((Object)"LessFullEqual", (Object)"\u2266");
        builder.put((Object)"LessGreater", (Object)"\u2276");
        builder.put((Object)"LessLess", (Object)"\u2aa1");
        builder.put((Object)"LessSlantEqual", (Object)"\u2a7d");
        builder.put((Object)"LessTilde", (Object)"\u2272");
        builder.put((Object)"Lfr", (Object)"\ud835\udd0f");
        builder.put((Object)"Ll", (Object)"\u22d8");
        builder.put((Object)"Lleftarrow", (Object)"\u21da");
        builder.put((Object)"Lmidot", (Object)"\u013f");
        builder.put((Object)"LongLeftArrow", (Object)"\u27f5");
        builder.put((Object)"LongLeftRightArrow", (Object)"\u27f7");
        builder.put((Object)"LongRightArrow", (Object)"\u27f6");
        builder.put((Object)"Longleftarrow", (Object)"\u27f8");
        builder.put((Object)"Longleftrightarrow", (Object)"\u27fa");
        builder.put((Object)"Longrightarrow", (Object)"\u27f9");
        builder.put((Object)"Lopf", (Object)"\ud835\udd43");
        builder.put((Object)"LowerLeftArrow", (Object)"\u2199");
        builder.put((Object)"LowerRightArrow", (Object)"\u2198");
        builder.put((Object)"Lscr", (Object)"\u2112");
        builder.put((Object)"Lsh", (Object)"\u21b0");
        builder.put((Object)"Lstrok", (Object)"\u0141");
        builder.put((Object)"Lt", (Object)"\u226a");
        builder.put((Object)"Map", (Object)"\u2905");
        builder.put((Object)"Mcy", (Object)"\u041c");
        builder.put((Object)"MediumSpace", (Object)"\u205f");
        builder.put((Object)"Mellintrf", (Object)"\u2133");
        builder.put((Object)"Mfr", (Object)"\ud835\udd10");
        builder.put((Object)"MinusPlus", (Object)"\u2213");
        builder.put((Object)"Mopf", (Object)"\ud835\udd44");
        builder.put((Object)"Mscr", (Object)"\u2133");
        builder.put((Object)"Mu", (Object)"\u039c");
        builder.put((Object)"NJcy", (Object)"\u040a");
        builder.put((Object)"Nacute", (Object)"\u0143");
        builder.put((Object)"Ncaron", (Object)"\u0147");
        builder.put((Object)"Ncedil", (Object)"\u0145");
        builder.put((Object)"Ncy", (Object)"\u041d");
        builder.put((Object)"NegativeMediumSpace", (Object)"\u200b");
        builder.put((Object)"NegativeThickSpace", (Object)"\u200b");
        builder.put((Object)"NegativeThinSpace", (Object)"\u200b");
        builder.put((Object)"NegativeVeryThinSpace", (Object)"\u200b");
        builder.put((Object)"NestedGreaterGreater", (Object)"\u226b");
        builder.put((Object)"NestedLessLess", (Object)"\u226a");
        builder.put((Object)"NewLine", (Object)"\n");
        builder.put((Object)"Nfr", (Object)"\ud835\udd11");
        builder.put((Object)"NoBreak", (Object)"\u2060");
        builder.put((Object)"NonBreakingSpace", (Object)"\u00a0");
        builder.put((Object)"Nopf", (Object)"\u2115");
        builder.put((Object)"Not", (Object)"\u2aec");
        builder.put((Object)"NotCongruent", (Object)"\u2262");
        builder.put((Object)"NotCupCap", (Object)"\u226d");
        builder.put((Object)"NotDoubleVerticalBar", (Object)"\u2226");
        builder.put((Object)"NotElement", (Object)"\u2209");
        builder.put((Object)"NotEqual", (Object)"\u2260");
        builder.put((Object)"NotEqualTilde", (Object)"\u2242\u0338");
        builder.put((Object)"NotExists", (Object)"\u2204");
        builder.put((Object)"NotGreater", (Object)"\u226f");
        builder.put((Object)"NotGreaterEqual", (Object)"\u2271");
        builder.put((Object)"NotGreaterFullEqual", (Object)"\u2267\u0338");
        builder.put((Object)"NotGreaterGreater", (Object)"\u226b\u0338");
        builder.put((Object)"NotGreaterLess", (Object)"\u2279");
        builder.put((Object)"NotGreaterSlantEqual", (Object)"\u2a7e\u0338");
        builder.put((Object)"NotGreaterTilde", (Object)"\u2275");
        builder.put((Object)"NotHumpDownHump", (Object)"\u224e\u0338");
        builder.put((Object)"NotHumpEqual", (Object)"\u224f\u0338");
        builder.put((Object)"NotLeftTriangle", (Object)"\u22ea");
        builder.put((Object)"NotLeftTriangleBar", (Object)"\u29cf\u0338");
        builder.put((Object)"NotLeftTriangleEqual", (Object)"\u22ec");
        builder.put((Object)"NotLess", (Object)"\u226e");
        builder.put((Object)"NotLessEqual", (Object)"\u2270");
        builder.put((Object)"NotLessGreater", (Object)"\u2278");
        builder.put((Object)"NotLessLess", (Object)"\u226a\u0338");
        builder.put((Object)"NotLessSlantEqual", (Object)"\u2a7d\u0338");
        builder.put((Object)"NotLessTilde", (Object)"\u2274");
        builder.put((Object)"NotNestedGreaterGreater", (Object)"\u2aa2\u0338");
        builder.put((Object)"NotNestedLessLess", (Object)"\u2aa1\u0338");
        builder.put((Object)"NotPrecedes", (Object)"\u2280");
        builder.put((Object)"NotPrecedesEqual", (Object)"\u2aaf\u0338");
        builder.put((Object)"NotPrecedesSlantEqual", (Object)"\u22e0");
        builder.put((Object)"NotReverseElement", (Object)"\u220c");
        builder.put((Object)"NotRightTriangle", (Object)"\u22eb");
        builder.put((Object)"NotRightTriangleBar", (Object)"\u29d0\u0338");
        builder.put((Object)"NotRightTriangleEqual", (Object)"\u22ed");
        builder.put((Object)"NotSquareSubset", (Object)"\u228f\u0338");
        builder.put((Object)"NotSquareSubsetEqual", (Object)"\u22e2");
        builder.put((Object)"NotSquareSuperset", (Object)"\u2290\u0338");
        builder.put((Object)"NotSquareSupersetEqual", (Object)"\u22e3");
        builder.put((Object)"NotSubset", (Object)"\u2282\u20d2");
        builder.put((Object)"NotSubsetEqual", (Object)"\u2288");
        builder.put((Object)"NotSucceeds", (Object)"\u2281");
        builder.put((Object)"NotSucceedsEqual", (Object)"\u2ab0\u0338");
        builder.put((Object)"NotSucceedsSlantEqual", (Object)"\u22e1");
        builder.put((Object)"NotSucceedsTilde", (Object)"\u227f\u0338");
        builder.put((Object)"NotSuperset", (Object)"\u2283\u20d2");
        builder.put((Object)"NotSupersetEqual", (Object)"\u2289");
        builder.put((Object)"NotTilde", (Object)"\u2241");
        builder.put((Object)"NotTildeEqual", (Object)"\u2244");
        builder.put((Object)"NotTildeFullEqual", (Object)"\u2247");
        builder.put((Object)"NotTildeTilde", (Object)"\u2249");
        builder.put((Object)"NotVerticalBar", (Object)"\u2224");
        builder.put((Object)"Nscr", (Object)"\ud835\udca9");
        builder.put((Object)"Ntilde", (Object)"\u00d1");
        builder.put((Object)"Nu", (Object)"\u039d");
        builder.put((Object)"OElig", (Object)"\u0152");
        builder.put((Object)"Oacute", (Object)"\u00d3");
        builder.put((Object)"Ocirc", (Object)"\u00d4");
        builder.put((Object)"Ocy", (Object)"\u041e");
        builder.put((Object)"Odblac", (Object)"\u0150");
        builder.put((Object)"Ofr", (Object)"\ud835\udd12");
        builder.put((Object)"Ograve", (Object)"\u00d2");
        builder.put((Object)"Omacr", (Object)"\u014c");
        builder.put((Object)"Omega", (Object)"\u03a9");
        builder.put((Object)"Omicron", (Object)"\u039f");
        builder.put((Object)"Oopf", (Object)"\ud835\udd46");
        builder.put((Object)"OpenCurlyDoubleQuote", (Object)"\u201c");
        builder.put((Object)"OpenCurlyQuote", (Object)"\u2018");
        builder.put((Object)"Or", (Object)"\u2a54");
        builder.put((Object)"Oscr", (Object)"\ud835\udcaa");
        builder.put((Object)"Oslash", (Object)"\u00d8");
        builder.put((Object)"Otilde", (Object)"\u00d5");
        builder.put((Object)"Otimes", (Object)"\u2a37");
        builder.put((Object)"Ouml", (Object)"\u00d6");
        builder.put((Object)"OverBar", (Object)"\u203e");
        builder.put((Object)"OverBrace", (Object)"\u23de");
        builder.put((Object)"OverBracket", (Object)"\u23b4");
        builder.put((Object)"OverParenthesis", (Object)"\u23dc");
        builder.put((Object)"PartialD", (Object)"\u2202");
        builder.put((Object)"Pcy", (Object)"\u041f");
        builder.put((Object)"Pfr", (Object)"\ud835\udd13");
        builder.put((Object)"Phi", (Object)"\u03a6");
        builder.put((Object)"Pi", (Object)"\u03a0");
        builder.put((Object)"PlusMinus", (Object)"\u00b1");
        builder.put((Object)"Poincareplane", (Object)"\u210c");
        builder.put((Object)"Popf", (Object)"\u2119");
        builder.put((Object)"Pr", (Object)"\u2abb");
        builder.put((Object)"Precedes", (Object)"\u227a");
        builder.put((Object)"PrecedesEqual", (Object)"\u2aaf");
        builder.put((Object)"PrecedesSlantEqual", (Object)"\u227c");
        builder.put((Object)"PrecedesTilde", (Object)"\u227e");
        builder.put((Object)"Prime", (Object)"\u2033");
        builder.put((Object)"Product", (Object)"\u220f");
        builder.put((Object)"Proportion", (Object)"\u2237");
        builder.put((Object)"Proportional", (Object)"\u221d");
        builder.put((Object)"Pscr", (Object)"\ud835\udcab");
        builder.put((Object)"Psi", (Object)"\u03a8");
        builder.put((Object)"QUOT", (Object)"\"");
        builder.put((Object)"Qfr", (Object)"\ud835\udd14");
        builder.put((Object)"Qopf", (Object)"\u211a");
        builder.put((Object)"Qscr", (Object)"\ud835\udcac");
        builder.put((Object)"RBarr", (Object)"\u2910");
        builder.put((Object)"REG", (Object)"\u00ae");
        builder.put((Object)"Racute", (Object)"\u0154");
        builder.put((Object)"Rang", (Object)"\u27eb");
        builder.put((Object)"Rarr", (Object)"\u21a0");
        builder.put((Object)"Rarrtl", (Object)"\u2916");
        builder.put((Object)"Rcaron", (Object)"\u0158");
        builder.put((Object)"Rcedil", (Object)"\u0156");
        builder.put((Object)"Rcy", (Object)"\u0420");
        builder.put((Object)"Re", (Object)"\u211c");
        builder.put((Object)"ReverseElement", (Object)"\u220b");
        builder.put((Object)"ReverseEquilibrium", (Object)"\u21cb");
        builder.put((Object)"ReverseUpEquilibrium", (Object)"\u296f");
        builder.put((Object)"Rfr", (Object)"\u211c");
        builder.put((Object)"Rho", (Object)"\u03a1");
        builder.put((Object)"RightAngleBracket", (Object)"\u27e9");
        builder.put((Object)"RightArrow", (Object)"\u2192");
        builder.put((Object)"RightArrowBar", (Object)"\u21e5");
        builder.put((Object)"RightArrowLeftArrow", (Object)"\u21c4");
        builder.put((Object)"RightCeiling", (Object)"\u2309");
        builder.put((Object)"RightDoubleBracket", (Object)"\u27e7");
        builder.put((Object)"RightDownTeeVector", (Object)"\u295d");
        builder.put((Object)"RightDownVector", (Object)"\u21c2");
        builder.put((Object)"RightDownVectorBar", (Object)"\u2955");
        builder.put((Object)"RightFloor", (Object)"\u230b");
        builder.put((Object)"RightTee", (Object)"\u22a2");
        builder.put((Object)"RightTeeArrow", (Object)"\u21a6");
        builder.put((Object)"RightTeeVector", (Object)"\u295b");
        builder.put((Object)"RightTriangle", (Object)"\u22b3");
        builder.put((Object)"RightTriangleBar", (Object)"\u29d0");
        builder.put((Object)"RightTriangleEqual", (Object)"\u22b5");
        builder.put((Object)"RightUpDownVector", (Object)"\u294f");
        builder.put((Object)"RightUpTeeVector", (Object)"\u295c");
        builder.put((Object)"RightUpVector", (Object)"\u21be");
        builder.put((Object)"RightUpVectorBar", (Object)"\u2954");
        builder.put((Object)"RightVector", (Object)"\u21c0");
        builder.put((Object)"RightVectorBar", (Object)"\u2953");
        builder.put((Object)"Rightarrow", (Object)"\u21d2");
        builder.put((Object)"Ropf", (Object)"\u211d");
        builder.put((Object)"RoundImplies", (Object)"\u2970");
        builder.put((Object)"Rrightarrow", (Object)"\u21db");
        builder.put((Object)"Rscr", (Object)"\u211b");
        builder.put((Object)"Rsh", (Object)"\u21b1");
        builder.put((Object)"RuleDelayed", (Object)"\u29f4");
        builder.put((Object)"SHCHcy", (Object)"\u0429");
        builder.put((Object)"SHcy", (Object)"\u0428");
        builder.put((Object)"SOFTcy", (Object)"\u042c");
        builder.put((Object)"Sacute", (Object)"\u015a");
        builder.put((Object)"Sc", (Object)"\u2abc");
        builder.put((Object)"Scaron", (Object)"\u0160");
        builder.put((Object)"Scedil", (Object)"\u015e");
        builder.put((Object)"Scirc", (Object)"\u015c");
        builder.put((Object)"Scy", (Object)"\u0421");
        builder.put((Object)"Sfr", (Object)"\ud835\udd16");
        builder.put((Object)"ShortDownArrow", (Object)"\u2193");
        builder.put((Object)"ShortLeftArrow", (Object)"\u2190");
        builder.put((Object)"ShortRightArrow", (Object)"\u2192");
        builder.put((Object)"ShortUpArrow", (Object)"\u2191");
        builder.put((Object)"Sigma", (Object)"\u03a3");
        builder.put((Object)"SmallCircle", (Object)"\u2218");
        builder.put((Object)"Sopf", (Object)"\ud835\udd4a");
        builder.put((Object)"Sqrt", (Object)"\u221a");
        builder.put((Object)"Square", (Object)"\u25a1");
        builder.put((Object)"SquareIntersection", (Object)"\u2293");
        builder.put((Object)"SquareSubset", (Object)"\u228f");
        builder.put((Object)"SquareSubsetEqual", (Object)"\u2291");
        builder.put((Object)"SquareSuperset", (Object)"\u2290");
        builder.put((Object)"SquareSupersetEqual", (Object)"\u2292");
        builder.put((Object)"SquareUnion", (Object)"\u2294");
        builder.put((Object)"Sscr", (Object)"\ud835\udcae");
        builder.put((Object)"Star", (Object)"\u22c6");
        builder.put((Object)"Sub", (Object)"\u22d0");
        builder.put((Object)"Subset", (Object)"\u22d0");
        builder.put((Object)"SubsetEqual", (Object)"\u2286");
        builder.put((Object)"Succeeds", (Object)"\u227b");
        builder.put((Object)"SucceedsEqual", (Object)"\u2ab0");
        builder.put((Object)"SucceedsSlantEqual", (Object)"\u227d");
        builder.put((Object)"SucceedsTilde", (Object)"\u227f");
        builder.put((Object)"SuchThat", (Object)"\u220b");
        builder.put((Object)"Sum", (Object)"\u2211");
        builder.put((Object)"Sup", (Object)"\u22d1");
        builder.put((Object)"Superset", (Object)"\u2283");
        builder.put((Object)"SupersetEqual", (Object)"\u2287");
        builder.put((Object)"Supset", (Object)"\u22d1");
        builder.put((Object)"THORN", (Object)"\u00de");
        builder.put((Object)"TRADE", (Object)"\u2122");
        builder.put((Object)"TSHcy", (Object)"\u040b");
        builder.put((Object)"TScy", (Object)"\u0426");
        builder.put((Object)"Tab", (Object)"\t");
        builder.put((Object)"Tau", (Object)"\u03a4");
        builder.put((Object)"Tcaron", (Object)"\u0164");
        builder.put((Object)"Tcedil", (Object)"\u0162");
        builder.put((Object)"Tcy", (Object)"\u0422");
        builder.put((Object)"Tfr", (Object)"\ud835\udd17");
        builder.put((Object)"Therefore", (Object)"\u2234");
        builder.put((Object)"Theta", (Object)"\u0398");
        builder.put((Object)"ThickSpace", (Object)"\u205f\u200a");
        builder.put((Object)"ThinSpace", (Object)"\u2009");
        builder.put((Object)"Tilde", (Object)"\u223c");
        builder.put((Object)"TildeEqual", (Object)"\u2243");
        builder.put((Object)"TildeFullEqual", (Object)"\u2245");
        builder.put((Object)"TildeTilde", (Object)"\u2248");
        builder.put((Object)"Topf", (Object)"\ud835\udd4b");
        builder.put((Object)"TripleDot", (Object)"\u20db");
        builder.put((Object)"Tscr", (Object)"\ud835\udcaf");
        builder.put((Object)"Tstrok", (Object)"\u0166");
        builder.put((Object)"Uacute", (Object)"\u00da");
        builder.put((Object)"Uarr", (Object)"\u219f");
        builder.put((Object)"Uarrocir", (Object)"\u2949");
        builder.put((Object)"Ubrcy", (Object)"\u040e");
        builder.put((Object)"Ubreve", (Object)"\u016c");
        builder.put((Object)"Ucirc", (Object)"\u00db");
        builder.put((Object)"Ucy", (Object)"\u0423");
        builder.put((Object)"Udblac", (Object)"\u0170");
        builder.put((Object)"Ufr", (Object)"\ud835\udd18");
        builder.put((Object)"Ugrave", (Object)"\u00d9");
        builder.put((Object)"Umacr", (Object)"\u016a");
        builder.put((Object)"UnderBar", (Object)"_");
        builder.put((Object)"UnderBrace", (Object)"\u23df");
        builder.put((Object)"UnderBracket", (Object)"\u23b5");
        builder.put((Object)"UnderParenthesis", (Object)"\u23dd");
        builder.put((Object)"Union", (Object)"\u22c3");
        builder.put((Object)"UnionPlus", (Object)"\u228e");
        builder.put((Object)"Uogon", (Object)"\u0172");
        builder.put((Object)"Uopf", (Object)"\ud835\udd4c");
        builder.put((Object)"UpArrow", (Object)"\u2191");
        builder.put((Object)"UpArrowBar", (Object)"\u2912");
        builder.put((Object)"UpArrowDownArrow", (Object)"\u21c5");
        builder.put((Object)"UpDownArrow", (Object)"\u2195");
        builder.put((Object)"UpEquilibrium", (Object)"\u296e");
        builder.put((Object)"UpTee", (Object)"\u22a5");
        builder.put((Object)"UpTeeArrow", (Object)"\u21a5");
        builder.put((Object)"Uparrow", (Object)"\u21d1");
        builder.put((Object)"Updownarrow", (Object)"\u21d5");
        builder.put((Object)"UpperLeftArrow", (Object)"\u2196");
        builder.put((Object)"UpperRightArrow", (Object)"\u2197");
        builder.put((Object)"Upsi", (Object)"\u03d2");
        builder.put((Object)"Upsilon", (Object)"\u03a5");
        builder.put((Object)"Uring", (Object)"\u016e");
        builder.put((Object)"Uscr", (Object)"\ud835\udcb0");
        builder.put((Object)"Utilde", (Object)"\u0168");
        builder.put((Object)"Uuml", (Object)"\u00dc");
        builder.put((Object)"VDash", (Object)"\u22ab");
        builder.put((Object)"Vbar", (Object)"\u2aeb");
        builder.put((Object)"Vcy", (Object)"\u0412");
        builder.put((Object)"Vdash", (Object)"\u22a9");
        builder.put((Object)"Vdashl", (Object)"\u2ae6");
        builder.put((Object)"Vee", (Object)"\u22c1");
        builder.put((Object)"Verbar", (Object)"\u2016");
        builder.put((Object)"Vert", (Object)"\u2016");
        builder.put((Object)"VerticalBar", (Object)"\u2223");
        builder.put((Object)"VerticalLine", (Object)"|");
        builder.put((Object)"VerticalSeparator", (Object)"\u2758");
        builder.put((Object)"VerticalTilde", (Object)"\u2240");
        builder.put((Object)"VeryThinSpace", (Object)"\u200a");
        builder.put((Object)"Vfr", (Object)"\ud835\udd19");
        builder.put((Object)"Vopf", (Object)"\ud835\udd4d");
        builder.put((Object)"Vscr", (Object)"\ud835\udcb1");
        builder.put((Object)"Vvdash", (Object)"\u22aa");
        builder.put((Object)"Wcirc", (Object)"\u0174");
        builder.put((Object)"Wedge", (Object)"\u22c0");
        builder.put((Object)"Wfr", (Object)"\ud835\udd1a");
        builder.put((Object)"Wopf", (Object)"\ud835\udd4e");
        builder.put((Object)"Wscr", (Object)"\ud835\udcb2");
        builder.put((Object)"Xfr", (Object)"\ud835\udd1b");
        builder.put((Object)"Xi", (Object)"\u039e");
        builder.put((Object)"Xopf", (Object)"\ud835\udd4f");
        builder.put((Object)"Xscr", (Object)"\ud835\udcb3");
        builder.put((Object)"YAcy", (Object)"\u042f");
        builder.put((Object)"YIcy", (Object)"\u0407");
        builder.put((Object)"YUcy", (Object)"\u042e");
        builder.put((Object)"Yacute", (Object)"\u00dd");
        builder.put((Object)"Ycirc", (Object)"\u0176");
        builder.put((Object)"Ycy", (Object)"\u042b");
        builder.put((Object)"Yfr", (Object)"\ud835\udd1c");
        builder.put((Object)"Yopf", (Object)"\ud835\udd50");
        builder.put((Object)"Yscr", (Object)"\ud835\udcb4");
        builder.put((Object)"Yuml", (Object)"\u0178");
        builder.put((Object)"ZHcy", (Object)"\u0416");
        builder.put((Object)"Zacute", (Object)"\u0179");
        builder.put((Object)"Zcaron", (Object)"\u017d");
        builder.put((Object)"Zcy", (Object)"\u0417");
        builder.put((Object)"Zdot", (Object)"\u017b");
        builder.put((Object)"ZeroWidthSpace", (Object)"\u200b");
        builder.put((Object)"Zeta", (Object)"\u0396");
        builder.put((Object)"Zfr", (Object)"\u2128");
        builder.put((Object)"Zopf", (Object)"\u2124");
        builder.put((Object)"Zscr", (Object)"\ud835\udcb5");
        builder.put((Object)"aacute", (Object)"\u00e1");
        builder.put((Object)"abreve", (Object)"\u0103");
        builder.put((Object)"ac", (Object)"\u223e");
        builder.put((Object)"acE", (Object)"\u223e\u0333");
        builder.put((Object)"acd", (Object)"\u223f");
        builder.put((Object)"acirc", (Object)"\u00e2");
        builder.put((Object)"acute", (Object)"\u00b4");
        builder.put((Object)"acy", (Object)"\u0430");
        builder.put((Object)"aelig", (Object)"\u00e6");
        builder.put((Object)"af", (Object)"\u2061");
        builder.put((Object)"afr", (Object)"\ud835\udd1e");
        builder.put((Object)"agrave", (Object)"\u00e0");
        builder.put((Object)"alefsym", (Object)"\u2135");
        builder.put((Object)"aleph", (Object)"\u2135");
        builder.put((Object)"alpha", (Object)"\u03b1");
        builder.put((Object)"amacr", (Object)"\u0101");
        builder.put((Object)"amalg", (Object)"\u2a3f");
        builder.put((Object)"amp", (Object)"&");
        builder.put((Object)"and", (Object)"\u2227");
        builder.put((Object)"andand", (Object)"\u2a55");
        builder.put((Object)"andd", (Object)"\u2a5c");
        builder.put((Object)"andslope", (Object)"\u2a58");
        builder.put((Object)"andv", (Object)"\u2a5a");
        builder.put((Object)"ang", (Object)"\u2220");
        builder.put((Object)"ange", (Object)"\u29a4");
        builder.put((Object)"angle", (Object)"\u2220");
        builder.put((Object)"angmsd", (Object)"\u2221");
        builder.put((Object)"angmsdaa", (Object)"\u29a8");
        builder.put((Object)"angmsdab", (Object)"\u29a9");
        builder.put((Object)"angmsdac", (Object)"\u29aa");
        builder.put((Object)"angmsdad", (Object)"\u29ab");
        builder.put((Object)"angmsdae", (Object)"\u29ac");
        builder.put((Object)"angmsdaf", (Object)"\u29ad");
        builder.put((Object)"angmsdag", (Object)"\u29ae");
        builder.put((Object)"angmsdah", (Object)"\u29af");
        builder.put((Object)"angrt", (Object)"\u221f");
        builder.put((Object)"angrtvb", (Object)"\u22be");
        builder.put((Object)"angrtvbd", (Object)"\u299d");
        builder.put((Object)"angsph", (Object)"\u2222");
        builder.put((Object)"angst", (Object)"\u00c5");
        builder.put((Object)"angzarr", (Object)"\u237c");
        builder.put((Object)"aogon", (Object)"\u0105");
        builder.put((Object)"aopf", (Object)"\ud835\udd52");
        builder.put((Object)"ap", (Object)"\u2248");
        builder.put((Object)"apE", (Object)"\u2a70");
        builder.put((Object)"apacir", (Object)"\u2a6f");
        builder.put((Object)"ape", (Object)"\u224a");
        builder.put((Object)"apid", (Object)"\u224b");
        builder.put((Object)"apos", (Object)"'");
        builder.put((Object)"approx", (Object)"\u2248");
        builder.put((Object)"approxeq", (Object)"\u224a");
        builder.put((Object)"aring", (Object)"\u00e5");
        builder.put((Object)"ascr", (Object)"\ud835\udcb6");
        builder.put((Object)"ast", (Object)"*");
        builder.put((Object)"asymp", (Object)"\u2248");
        builder.put((Object)"asympeq", (Object)"\u224d");
        builder.put((Object)"atilde", (Object)"\u00e3");
        builder.put((Object)"auml", (Object)"\u00e4");
        builder.put((Object)"awconint", (Object)"\u2233");
        builder.put((Object)"awint", (Object)"\u2a11");
        builder.put((Object)"bNot", (Object)"\u2aed");
        builder.put((Object)"backcong", (Object)"\u224c");
        builder.put((Object)"backepsilon", (Object)"\u03f6");
        builder.put((Object)"backprime", (Object)"\u2035");
        builder.put((Object)"backsim", (Object)"\u223d");
        builder.put((Object)"backsimeq", (Object)"\u22cd");
        builder.put((Object)"barvee", (Object)"\u22bd");
        builder.put((Object)"barwed", (Object)"\u2305");
        builder.put((Object)"barwedge", (Object)"\u2305");
        builder.put((Object)"bbrk", (Object)"\u23b5");
        builder.put((Object)"bbrktbrk", (Object)"\u23b6");
        builder.put((Object)"bcong", (Object)"\u224c");
        builder.put((Object)"bcy", (Object)"\u0431");
        builder.put((Object)"bdquo", (Object)"\u201e");
        builder.put((Object)"becaus", (Object)"\u2235");
        builder.put((Object)"because", (Object)"\u2235");
        builder.put((Object)"bemptyv", (Object)"\u29b0");
        builder.put((Object)"bepsi", (Object)"\u03f6");
        builder.put((Object)"bernou", (Object)"\u212c");
        builder.put((Object)"beta", (Object)"\u03b2");
        builder.put((Object)"beth", (Object)"\u2136");
        builder.put((Object)"between", (Object)"\u226c");
        builder.put((Object)"bfr", (Object)"\ud835\udd1f");
        builder.put((Object)"bigcap", (Object)"\u22c2");
        builder.put((Object)"bigcirc", (Object)"\u25ef");
        builder.put((Object)"bigcup", (Object)"\u22c3");
        builder.put((Object)"bigodot", (Object)"\u2a00");
        builder.put((Object)"bigoplus", (Object)"\u2a01");
        builder.put((Object)"bigotimes", (Object)"\u2a02");
        builder.put((Object)"bigsqcup", (Object)"\u2a06");
        builder.put((Object)"bigstar", (Object)"\u2605");
        builder.put((Object)"bigtriangledown", (Object)"\u25bd");
        builder.put((Object)"bigtriangleup", (Object)"\u25b3");
        builder.put((Object)"biguplus", (Object)"\u2a04");
        builder.put((Object)"bigvee", (Object)"\u22c1");
        builder.put((Object)"bigwedge", (Object)"\u22c0");
        builder.put((Object)"bkarow", (Object)"\u290d");
        builder.put((Object)"blacklozenge", (Object)"\u29eb");
        builder.put((Object)"blacksquare", (Object)"\u25aa");
        builder.put((Object)"blacktriangle", (Object)"\u25b4");
        builder.put((Object)"blacktriangledown", (Object)"\u25be");
        builder.put((Object)"blacktriangleleft", (Object)"\u25c2");
        builder.put((Object)"blacktriangleright", (Object)"\u25b8");
        builder.put((Object)"blank", (Object)"\u2423");
        builder.put((Object)"blk12", (Object)"\u2592");
        builder.put((Object)"blk14", (Object)"\u2591");
        builder.put((Object)"blk34", (Object)"\u2593");
        builder.put((Object)"block", (Object)"\u2588");
        builder.put((Object)"bne", (Object)"=\u20e5");
        builder.put((Object)"bnequiv", (Object)"\u2261\u20e5");
        builder.put((Object)"bnot", (Object)"\u2310");
        builder.put((Object)"bopf", (Object)"\ud835\udd53");
        builder.put((Object)"bot", (Object)"\u22a5");
        builder.put((Object)"bottom", (Object)"\u22a5");
        builder.put((Object)"bowtie", (Object)"\u22c8");
        builder.put((Object)"boxDL", (Object)"\u2557");
        builder.put((Object)"boxDR", (Object)"\u2554");
        builder.put((Object)"boxDl", (Object)"\u2556");
        builder.put((Object)"boxDr", (Object)"\u2553");
        builder.put((Object)"boxH", (Object)"\u2550");
        builder.put((Object)"boxHD", (Object)"\u2566");
        builder.put((Object)"boxHU", (Object)"\u2569");
        builder.put((Object)"boxHd", (Object)"\u2564");
        builder.put((Object)"boxHu", (Object)"\u2567");
        builder.put((Object)"boxUL", (Object)"\u255d");
        builder.put((Object)"boxUR", (Object)"\u255a");
        builder.put((Object)"boxUl", (Object)"\u255c");
        builder.put((Object)"boxUr", (Object)"\u2559");
        builder.put((Object)"boxV", (Object)"\u2551");
        builder.put((Object)"boxVH", (Object)"\u256c");
        builder.put((Object)"boxVL", (Object)"\u2563");
        builder.put((Object)"boxVR", (Object)"\u2560");
        builder.put((Object)"boxVh", (Object)"\u256b");
        builder.put((Object)"boxVl", (Object)"\u2562");
        builder.put((Object)"boxVr", (Object)"\u255f");
        builder.put((Object)"boxbox", (Object)"\u29c9");
        builder.put((Object)"boxdL", (Object)"\u2555");
        builder.put((Object)"boxdR", (Object)"\u2552");
        builder.put((Object)"boxdl", (Object)"\u2510");
        builder.put((Object)"boxdr", (Object)"\u250c");
        builder.put((Object)"boxh", (Object)"\u2500");
        builder.put((Object)"boxhD", (Object)"\u2565");
        builder.put((Object)"boxhU", (Object)"\u2568");
        builder.put((Object)"boxhd", (Object)"\u252c");
        builder.put((Object)"boxhu", (Object)"\u2534");
        builder.put((Object)"boxminus", (Object)"\u229f");
        builder.put((Object)"boxplus", (Object)"\u229e");
        builder.put((Object)"boxtimes", (Object)"\u22a0");
        builder.put((Object)"boxuL", (Object)"\u255b");
        builder.put((Object)"boxuR", (Object)"\u2558");
        builder.put((Object)"boxul", (Object)"\u2518");
        builder.put((Object)"boxur", (Object)"\u2514");
        builder.put((Object)"boxv", (Object)"\u2502");
        builder.put((Object)"boxvH", (Object)"\u256a");
        builder.put((Object)"boxvL", (Object)"\u2561");
        builder.put((Object)"boxvR", (Object)"\u255e");
        builder.put((Object)"boxvh", (Object)"\u253c");
        builder.put((Object)"boxvl", (Object)"\u2524");
        builder.put((Object)"boxvr", (Object)"\u251c");
        builder.put((Object)"bprime", (Object)"\u2035");
        builder.put((Object)"breve", (Object)"\u02d8");
        builder.put((Object)"brvbar", (Object)"\u00a6");
        builder.put((Object)"bscr", (Object)"\ud835\udcb7");
        builder.put((Object)"bsemi", (Object)"\u204f");
        builder.put((Object)"bsim", (Object)"\u223d");
        builder.put((Object)"bsime", (Object)"\u22cd");
        builder.put((Object)"bsol", (Object)"\\");
        builder.put((Object)"bsolb", (Object)"\u29c5");
        builder.put((Object)"bsolhsub", (Object)"\u27c8");
        builder.put((Object)"bull", (Object)"\u2022");
        builder.put((Object)"bullet", (Object)"\u2022");
        builder.put((Object)"bump", (Object)"\u224e");
        builder.put((Object)"bumpE", (Object)"\u2aae");
        builder.put((Object)"bumpe", (Object)"\u224f");
        builder.put((Object)"bumpeq", (Object)"\u224f");
        builder.put((Object)"cacute", (Object)"\u0107");
        builder.put((Object)"cap", (Object)"\u2229");
        builder.put((Object)"capand", (Object)"\u2a44");
        builder.put((Object)"capbrcup", (Object)"\u2a49");
        builder.put((Object)"capcap", (Object)"\u2a4b");
        builder.put((Object)"capcup", (Object)"\u2a47");
        builder.put((Object)"capdot", (Object)"\u2a40");
        builder.put((Object)"caps", (Object)"\u2229\ufe00");
        builder.put((Object)"caret", (Object)"\u2041");
        builder.put((Object)"caron", (Object)"\u02c7");
        builder.put((Object)"ccaps", (Object)"\u2a4d");
        builder.put((Object)"ccaron", (Object)"\u010d");
        builder.put((Object)"ccedil", (Object)"\u00e7");
        builder.put((Object)"ccirc", (Object)"\u0109");
        builder.put((Object)"ccups", (Object)"\u2a4c");
        builder.put((Object)"ccupssm", (Object)"\u2a50");
        builder.put((Object)"cdot", (Object)"\u010b");
        builder.put((Object)"cedil", (Object)"\u00b8");
        builder.put((Object)"cemptyv", (Object)"\u29b2");
        builder.put((Object)"cent", (Object)"\u00a2");
        builder.put((Object)"centerdot", (Object)"\u00b7");
        builder.put((Object)"cfr", (Object)"\ud835\udd20");
        builder.put((Object)"chcy", (Object)"\u0447");
        builder.put((Object)"check", (Object)"\u2713");
        builder.put((Object)"checkmark", (Object)"\u2713");
        builder.put((Object)"chi", (Object)"\u03c7");
        builder.put((Object)"cir", (Object)"\u25cb");
        builder.put((Object)"cirE", (Object)"\u29c3");
        builder.put((Object)"circ", (Object)"\u02c6");
        builder.put((Object)"circeq", (Object)"\u2257");
        builder.put((Object)"circlearrowleft", (Object)"\u21ba");
        builder.put((Object)"circlearrowright", (Object)"\u21bb");
        builder.put((Object)"circledR", (Object)"\u00ae");
        builder.put((Object)"circledS", (Object)"\u24c8");
        builder.put((Object)"circledast", (Object)"\u229b");
        builder.put((Object)"circledcirc", (Object)"\u229a");
        builder.put((Object)"circleddash", (Object)"\u229d");
        builder.put((Object)"cire", (Object)"\u2257");
        builder.put((Object)"cirfnint", (Object)"\u2a10");
        builder.put((Object)"cirmid", (Object)"\u2aef");
        builder.put((Object)"cirscir", (Object)"\u29c2");
        builder.put((Object)"clubs", (Object)"\u2663");
        builder.put((Object)"clubsuit", (Object)"\u2663");
        builder.put((Object)"colon", (Object)":");
        builder.put((Object)"colone", (Object)"\u2254");
        builder.put((Object)"coloneq", (Object)"\u2254");
        builder.put((Object)"comma", (Object)",");
        builder.put((Object)"commat", (Object)"@");
        builder.put((Object)"comp", (Object)"\u2201");
        builder.put((Object)"compfn", (Object)"\u2218");
        builder.put((Object)"complement", (Object)"\u2201");
        builder.put((Object)"complexes", (Object)"\u2102");
        builder.put((Object)"cong", (Object)"\u2245");
        builder.put((Object)"congdot", (Object)"\u2a6d");
        builder.put((Object)"conint", (Object)"\u222e");
        builder.put((Object)"copf", (Object)"\ud835\udd54");
        builder.put((Object)"coprod", (Object)"\u2210");
        builder.put((Object)"copy", (Object)"\u00a9");
        builder.put((Object)"copysr", (Object)"\u2117");
        builder.put((Object)"crarr", (Object)"\u21b5");
        builder.put((Object)"cross", (Object)"\u2717");
        builder.put((Object)"cscr", (Object)"\ud835\udcb8");
        builder.put((Object)"csub", (Object)"\u2acf");
        builder.put((Object)"csube", (Object)"\u2ad1");
        builder.put((Object)"csup", (Object)"\u2ad0");
        builder.put((Object)"csupe", (Object)"\u2ad2");
        builder.put((Object)"ctdot", (Object)"\u22ef");
        builder.put((Object)"cudarrl", (Object)"\u2938");
        builder.put((Object)"cudarrr", (Object)"\u2935");
        builder.put((Object)"cuepr", (Object)"\u22de");
        builder.put((Object)"cuesc", (Object)"\u22df");
        builder.put((Object)"cularr", (Object)"\u21b6");
        builder.put((Object)"cularrp", (Object)"\u293d");
        builder.put((Object)"cup", (Object)"\u222a");
        builder.put((Object)"cupbrcap", (Object)"\u2a48");
        builder.put((Object)"cupcap", (Object)"\u2a46");
        builder.put((Object)"cupcup", (Object)"\u2a4a");
        builder.put((Object)"cupdot", (Object)"\u228d");
        builder.put((Object)"cupor", (Object)"\u2a45");
        builder.put((Object)"cups", (Object)"\u222a\ufe00");
        builder.put((Object)"curarr", (Object)"\u21b7");
        builder.put((Object)"curarrm", (Object)"\u293c");
        builder.put((Object)"curlyeqprec", (Object)"\u22de");
        builder.put((Object)"curlyeqsucc", (Object)"\u22df");
        builder.put((Object)"curlyvee", (Object)"\u22ce");
        builder.put((Object)"curlywedge", (Object)"\u22cf");
        builder.put((Object)"curren", (Object)"\u00a4");
        builder.put((Object)"curvearrowleft", (Object)"\u21b6");
        builder.put((Object)"curvearrowright", (Object)"\u21b7");
        builder.put((Object)"cuvee", (Object)"\u22ce");
        builder.put((Object)"cuwed", (Object)"\u22cf");
        builder.put((Object)"cwconint", (Object)"\u2232");
        builder.put((Object)"cwint", (Object)"\u2231");
        builder.put((Object)"cylcty", (Object)"\u232d");
        builder.put((Object)"dArr", (Object)"\u21d3");
        builder.put((Object)"dHar", (Object)"\u2965");
        builder.put((Object)"dagger", (Object)"\u2020");
        builder.put((Object)"daleth", (Object)"\u2138");
        builder.put((Object)"darr", (Object)"\u2193");
        builder.put((Object)"dash", (Object)"\u2010");
        builder.put((Object)"dashv", (Object)"\u22a3");
        builder.put((Object)"dbkarow", (Object)"\u290f");
        builder.put((Object)"dblac", (Object)"\u02dd");
        builder.put((Object)"dcaron", (Object)"\u010f");
        builder.put((Object)"dcy", (Object)"\u0434");
        builder.put((Object)"dd", (Object)"\u2146");
        builder.put((Object)"ddagger", (Object)"\u2021");
        builder.put((Object)"ddarr", (Object)"\u21ca");
        builder.put((Object)"ddotseq", (Object)"\u2a77");
        builder.put((Object)"deg", (Object)"\u00b0");
        builder.put((Object)"delta", (Object)"\u03b4");
        builder.put((Object)"demptyv", (Object)"\u29b1");
        builder.put((Object)"dfisht", (Object)"\u297f");
        builder.put((Object)"dfr", (Object)"\ud835\udd21");
        builder.put((Object)"dharl", (Object)"\u21c3");
        builder.put((Object)"dharr", (Object)"\u21c2");
        builder.put((Object)"diam", (Object)"\u22c4");
        builder.put((Object)"diamond", (Object)"\u22c4");
        builder.put((Object)"diamondsuit", (Object)"\u2666");
        builder.put((Object)"diams", (Object)"\u2666");
        builder.put((Object)"die", (Object)"\u00a8");
        builder.put((Object)"digamma", (Object)"\u03dd");
        builder.put((Object)"disin", (Object)"\u22f2");
        builder.put((Object)"div", (Object)"\u00f7");
        builder.put((Object)"divide", (Object)"\u00f7");
        builder.put((Object)"divideontimes", (Object)"\u22c7");
        builder.put((Object)"divonx", (Object)"\u22c7");
        builder.put((Object)"djcy", (Object)"\u0452");
        builder.put((Object)"dlcorn", (Object)"\u231e");
        builder.put((Object)"dlcrop", (Object)"\u230d");
        builder.put((Object)"dollar", (Object)"$");
        builder.put((Object)"dopf", (Object)"\ud835\udd55");
        builder.put((Object)"dot", (Object)"\u02d9");
        builder.put((Object)"doteq", (Object)"\u2250");
        builder.put((Object)"doteqdot", (Object)"\u2251");
        builder.put((Object)"dotminus", (Object)"\u2238");
        builder.put((Object)"dotplus", (Object)"\u2214");
        builder.put((Object)"dotsquare", (Object)"\u22a1");
        builder.put((Object)"doublebarwedge", (Object)"\u2306");
        builder.put((Object)"downarrow", (Object)"\u2193");
        builder.put((Object)"downdownarrows", (Object)"\u21ca");
        builder.put((Object)"downharpoonleft", (Object)"\u21c3");
        builder.put((Object)"downharpoonright", (Object)"\u21c2");
        builder.put((Object)"drbkarow", (Object)"\u2910");
        builder.put((Object)"drcorn", (Object)"\u231f");
        builder.put((Object)"drcrop", (Object)"\u230c");
        builder.put((Object)"dscr", (Object)"\ud835\udcb9");
        builder.put((Object)"dscy", (Object)"\u0455");
        builder.put((Object)"dsol", (Object)"\u29f6");
        builder.put((Object)"dstrok", (Object)"\u0111");
        builder.put((Object)"dtdot", (Object)"\u22f1");
        builder.put((Object)"dtri", (Object)"\u25bf");
        builder.put((Object)"dtrif", (Object)"\u25be");
        builder.put((Object)"duarr", (Object)"\u21f5");
        builder.put((Object)"duhar", (Object)"\u296f");
        builder.put((Object)"dwangle", (Object)"\u29a6");
        builder.put((Object)"dzcy", (Object)"\u045f");
        builder.put((Object)"dzigrarr", (Object)"\u27ff");
        builder.put((Object)"eDDot", (Object)"\u2a77");
        builder.put((Object)"eDot", (Object)"\u2251");
        builder.put((Object)"eacute", (Object)"\u00e9");
        builder.put((Object)"easter", (Object)"\u2a6e");
        builder.put((Object)"ecaron", (Object)"\u011b");
        builder.put((Object)"ecir", (Object)"\u2256");
        builder.put((Object)"ecirc", (Object)"\u00ea");
        builder.put((Object)"ecolon", (Object)"\u2255");
        builder.put((Object)"ecy", (Object)"\u044d");
        builder.put((Object)"edot", (Object)"\u0117");
        builder.put((Object)"ee", (Object)"\u2147");
        builder.put((Object)"efDot", (Object)"\u2252");
        builder.put((Object)"efr", (Object)"\ud835\udd22");
        builder.put((Object)"eg", (Object)"\u2a9a");
        builder.put((Object)"egrave", (Object)"\u00e8");
        builder.put((Object)"egs", (Object)"\u2a96");
        builder.put((Object)"egsdot", (Object)"\u2a98");
        builder.put((Object)"el", (Object)"\u2a99");
        builder.put((Object)"elinters", (Object)"\u23e7");
        builder.put((Object)"ell", (Object)"\u2113");
        builder.put((Object)"els", (Object)"\u2a95");
        builder.put((Object)"elsdot", (Object)"\u2a97");
        builder.put((Object)"emacr", (Object)"\u0113");
        builder.put((Object)"empty", (Object)"\u2205");
        builder.put((Object)"emptyset", (Object)"\u2205");
        builder.put((Object)"emptyv", (Object)"\u2205");
        builder.put((Object)"emsp13", (Object)"\u2004");
        builder.put((Object)"emsp14", (Object)"\u2005");
        builder.put((Object)"emsp", (Object)"\u2003");
        builder.put((Object)"eng", (Object)"\u014b");
        builder.put((Object)"ensp", (Object)"\u2002");
        builder.put((Object)"eogon", (Object)"\u0119");
        builder.put((Object)"eopf", (Object)"\ud835\udd56");
        builder.put((Object)"epar", (Object)"\u22d5");
        builder.put((Object)"eparsl", (Object)"\u29e3");
        builder.put((Object)"eplus", (Object)"\u2a71");
        builder.put((Object)"epsi", (Object)"\u03b5");
        builder.put((Object)"epsilon", (Object)"\u03b5");
        builder.put((Object)"epsiv", (Object)"\u03f5");
        builder.put((Object)"eqcirc", (Object)"\u2256");
        builder.put((Object)"eqcolon", (Object)"\u2255");
        builder.put((Object)"eqsim", (Object)"\u2242");
        builder.put((Object)"eqslantgtr", (Object)"\u2a96");
        builder.put((Object)"eqslantless", (Object)"\u2a95");
        builder.put((Object)"equals", (Object)"=");
        builder.put((Object)"equest", (Object)"\u225f");
        builder.put((Object)"equiv", (Object)"\u2261");
        builder.put((Object)"equivDD", (Object)"\u2a78");
        builder.put((Object)"eqvparsl", (Object)"\u29e5");
        builder.put((Object)"erDot", (Object)"\u2253");
        builder.put((Object)"erarr", (Object)"\u2971");
        builder.put((Object)"escr", (Object)"\u212f");
        builder.put((Object)"esdot", (Object)"\u2250");
        builder.put((Object)"esim", (Object)"\u2242");
        builder.put((Object)"eta", (Object)"\u03b7");
        builder.put((Object)"eth", (Object)"\u00f0");
        builder.put((Object)"euml", (Object)"\u00eb");
        builder.put((Object)"euro", (Object)"\u20ac");
        builder.put((Object)"excl", (Object)"!");
        builder.put((Object)"exist", (Object)"\u2203");
        builder.put((Object)"expectation", (Object)"\u2130");
        builder.put((Object)"exponentiale", (Object)"\u2147");
        builder.put((Object)"fallingdotseq", (Object)"\u2252");
        builder.put((Object)"fcy", (Object)"\u0444");
        builder.put((Object)"female", (Object)"\u2640");
        builder.put((Object)"ffilig", (Object)"\ufb03");
        builder.put((Object)"fflig", (Object)"\ufb00");
        builder.put((Object)"ffllig", (Object)"\ufb04");
        builder.put((Object)"ffr", (Object)"\ud835\udd23");
        builder.put((Object)"filig", (Object)"\ufb01");
        builder.put((Object)"fjlig", (Object)"fj");
        builder.put((Object)"flat", (Object)"\u266d");
        builder.put((Object)"fllig", (Object)"\ufb02");
        builder.put((Object)"fltns", (Object)"\u25b1");
        builder.put((Object)"fnof", (Object)"\u0192");
        builder.put((Object)"fopf", (Object)"\ud835\udd57");
        builder.put((Object)"forall", (Object)"\u2200");
        builder.put((Object)"fork", (Object)"\u22d4");
        builder.put((Object)"forkv", (Object)"\u2ad9");
        builder.put((Object)"fpartint", (Object)"\u2a0d");
        builder.put((Object)"frac12", (Object)"\u00bd");
        builder.put((Object)"frac13", (Object)"\u2153");
        builder.put((Object)"frac14", (Object)"\u00bc");
        builder.put((Object)"frac15", (Object)"\u2155");
        builder.put((Object)"frac16", (Object)"\u2159");
        builder.put((Object)"frac18", (Object)"\u215b");
        builder.put((Object)"frac23", (Object)"\u2154");
        builder.put((Object)"frac25", (Object)"\u2156");
        builder.put((Object)"frac34", (Object)"\u00be");
        builder.put((Object)"frac35", (Object)"\u2157");
        builder.put((Object)"frac38", (Object)"\u215c");
        builder.put((Object)"frac45", (Object)"\u2158");
        builder.put((Object)"frac56", (Object)"\u215a");
        builder.put((Object)"frac58", (Object)"\u215d");
        builder.put((Object)"frac78", (Object)"\u215e");
        builder.put((Object)"frasl", (Object)"\u2044");
        builder.put((Object)"frown", (Object)"\u2322");
        builder.put((Object)"fscr", (Object)"\ud835\udcbb");
        builder.put((Object)"gE", (Object)"\u2267");
        builder.put((Object)"gEl", (Object)"\u2a8c");
        builder.put((Object)"gacute", (Object)"\u01f5");
        builder.put((Object)"gamma", (Object)"\u03b3");
        builder.put((Object)"gammad", (Object)"\u03dd");
        builder.put((Object)"gap", (Object)"\u2a86");
        builder.put((Object)"gbreve", (Object)"\u011f");
        builder.put((Object)"gcirc", (Object)"\u011d");
        builder.put((Object)"gcy", (Object)"\u0433");
        builder.put((Object)"gdot", (Object)"\u0121");
        builder.put((Object)"ge", (Object)"\u2265");
        builder.put((Object)"gel", (Object)"\u22db");
        builder.put((Object)"geq", (Object)"\u2265");
        builder.put((Object)"geqq", (Object)"\u2267");
        builder.put((Object)"geqslant", (Object)"\u2a7e");
        builder.put((Object)"ges", (Object)"\u2a7e");
        builder.put((Object)"gescc", (Object)"\u2aa9");
        builder.put((Object)"gesdot", (Object)"\u2a80");
        builder.put((Object)"gesdoto", (Object)"\u2a82");
        builder.put((Object)"gesdotol", (Object)"\u2a84");
        builder.put((Object)"gesl", (Object)"\u22db\ufe00");
        builder.put((Object)"gesles", (Object)"\u2a94");
        builder.put((Object)"gfr", (Object)"\ud835\udd24");
        builder.put((Object)"gg", (Object)"\u226b");
        builder.put((Object)"ggg", (Object)"\u22d9");
        builder.put((Object)"gimel", (Object)"\u2137");
        builder.put((Object)"gjcy", (Object)"\u0453");
        builder.put((Object)"gl", (Object)"\u2277");
        builder.put((Object)"glE", (Object)"\u2a92");
        builder.put((Object)"gla", (Object)"\u2aa5");
        builder.put((Object)"glj", (Object)"\u2aa4");
        builder.put((Object)"gnE", (Object)"\u2269");
        builder.put((Object)"gnap", (Object)"\u2a8a");
        builder.put((Object)"gnapprox", (Object)"\u2a8a");
        builder.put((Object)"gne", (Object)"\u2a88");
        builder.put((Object)"gneq", (Object)"\u2a88");
        builder.put((Object)"gneqq", (Object)"\u2269");
        builder.put((Object)"gnsim", (Object)"\u22e7");
        builder.put((Object)"gopf", (Object)"\ud835\udd58");
        builder.put((Object)"grave", (Object)"`");
        builder.put((Object)"gscr", (Object)"\u210a");
        builder.put((Object)"gsim", (Object)"\u2273");
        builder.put((Object)"gsime", (Object)"\u2a8e");
        builder.put((Object)"gsiml", (Object)"\u2a90");
        builder.put((Object)"gt", (Object)">");
        builder.put((Object)"gtcc", (Object)"\u2aa7");
        builder.put((Object)"gtcir", (Object)"\u2a7a");
        builder.put((Object)"gtdot", (Object)"\u22d7");
        builder.put((Object)"gtlPar", (Object)"\u2995");
        builder.put((Object)"gtquest", (Object)"\u2a7c");
        builder.put((Object)"gtrapprox", (Object)"\u2a86");
        builder.put((Object)"gtrarr", (Object)"\u2978");
        builder.put((Object)"gtrdot", (Object)"\u22d7");
        builder.put((Object)"gtreqless", (Object)"\u22db");
        builder.put((Object)"gtreqqless", (Object)"\u2a8c");
        builder.put((Object)"gtrless", (Object)"\u2277");
        builder.put((Object)"gtrsim", (Object)"\u2273");
        builder.put((Object)"gvertneqq", (Object)"\u2269\ufe00");
        builder.put((Object)"gvnE", (Object)"\u2269\ufe00");
        builder.put((Object)"hArr", (Object)"\u21d4");
        builder.put((Object)"hairsp", (Object)"\u200a");
        builder.put((Object)"half", (Object)"\u00bd");
        builder.put((Object)"hamilt", (Object)"\u210b");
        builder.put((Object)"hardcy", (Object)"\u044a");
        builder.put((Object)"harr", (Object)"\u2194");
        builder.put((Object)"harrcir", (Object)"\u2948");
        builder.put((Object)"harrw", (Object)"\u21ad");
        builder.put((Object)"hbar", (Object)"\u210f");
        builder.put((Object)"hcirc", (Object)"\u0125");
        builder.put((Object)"hearts", (Object)"\u2665");
        builder.put((Object)"heartsuit", (Object)"\u2665");
        builder.put((Object)"hellip", (Object)"\u2026");
        builder.put((Object)"hercon", (Object)"\u22b9");
        builder.put((Object)"hfr", (Object)"\ud835\udd25");
        builder.put((Object)"hksearow", (Object)"\u2925");
        builder.put((Object)"hkswarow", (Object)"\u2926");
        builder.put((Object)"hoarr", (Object)"\u21ff");
        builder.put((Object)"homtht", (Object)"\u223b");
        builder.put((Object)"hookleftarrow", (Object)"\u21a9");
        builder.put((Object)"hookrightarrow", (Object)"\u21aa");
        builder.put((Object)"hopf", (Object)"\ud835\udd59");
        builder.put((Object)"horbar", (Object)"\u2015");
        builder.put((Object)"hscr", (Object)"\ud835\udcbd");
        builder.put((Object)"hslash", (Object)"\u210f");
        builder.put((Object)"hstrok", (Object)"\u0127");
        builder.put((Object)"hybull", (Object)"\u2043");
        builder.put((Object)"hyphen", (Object)"\u2010");
        builder.put((Object)"iacute", (Object)"\u00ed");
        builder.put((Object)"ic", (Object)"\u2063");
        builder.put((Object)"icirc", (Object)"\u00ee");
        builder.put((Object)"icy", (Object)"\u0438");
        builder.put((Object)"iecy", (Object)"\u0435");
        builder.put((Object)"iexcl", (Object)"\u00a1");
        builder.put((Object)"iff", (Object)"\u21d4");
        builder.put((Object)"ifr", (Object)"\ud835\udd26");
        builder.put((Object)"igrave", (Object)"\u00ec");
        builder.put((Object)"ii", (Object)"\u2148");
        builder.put((Object)"iiiint", (Object)"\u2a0c");
        builder.put((Object)"iiint", (Object)"\u222d");
        builder.put((Object)"iinfin", (Object)"\u29dc");
        builder.put((Object)"iiota", (Object)"\u2129");
        builder.put((Object)"ijlig", (Object)"\u0133");
        builder.put((Object)"imacr", (Object)"\u012b");
        builder.put((Object)"image", (Object)"\u2111");
        builder.put((Object)"imagline", (Object)"\u2110");
        builder.put((Object)"imagpart", (Object)"\u2111");
        builder.put((Object)"imath", (Object)"\u0131");
        builder.put((Object)"imof", (Object)"\u22b7");
        builder.put((Object)"imped", (Object)"\u01b5");
        builder.put((Object)"in", (Object)"\u2208");
        builder.put((Object)"incare", (Object)"\u2105");
        builder.put((Object)"infin", (Object)"\u221e");
        builder.put((Object)"infintie", (Object)"\u29dd");
        builder.put((Object)"inodot", (Object)"\u0131");
        builder.put((Object)"int", (Object)"\u222b");
        builder.put((Object)"intcal", (Object)"\u22ba");
        builder.put((Object)"integers", (Object)"\u2124");
        builder.put((Object)"intercal", (Object)"\u22ba");
        builder.put((Object)"intlarhk", (Object)"\u2a17");
        builder.put((Object)"intprod", (Object)"\u2a3c");
        builder.put((Object)"iocy", (Object)"\u0451");
        builder.put((Object)"iogon", (Object)"\u012f");
        builder.put((Object)"iopf", (Object)"\ud835\udd5a");
        builder.put((Object)"iota", (Object)"\u03b9");
        builder.put((Object)"iprod", (Object)"\u2a3c");
        builder.put((Object)"iquest", (Object)"\u00bf");
        builder.put((Object)"iscr", (Object)"\ud835\udcbe");
        builder.put((Object)"isin", (Object)"\u2208");
        builder.put((Object)"isinE", (Object)"\u22f9");
        builder.put((Object)"isindot", (Object)"\u22f5");
        builder.put((Object)"isins", (Object)"\u22f4");
        builder.put((Object)"isinsv", (Object)"\u22f3");
        builder.put((Object)"isinv", (Object)"\u2208");
        builder.put((Object)"it", (Object)"\u2062");
        builder.put((Object)"itilde", (Object)"\u0129");
        builder.put((Object)"iukcy", (Object)"\u0456");
        builder.put((Object)"iuml", (Object)"\u00ef");
        builder.put((Object)"jcirc", (Object)"\u0135");
        builder.put((Object)"jcy", (Object)"\u0439");
        builder.put((Object)"jfr", (Object)"\ud835\udd27");
        builder.put((Object)"jmath", (Object)"\u0237");
        builder.put((Object)"jopf", (Object)"\ud835\udd5b");
        builder.put((Object)"jscr", (Object)"\ud835\udcbf");
        builder.put((Object)"jsercy", (Object)"\u0458");
        builder.put((Object)"jukcy", (Object)"\u0454");
        builder.put((Object)"kappa", (Object)"\u03ba");
        builder.put((Object)"kappav", (Object)"\u03f0");
        builder.put((Object)"kcedil", (Object)"\u0137");
        builder.put((Object)"kcy", (Object)"\u043a");
        builder.put((Object)"kfr", (Object)"\ud835\udd28");
        builder.put((Object)"kgreen", (Object)"\u0138");
        builder.put((Object)"khcy", (Object)"\u0445");
        builder.put((Object)"kjcy", (Object)"\u045c");
        builder.put((Object)"kopf", (Object)"\ud835\udd5c");
        builder.put((Object)"kscr", (Object)"\ud835\udcc0");
        builder.put((Object)"lAarr", (Object)"\u21da");
        builder.put((Object)"lArr", (Object)"\u21d0");
        builder.put((Object)"lAtail", (Object)"\u291b");
        builder.put((Object)"lBarr", (Object)"\u290e");
        builder.put((Object)"lE", (Object)"\u2266");
        builder.put((Object)"lEg", (Object)"\u2a8b");
        builder.put((Object)"lHar", (Object)"\u2962");
        builder.put((Object)"lacute", (Object)"\u013a");
        builder.put((Object)"laemptyv", (Object)"\u29b4");
        builder.put((Object)"lagran", (Object)"\u2112");
        builder.put((Object)"lambda", (Object)"\u03bb");
        builder.put((Object)"lang", (Object)"\u27e8");
        builder.put((Object)"langd", (Object)"\u2991");
        builder.put((Object)"langle", (Object)"\u27e8");
        builder.put((Object)"lap", (Object)"\u2a85");
        builder.put((Object)"laquo", (Object)"\u00ab");
        builder.put((Object)"larr", (Object)"\u2190");
        builder.put((Object)"larrb", (Object)"\u21e4");
        builder.put((Object)"larrbfs", (Object)"\u291f");
        builder.put((Object)"larrfs", (Object)"\u291d");
        builder.put((Object)"larrhk", (Object)"\u21a9");
        builder.put((Object)"larrlp", (Object)"\u21ab");
        builder.put((Object)"larrpl", (Object)"\u2939");
        builder.put((Object)"larrsim", (Object)"\u2973");
        builder.put((Object)"larrtl", (Object)"\u21a2");
        builder.put((Object)"lat", (Object)"\u2aab");
        builder.put((Object)"latail", (Object)"\u2919");
        builder.put((Object)"late", (Object)"\u2aad");
        builder.put((Object)"lates", (Object)"\u2aad\ufe00");
        builder.put((Object)"lbarr", (Object)"\u290c");
        builder.put((Object)"lbbrk", (Object)"\u2772");
        builder.put((Object)"lbrace", (Object)"{");
        builder.put((Object)"lbrack", (Object)"[");
        builder.put((Object)"lbrke", (Object)"\u298b");
        builder.put((Object)"lbrksld", (Object)"\u298f");
        builder.put((Object)"lbrkslu", (Object)"\u298d");
        builder.put((Object)"lcaron", (Object)"\u013e");
        builder.put((Object)"lcedil", (Object)"\u013c");
        builder.put((Object)"lceil", (Object)"\u2308");
        builder.put((Object)"lcub", (Object)"{");
        builder.put((Object)"lcy", (Object)"\u043b");
        builder.put((Object)"ldca", (Object)"\u2936");
        builder.put((Object)"ldquo", (Object)"\u201c");
        builder.put((Object)"ldquor", (Object)"\u201e");
        builder.put((Object)"ldrdhar", (Object)"\u2967");
        builder.put((Object)"ldrushar", (Object)"\u294b");
        builder.put((Object)"ldsh", (Object)"\u21b2");
        builder.put((Object)"le", (Object)"\u2264");
        builder.put((Object)"leftarrow", (Object)"\u2190");
        builder.put((Object)"leftarrowtail", (Object)"\u21a2");
        builder.put((Object)"leftharpoondown", (Object)"\u21bd");
        builder.put((Object)"leftharpoonup", (Object)"\u21bc");
        builder.put((Object)"leftleftarrows", (Object)"\u21c7");
        builder.put((Object)"leftrightarrow", (Object)"\u2194");
        builder.put((Object)"leftrightarrows", (Object)"\u21c6");
        builder.put((Object)"leftrightharpoons", (Object)"\u21cb");
        builder.put((Object)"leftrightsquigarrow", (Object)"\u21ad");
        builder.put((Object)"leftthreetimes", (Object)"\u22cb");
        builder.put((Object)"leg", (Object)"\u22da");
        builder.put((Object)"leq", (Object)"\u2264");
        builder.put((Object)"leqq", (Object)"\u2266");
        builder.put((Object)"leqslant", (Object)"\u2a7d");
        builder.put((Object)"les", (Object)"\u2a7d");
        builder.put((Object)"lescc", (Object)"\u2aa8");
        builder.put((Object)"lesdot", (Object)"\u2a7f");
        builder.put((Object)"lesdoto", (Object)"\u2a81");
        builder.put((Object)"lesdotor", (Object)"\u2a83");
        builder.put((Object)"lesg", (Object)"\u22da\ufe00");
        builder.put((Object)"lesges", (Object)"\u2a93");
        builder.put((Object)"lessapprox", (Object)"\u2a85");
        builder.put((Object)"lessdot", (Object)"\u22d6");
        builder.put((Object)"lesseqgtr", (Object)"\u22da");
        builder.put((Object)"lesseqqgtr", (Object)"\u2a8b");
        builder.put((Object)"lessgtr", (Object)"\u2276");
        builder.put((Object)"lesssim", (Object)"\u2272");
        builder.put((Object)"lfisht", (Object)"\u297c");
        builder.put((Object)"lfloor", (Object)"\u230a");
        builder.put((Object)"lfr", (Object)"\ud835\udd29");
        builder.put((Object)"lg", (Object)"\u2276");
        builder.put((Object)"lgE", (Object)"\u2a91");
        builder.put((Object)"lhard", (Object)"\u21bd");
        builder.put((Object)"lharu", (Object)"\u21bc");
        builder.put((Object)"lharul", (Object)"\u296a");
        builder.put((Object)"lhblk", (Object)"\u2584");
        builder.put((Object)"ljcy", (Object)"\u0459");
        builder.put((Object)"ll", (Object)"\u226a");
        builder.put((Object)"llarr", (Object)"\u21c7");
        builder.put((Object)"llcorner", (Object)"\u231e");
        builder.put((Object)"llhard", (Object)"\u296b");
        builder.put((Object)"lltri", (Object)"\u25fa");
        builder.put((Object)"lmidot", (Object)"\u0140");
        builder.put((Object)"lmoust", (Object)"\u23b0");
        builder.put((Object)"lmoustache", (Object)"\u23b0");
        builder.put((Object)"lnE", (Object)"\u2268");
        builder.put((Object)"lnap", (Object)"\u2a89");
        builder.put((Object)"lnapprox", (Object)"\u2a89");
        builder.put((Object)"lne", (Object)"\u2a87");
        builder.put((Object)"lneq", (Object)"\u2a87");
        builder.put((Object)"lneqq", (Object)"\u2268");
        builder.put((Object)"lnsim", (Object)"\u22e6");
        builder.put((Object)"loang", (Object)"\u27ec");
        builder.put((Object)"loarr", (Object)"\u21fd");
        builder.put((Object)"lobrk", (Object)"\u27e6");
        builder.put((Object)"longleftarrow", (Object)"\u27f5");
        builder.put((Object)"longleftrightarrow", (Object)"\u27f7");
        builder.put((Object)"longmapsto", (Object)"\u27fc");
        builder.put((Object)"longrightarrow", (Object)"\u27f6");
        builder.put((Object)"looparrowleft", (Object)"\u21ab");
        builder.put((Object)"looparrowright", (Object)"\u21ac");
        builder.put((Object)"lopar", (Object)"\u2985");
        builder.put((Object)"lopf", (Object)"\ud835\udd5d");
        builder.put((Object)"loplus", (Object)"\u2a2d");
        builder.put((Object)"lotimes", (Object)"\u2a34");
        builder.put((Object)"lowast", (Object)"\u2217");
        builder.put((Object)"lowbar", (Object)"_");
        builder.put((Object)"loz", (Object)"\u25ca");
        builder.put((Object)"lozenge", (Object)"\u25ca");
        builder.put((Object)"lozf", (Object)"\u29eb");
        builder.put((Object)"lpar", (Object)"(");
        builder.put((Object)"lparlt", (Object)"\u2993");
        builder.put((Object)"lrarr", (Object)"\u21c6");
        builder.put((Object)"lrcorner", (Object)"\u231f");
        builder.put((Object)"lrhar", (Object)"\u21cb");
        builder.put((Object)"lrhard", (Object)"\u296d");
        builder.put((Object)"lrm", (Object)"\u200e");
        builder.put((Object)"lrtri", (Object)"\u22bf");
        builder.put((Object)"lsaquo", (Object)"\u2039");
        builder.put((Object)"lscr", (Object)"\ud835\udcc1");
        builder.put((Object)"lsh", (Object)"\u21b0");
        builder.put((Object)"lsim", (Object)"\u2272");
        builder.put((Object)"lsime", (Object)"\u2a8d");
        builder.put((Object)"lsimg", (Object)"\u2a8f");
        builder.put((Object)"lsqb", (Object)"[");
        builder.put((Object)"lsquo", (Object)"\u2018");
        builder.put((Object)"lsquor", (Object)"\u201a");
        builder.put((Object)"lstrok", (Object)"\u0142");
        builder.put((Object)"lt", (Object)"<");
        builder.put((Object)"ltcc", (Object)"\u2aa6");
        builder.put((Object)"ltcir", (Object)"\u2a79");
        builder.put((Object)"ltdot", (Object)"\u22d6");
        builder.put((Object)"lthree", (Object)"\u22cb");
        builder.put((Object)"ltimes", (Object)"\u22c9");
        builder.put((Object)"ltlarr", (Object)"\u2976");
        builder.put((Object)"ltquest", (Object)"\u2a7b");
        builder.put((Object)"ltrPar", (Object)"\u2996");
        builder.put((Object)"ltri", (Object)"\u25c3");
        builder.put((Object)"ltrie", (Object)"\u22b4");
        builder.put((Object)"ltrif", (Object)"\u25c2");
        builder.put((Object)"lurdshar", (Object)"\u294a");
        builder.put((Object)"luruhar", (Object)"\u2966");
        builder.put((Object)"lvertneqq", (Object)"\u2268\ufe00");
        builder.put((Object)"lvnE", (Object)"\u2268\ufe00");
        builder.put((Object)"mDDot", (Object)"\u223a");
        builder.put((Object)"macr", (Object)"\u00af");
        builder.put((Object)"male", (Object)"\u2642");
        builder.put((Object)"malt", (Object)"\u2720");
        builder.put((Object)"maltese", (Object)"\u2720");
        builder.put((Object)"map", (Object)"\u21a6");
        builder.put((Object)"mapsto", (Object)"\u21a6");
        builder.put((Object)"mapstodown", (Object)"\u21a7");
        builder.put((Object)"mapstoleft", (Object)"\u21a4");
        builder.put((Object)"mapstoup", (Object)"\u21a5");
        builder.put((Object)"marker", (Object)"\u25ae");
        builder.put((Object)"mcomma", (Object)"\u2a29");
        builder.put((Object)"mcy", (Object)"\u043c");
        builder.put((Object)"mdash", (Object)"\u2014");
        builder.put((Object)"measuredangle", (Object)"\u2221");
        builder.put((Object)"mfr", (Object)"\ud835\udd2a");
        builder.put((Object)"mho", (Object)"\u2127");
        builder.put((Object)"micro", (Object)"\u00b5");
        builder.put((Object)"mid", (Object)"\u2223");
        builder.put((Object)"midast", (Object)"*");
        builder.put((Object)"midcir", (Object)"\u2af0");
        builder.put((Object)"middot", (Object)"\u00b7");
        builder.put((Object)"minus", (Object)"\u2212");
        builder.put((Object)"minusb", (Object)"\u229f");
        builder.put((Object)"minusd", (Object)"\u2238");
        builder.put((Object)"minusdu", (Object)"\u2a2a");
        builder.put((Object)"mlcp", (Object)"\u2adb");
        builder.put((Object)"mldr", (Object)"\u2026");
        builder.put((Object)"mnplus", (Object)"\u2213");
        builder.put((Object)"models", (Object)"\u22a7");
        builder.put((Object)"mopf", (Object)"\ud835\udd5e");
        builder.put((Object)"mp", (Object)"\u2213");
        builder.put((Object)"mscr", (Object)"\ud835\udcc2");
        builder.put((Object)"mstpos", (Object)"\u223e");
        builder.put((Object)"mu", (Object)"\u03bc");
        builder.put((Object)"multimap", (Object)"\u22b8");
        builder.put((Object)"mumap", (Object)"\u22b8");
        builder.put((Object)"nGg", (Object)"\u22d9\u0338");
        builder.put((Object)"nGt", (Object)"\u226b\u20d2");
        builder.put((Object)"nGtv", (Object)"\u226b\u0338");
        builder.put((Object)"nLeftarrow", (Object)"\u21cd");
        builder.put((Object)"nLeftrightarrow", (Object)"\u21ce");
        builder.put((Object)"nLl", (Object)"\u22d8\u0338");
        builder.put((Object)"nLt", (Object)"\u226a\u20d2");
        builder.put((Object)"nLtv", (Object)"\u226a\u0338");
        builder.put((Object)"nRightarrow", (Object)"\u21cf");
        builder.put((Object)"nVDash", (Object)"\u22af");
        builder.put((Object)"nVdash", (Object)"\u22ae");
        builder.put((Object)"nabla", (Object)"\u2207");
        builder.put((Object)"nacute", (Object)"\u0144");
        builder.put((Object)"nang", (Object)"\u2220\u20d2");
        builder.put((Object)"nap", (Object)"\u2249");
        builder.put((Object)"napE", (Object)"\u2a70\u0338");
        builder.put((Object)"napid", (Object)"\u224b\u0338");
        builder.put((Object)"napos", (Object)"\u0149");
        builder.put((Object)"napprox", (Object)"\u2249");
        builder.put((Object)"natur", (Object)"\u266e");
        builder.put((Object)"natural", (Object)"\u266e");
        builder.put((Object)"naturals", (Object)"\u2115");
        builder.put((Object)"nbsp", (Object)"\u00a0");
        builder.put((Object)"nbump", (Object)"\u224e\u0338");
        builder.put((Object)"nbumpe", (Object)"\u224f\u0338");
        builder.put((Object)"ncap", (Object)"\u2a43");
        builder.put((Object)"ncaron", (Object)"\u0148");
        builder.put((Object)"ncedil", (Object)"\u0146");
        builder.put((Object)"ncong", (Object)"\u2247");
        builder.put((Object)"ncongdot", (Object)"\u2a6d\u0338");
        builder.put((Object)"ncup", (Object)"\u2a42");
        builder.put((Object)"ncy", (Object)"\u043d");
        builder.put((Object)"ndash", (Object)"\u2013");
        builder.put((Object)"ne", (Object)"\u2260");
        builder.put((Object)"neArr", (Object)"\u21d7");
        builder.put((Object)"nearhk", (Object)"\u2924");
        builder.put((Object)"nearr", (Object)"\u2197");
        builder.put((Object)"nearrow", (Object)"\u2197");
        builder.put((Object)"nedot", (Object)"\u2250\u0338");
        builder.put((Object)"nequiv", (Object)"\u2262");
        builder.put((Object)"nesear", (Object)"\u2928");
        builder.put((Object)"nesim", (Object)"\u2242\u0338");
        builder.put((Object)"nexist", (Object)"\u2204");
        builder.put((Object)"nexists", (Object)"\u2204");
        builder.put((Object)"nfr", (Object)"\ud835\udd2b");
        builder.put((Object)"ngE", (Object)"\u2267\u0338");
        builder.put((Object)"nge", (Object)"\u2271");
        builder.put((Object)"ngeq", (Object)"\u2271");
        builder.put((Object)"ngeqq", (Object)"\u2267\u0338");
        builder.put((Object)"ngeqslant", (Object)"\u2a7e\u0338");
        builder.put((Object)"nges", (Object)"\u2a7e\u0338");
        builder.put((Object)"ngsim", (Object)"\u2275");
        builder.put((Object)"ngt", (Object)"\u226f");
        builder.put((Object)"ngtr", (Object)"\u226f");
        builder.put((Object)"nhArr", (Object)"\u21ce");
        builder.put((Object)"nharr", (Object)"\u21ae");
        builder.put((Object)"nhpar", (Object)"\u2af2");
        builder.put((Object)"ni", (Object)"\u220b");
        builder.put((Object)"nis", (Object)"\u22fc");
        builder.put((Object)"nisd", (Object)"\u22fa");
        builder.put((Object)"niv", (Object)"\u220b");
        builder.put((Object)"njcy", (Object)"\u045a");
        builder.put((Object)"nlArr", (Object)"\u21cd");
        builder.put((Object)"nlE", (Object)"\u2266\u0338");
        builder.put((Object)"nlarr", (Object)"\u219a");
        builder.put((Object)"nldr", (Object)"\u2025");
        builder.put((Object)"nle", (Object)"\u2270");
        builder.put((Object)"nleftarrow", (Object)"\u219a");
        builder.put((Object)"nleftrightarrow", (Object)"\u21ae");
        builder.put((Object)"nleq", (Object)"\u2270");
        builder.put((Object)"nleqq", (Object)"\u2266\u0338");
        builder.put((Object)"nleqslant", (Object)"\u2a7d\u0338");
        builder.put((Object)"nles", (Object)"\u2a7d\u0338");
        builder.put((Object)"nless", (Object)"\u226e");
        builder.put((Object)"nlsim", (Object)"\u2274");
        builder.put((Object)"nlt", (Object)"\u226e");
        builder.put((Object)"nltri", (Object)"\u22ea");
        builder.put((Object)"nltrie", (Object)"\u22ec");
        builder.put((Object)"nmid", (Object)"\u2224");
        builder.put((Object)"nopf", (Object)"\ud835\udd5f");
        builder.put((Object)"not", (Object)"\u00ac");
        builder.put((Object)"notin", (Object)"\u2209");
        builder.put((Object)"notinE", (Object)"\u22f9\u0338");
        builder.put((Object)"notindot", (Object)"\u22f5\u0338");
        builder.put((Object)"notinva", (Object)"\u2209");
        builder.put((Object)"notinvb", (Object)"\u22f7");
        builder.put((Object)"notinvc", (Object)"\u22f6");
        builder.put((Object)"notni", (Object)"\u220c");
        builder.put((Object)"notniva", (Object)"\u220c");
        builder.put((Object)"notnivb", (Object)"\u22fe");
        builder.put((Object)"notnivc", (Object)"\u22fd");
        builder.put((Object)"npar", (Object)"\u2226");
        builder.put((Object)"nparallel", (Object)"\u2226");
        builder.put((Object)"nparsl", (Object)"\u2afd\u20e5");
        builder.put((Object)"npart", (Object)"\u2202\u0338");
        builder.put((Object)"npolint", (Object)"\u2a14");
        builder.put((Object)"npr", (Object)"\u2280");
        builder.put((Object)"nprcue", (Object)"\u22e0");
        builder.put((Object)"npre", (Object)"\u2aaf\u0338");
        builder.put((Object)"nprec", (Object)"\u2280");
        builder.put((Object)"npreceq", (Object)"\u2aaf\u0338");
        builder.put((Object)"nrArr", (Object)"\u21cf");
        builder.put((Object)"nrarr", (Object)"\u219b");
        builder.put((Object)"nrarrc", (Object)"\u2933\u0338");
        builder.put((Object)"nrarrw", (Object)"\u219d\u0338");
        builder.put((Object)"nrightarrow", (Object)"\u219b");
        builder.put((Object)"nrtri", (Object)"\u22eb");
        builder.put((Object)"nrtrie", (Object)"\u22ed");
        builder.put((Object)"nsc", (Object)"\u2281");
        builder.put((Object)"nsccue", (Object)"\u22e1");
        builder.put((Object)"nsce", (Object)"\u2ab0\u0338");
        builder.put((Object)"nscr", (Object)"\ud835\udcc3");
        builder.put((Object)"nshortmid", (Object)"\u2224");
        builder.put((Object)"nshortparallel", (Object)"\u2226");
        builder.put((Object)"nsim", (Object)"\u2241");
        builder.put((Object)"nsime", (Object)"\u2244");
        builder.put((Object)"nsimeq", (Object)"\u2244");
        builder.put((Object)"nsmid", (Object)"\u2224");
        builder.put((Object)"nspar", (Object)"\u2226");
        builder.put((Object)"nsqsube", (Object)"\u22e2");
        builder.put((Object)"nsqsupe", (Object)"\u22e3");
        builder.put((Object)"nsub", (Object)"\u2284");
        builder.put((Object)"nsubE", (Object)"\u2ac5\u0338");
        builder.put((Object)"nsube", (Object)"\u2288");
        builder.put((Object)"nsubset", (Object)"\u2282\u20d2");
        builder.put((Object)"nsubseteq", (Object)"\u2288");
        builder.put((Object)"nsubseteqq", (Object)"\u2ac5\u0338");
        builder.put((Object)"nsucc", (Object)"\u2281");
        builder.put((Object)"nsucceq", (Object)"\u2ab0\u0338");
        builder.put((Object)"nsup", (Object)"\u2285");
        builder.put((Object)"nsupE", (Object)"\u2ac6\u0338");
        builder.put((Object)"nsupe", (Object)"\u2289");
        builder.put((Object)"nsupset", (Object)"\u2283\u20d2");
        builder.put((Object)"nsupseteq", (Object)"\u2289");
        builder.put((Object)"nsupseteqq", (Object)"\u2ac6\u0338");
        builder.put((Object)"ntgl", (Object)"\u2279");
        builder.put((Object)"ntilde", (Object)"\u00f1");
        builder.put((Object)"ntlg", (Object)"\u2278");
        builder.put((Object)"ntriangleleft", (Object)"\u22ea");
        builder.put((Object)"ntrianglelefteq", (Object)"\u22ec");
        builder.put((Object)"ntriangleright", (Object)"\u22eb");
        builder.put((Object)"ntrianglerighteq", (Object)"\u22ed");
        builder.put((Object)"nu", (Object)"\u03bd");
        builder.put((Object)"num", (Object)"#");
        builder.put((Object)"numero", (Object)"\u2116");
        builder.put((Object)"numsp", (Object)"\u2007");
        builder.put((Object)"nvDash", (Object)"\u22ad");
        builder.put((Object)"nvHarr", (Object)"\u2904");
        builder.put((Object)"nvap", (Object)"\u224d\u20d2");
        builder.put((Object)"nvdash", (Object)"\u22ac");
        builder.put((Object)"nvge", (Object)"\u2265\u20d2");
        builder.put((Object)"nvgt", (Object)">\u20d2");
        builder.put((Object)"nvinfin", (Object)"\u29de");
        builder.put((Object)"nvlArr", (Object)"\u2902");
        builder.put((Object)"nvle", (Object)"\u2264\u20d2");
        builder.put((Object)"nvlt", (Object)"<\u20d2");
        builder.put((Object)"nvltrie", (Object)"\u22b4\u20d2");
        builder.put((Object)"nvrArr", (Object)"\u2903");
        builder.put((Object)"nvrtrie", (Object)"\u22b5\u20d2");
        builder.put((Object)"nvsim", (Object)"\u223c\u20d2");
        builder.put((Object)"nwArr", (Object)"\u21d6");
        builder.put((Object)"nwarhk", (Object)"\u2923");
        builder.put((Object)"nwarr", (Object)"\u2196");
        builder.put((Object)"nwarrow", (Object)"\u2196");
        builder.put((Object)"nwnear", (Object)"\u2927");
        builder.put((Object)"oS", (Object)"\u24c8");
        builder.put((Object)"oacute", (Object)"\u00f3");
        builder.put((Object)"oast", (Object)"\u229b");
        builder.put((Object)"ocir", (Object)"\u229a");
        builder.put((Object)"ocirc", (Object)"\u00f4");
        builder.put((Object)"ocy", (Object)"\u043e");
        builder.put((Object)"odash", (Object)"\u229d");
        builder.put((Object)"odblac", (Object)"\u0151");
        builder.put((Object)"odiv", (Object)"\u2a38");
        builder.put((Object)"odot", (Object)"\u2299");
        builder.put((Object)"odsold", (Object)"\u29bc");
        builder.put((Object)"oelig", (Object)"\u0153");
        builder.put((Object)"ofcir", (Object)"\u29bf");
        builder.put((Object)"ofr", (Object)"\ud835\udd2c");
        builder.put((Object)"ogon", (Object)"\u02db");
        builder.put((Object)"ograve", (Object)"\u00f2");
        builder.put((Object)"ogt", (Object)"\u29c1");
        builder.put((Object)"ohbar", (Object)"\u29b5");
        builder.put((Object)"ohm", (Object)"\u03a9");
        builder.put((Object)"oint", (Object)"\u222e");
        builder.put((Object)"olarr", (Object)"\u21ba");
        builder.put((Object)"olcir", (Object)"\u29be");
        builder.put((Object)"olcross", (Object)"\u29bb");
        builder.put((Object)"oline", (Object)"\u203e");
        builder.put((Object)"olt", (Object)"\u29c0");
        builder.put((Object)"omacr", (Object)"\u014d");
        builder.put((Object)"omega", (Object)"\u03c9");
        builder.put((Object)"omicron", (Object)"\u03bf");
        builder.put((Object)"omid", (Object)"\u29b6");
        builder.put((Object)"ominus", (Object)"\u2296");
        builder.put((Object)"oopf", (Object)"\ud835\udd60");
        builder.put((Object)"opar", (Object)"\u29b7");
        builder.put((Object)"operp", (Object)"\u29b9");
        builder.put((Object)"oplus", (Object)"\u2295");
        builder.put((Object)"or", (Object)"\u2228");
        builder.put((Object)"orarr", (Object)"\u21bb");
        builder.put((Object)"ord", (Object)"\u2a5d");
        builder.put((Object)"order", (Object)"\u2134");
        builder.put((Object)"orderof", (Object)"\u2134");
        builder.put((Object)"ordf", (Object)"\u00aa");
        builder.put((Object)"ordm", (Object)"\u00ba");
        builder.put((Object)"origof", (Object)"\u22b6");
        builder.put((Object)"oror", (Object)"\u2a56");
        builder.put((Object)"orslope", (Object)"\u2a57");
        builder.put((Object)"orv", (Object)"\u2a5b");
        builder.put((Object)"oscr", (Object)"\u2134");
        builder.put((Object)"oslash", (Object)"\u00f8");
        builder.put((Object)"osol", (Object)"\u2298");
        builder.put((Object)"otilde", (Object)"\u00f5");
        builder.put((Object)"otimes", (Object)"\u2297");
        builder.put((Object)"otimesas", (Object)"\u2a36");
        builder.put((Object)"ouml", (Object)"\u00f6");
        builder.put((Object)"ovbar", (Object)"\u233d");
        builder.put((Object)"par", (Object)"\u2225");
        builder.put((Object)"para", (Object)"\u00b6");
        builder.put((Object)"parallel", (Object)"\u2225");
        builder.put((Object)"parsim", (Object)"\u2af3");
        builder.put((Object)"parsl", (Object)"\u2afd");
        builder.put((Object)"part", (Object)"\u2202");
        builder.put((Object)"pcy", (Object)"\u043f");
        builder.put((Object)"percnt", (Object)"%");
        builder.put((Object)"period", (Object)".");
        builder.put((Object)"permil", (Object)"\u2030");
        builder.put((Object)"perp", (Object)"\u22a5");
        builder.put((Object)"pertenk", (Object)"\u2031");
        builder.put((Object)"pfr", (Object)"\ud835\udd2d");
        builder.put((Object)"phi", (Object)"\u03c6");
        builder.put((Object)"phiv", (Object)"\u03d5");
        builder.put((Object)"phmmat", (Object)"\u2133");
        builder.put((Object)"phone", (Object)"\u260e");
        builder.put((Object)"pi", (Object)"\u03c0");
        builder.put((Object)"pitchfork", (Object)"\u22d4");
        builder.put((Object)"piv", (Object)"\u03d6");
        builder.put((Object)"planck", (Object)"\u210f");
        builder.put((Object)"planckh", (Object)"\u210e");
        builder.put((Object)"plankv", (Object)"\u210f");
        builder.put((Object)"plus", (Object)"+");
        builder.put((Object)"plusacir", (Object)"\u2a23");
        builder.put((Object)"plusb", (Object)"\u229e");
        builder.put((Object)"pluscir", (Object)"\u2a22");
        builder.put((Object)"plusdo", (Object)"\u2214");
        builder.put((Object)"plusdu", (Object)"\u2a25");
        builder.put((Object)"pluse", (Object)"\u2a72");
        builder.put((Object)"plusmn", (Object)"\u00b1");
        builder.put((Object)"plussim", (Object)"\u2a26");
        builder.put((Object)"plustwo", (Object)"\u2a27");
        builder.put((Object)"pm", (Object)"\u00b1");
        builder.put((Object)"pointint", (Object)"\u2a15");
        builder.put((Object)"popf", (Object)"\ud835\udd61");
        builder.put((Object)"pound", (Object)"\u00a3");
        builder.put((Object)"pr", (Object)"\u227a");
        builder.put((Object)"prE", (Object)"\u2ab3");
        builder.put((Object)"prap", (Object)"\u2ab7");
        builder.put((Object)"prcue", (Object)"\u227c");
        builder.put((Object)"pre", (Object)"\u2aaf");
        builder.put((Object)"prec", (Object)"\u227a");
        builder.put((Object)"precapprox", (Object)"\u2ab7");
        builder.put((Object)"preccurlyeq", (Object)"\u227c");
        builder.put((Object)"preceq", (Object)"\u2aaf");
        builder.put((Object)"precnapprox", (Object)"\u2ab9");
        builder.put((Object)"precneqq", (Object)"\u2ab5");
        builder.put((Object)"precnsim", (Object)"\u22e8");
        builder.put((Object)"precsim", (Object)"\u227e");
        builder.put((Object)"prime", (Object)"\u2032");
        builder.put((Object)"primes", (Object)"\u2119");
        builder.put((Object)"prnE", (Object)"\u2ab5");
        builder.put((Object)"prnap", (Object)"\u2ab9");
        builder.put((Object)"prnsim", (Object)"\u22e8");
        builder.put((Object)"prod", (Object)"\u220f");
        builder.put((Object)"profalar", (Object)"\u232e");
        builder.put((Object)"profline", (Object)"\u2312");
        builder.put((Object)"profsurf", (Object)"\u2313");
        builder.put((Object)"prop", (Object)"\u221d");
        builder.put((Object)"propto", (Object)"\u221d");
        builder.put((Object)"prsim", (Object)"\u227e");
        builder.put((Object)"prurel", (Object)"\u22b0");
        builder.put((Object)"pscr", (Object)"\ud835\udcc5");
        builder.put((Object)"psi", (Object)"\u03c8");
        builder.put((Object)"puncsp", (Object)"\u2008");
        builder.put((Object)"qfr", (Object)"\ud835\udd2e");
        builder.put((Object)"qint", (Object)"\u2a0c");
        builder.put((Object)"qopf", (Object)"\ud835\udd62");
        builder.put((Object)"qprime", (Object)"\u2057");
        builder.put((Object)"qscr", (Object)"\ud835\udcc6");
        builder.put((Object)"quaternions", (Object)"\u210d");
        builder.put((Object)"quatint", (Object)"\u2a16");
        builder.put((Object)"quest", (Object)"?");
        builder.put((Object)"questeq", (Object)"\u225f");
        builder.put((Object)"quot", (Object)"\"");
        builder.put((Object)"rAarr", (Object)"\u21db");
        builder.put((Object)"rArr", (Object)"\u21d2");
        builder.put((Object)"rAtail", (Object)"\u291c");
        builder.put((Object)"rBarr", (Object)"\u290f");
        builder.put((Object)"rHar", (Object)"\u2964");
        builder.put((Object)"race", (Object)"\u223d\u0331");
        builder.put((Object)"racute", (Object)"\u0155");
        builder.put((Object)"radic", (Object)"\u221a");
        builder.put((Object)"raemptyv", (Object)"\u29b3");
        builder.put((Object)"rang", (Object)"\u27e9");
        builder.put((Object)"rangd", (Object)"\u2992");
        builder.put((Object)"range", (Object)"\u29a5");
        builder.put((Object)"rangle", (Object)"\u27e9");
        builder.put((Object)"raquo", (Object)"\u00bb");
        builder.put((Object)"rarr", (Object)"\u2192");
        builder.put((Object)"rarrap", (Object)"\u2975");
        builder.put((Object)"rarrb", (Object)"\u21e5");
        builder.put((Object)"rarrbfs", (Object)"\u2920");
        builder.put((Object)"rarrc", (Object)"\u2933");
        builder.put((Object)"rarrfs", (Object)"\u291e");
        builder.put((Object)"rarrhk", (Object)"\u21aa");
        builder.put((Object)"rarrlp", (Object)"\u21ac");
        builder.put((Object)"rarrpl", (Object)"\u2945");
        builder.put((Object)"rarrsim", (Object)"\u2974");
        builder.put((Object)"rarrtl", (Object)"\u21a3");
        builder.put((Object)"rarrw", (Object)"\u219d");
        builder.put((Object)"ratail", (Object)"\u291a");
        builder.put((Object)"ratio", (Object)"\u2236");
        builder.put((Object)"rationals", (Object)"\u211a");
        builder.put((Object)"rbarr", (Object)"\u290d");
        builder.put((Object)"rbbrk", (Object)"\u2773");
        builder.put((Object)"rbrace", (Object)"}");
        builder.put((Object)"rbrack", (Object)"]");
        builder.put((Object)"rbrke", (Object)"\u298c");
        builder.put((Object)"rbrksld", (Object)"\u298e");
        builder.put((Object)"rbrkslu", (Object)"\u2990");
        builder.put((Object)"rcaron", (Object)"\u0159");
        builder.put((Object)"rcedil", (Object)"\u0157");
        builder.put((Object)"rceil", (Object)"\u2309");
        builder.put((Object)"rcub", (Object)"}");
        builder.put((Object)"rcy", (Object)"\u0440");
        builder.put((Object)"rdca", (Object)"\u2937");
        builder.put((Object)"rdldhar", (Object)"\u2969");
        builder.put((Object)"rdquo", (Object)"\u201d");
        builder.put((Object)"rdquor", (Object)"\u201d");
        builder.put((Object)"rdsh", (Object)"\u21b3");
        builder.put((Object)"real", (Object)"\u211c");
        builder.put((Object)"realine", (Object)"\u211b");
        builder.put((Object)"realpart", (Object)"\u211c");
        builder.put((Object)"reals", (Object)"\u211d");
        builder.put((Object)"rect", (Object)"\u25ad");
        builder.put((Object)"reg", (Object)"\u00ae");
        builder.put((Object)"rfisht", (Object)"\u297d");
        builder.put((Object)"rfloor", (Object)"\u230b");
        builder.put((Object)"rfr", (Object)"\ud835\udd2f");
        builder.put((Object)"rhard", (Object)"\u21c1");
        builder.put((Object)"rharu", (Object)"\u21c0");
        builder.put((Object)"rharul", (Object)"\u296c");
        builder.put((Object)"rho", (Object)"\u03c1");
        builder.put((Object)"rhov", (Object)"\u03f1");
        builder.put((Object)"rightarrow", (Object)"\u2192");
        builder.put((Object)"rightarrowtail", (Object)"\u21a3");
        builder.put((Object)"rightharpoondown", (Object)"\u21c1");
        builder.put((Object)"rightharpoonup", (Object)"\u21c0");
        builder.put((Object)"rightleftarrows", (Object)"\u21c4");
        builder.put((Object)"rightleftharpoons", (Object)"\u21cc");
        builder.put((Object)"rightrightarrows", (Object)"\u21c9");
        builder.put((Object)"rightsquigarrow", (Object)"\u219d");
        builder.put((Object)"rightthreetimes", (Object)"\u22cc");
        builder.put((Object)"ring", (Object)"\u02da");
        builder.put((Object)"risingdotseq", (Object)"\u2253");
        builder.put((Object)"rlarr", (Object)"\u21c4");
        builder.put((Object)"rlhar", (Object)"\u21cc");
        builder.put((Object)"rlm", (Object)"\u200f");
        builder.put((Object)"rmoust", (Object)"\u23b1");
        builder.put((Object)"rmoustache", (Object)"\u23b1");
        builder.put((Object)"rnmid", (Object)"\u2aee");
        builder.put((Object)"roang", (Object)"\u27ed");
        builder.put((Object)"roarr", (Object)"\u21fe");
        builder.put((Object)"robrk", (Object)"\u27e7");
        builder.put((Object)"ropar", (Object)"\u2986");
        builder.put((Object)"ropf", (Object)"\ud835\udd63");
        builder.put((Object)"roplus", (Object)"\u2a2e");
        builder.put((Object)"rotimes", (Object)"\u2a35");
        builder.put((Object)"rpar", (Object)")");
        builder.put((Object)"rpargt", (Object)"\u2994");
        builder.put((Object)"rppolint", (Object)"\u2a12");
        builder.put((Object)"rrarr", (Object)"\u21c9");
        builder.put((Object)"rsaquo", (Object)"\u203a");
        builder.put((Object)"rscr", (Object)"\ud835\udcc7");
        builder.put((Object)"rsh", (Object)"\u21b1");
        builder.put((Object)"rsqb", (Object)"]");
        builder.put((Object)"rsquo", (Object)"\u2019");
        builder.put((Object)"rsquor", (Object)"\u2019");
        builder.put((Object)"rthree", (Object)"\u22cc");
        builder.put((Object)"rtimes", (Object)"\u22ca");
        builder.put((Object)"rtri", (Object)"\u25b9");
        builder.put((Object)"rtrie", (Object)"\u22b5");
        builder.put((Object)"rtrif", (Object)"\u25b8");
        builder.put((Object)"rtriltri", (Object)"\u29ce");
        builder.put((Object)"ruluhar", (Object)"\u2968");
        builder.put((Object)"rx", (Object)"\u211e");
        builder.put((Object)"sacute", (Object)"\u015b");
        builder.put((Object)"sbquo", (Object)"\u201a");
        builder.put((Object)"sc", (Object)"\u227b");
        builder.put((Object)"scE", (Object)"\u2ab4");
        builder.put((Object)"scap", (Object)"\u2ab8");
        builder.put((Object)"scaron", (Object)"\u0161");
        builder.put((Object)"sccue", (Object)"\u227d");
        builder.put((Object)"sce", (Object)"\u2ab0");
        builder.put((Object)"scedil", (Object)"\u015f");
        builder.put((Object)"scirc", (Object)"\u015d");
        builder.put((Object)"scnE", (Object)"\u2ab6");
        builder.put((Object)"scnap", (Object)"\u2aba");
        builder.put((Object)"scnsim", (Object)"\u22e9");
        builder.put((Object)"scpolint", (Object)"\u2a13");
        builder.put((Object)"scsim", (Object)"\u227f");
        builder.put((Object)"scy", (Object)"\u0441");
        builder.put((Object)"sdot", (Object)"\u22c5");
        builder.put((Object)"sdotb", (Object)"\u22a1");
        builder.put((Object)"sdote", (Object)"\u2a66");
        builder.put((Object)"seArr", (Object)"\u21d8");
        builder.put((Object)"searhk", (Object)"\u2925");
        builder.put((Object)"searr", (Object)"\u2198");
        builder.put((Object)"searrow", (Object)"\u2198");
        builder.put((Object)"sect", (Object)"\u00a7");
        builder.put((Object)"semi", (Object)";");
        builder.put((Object)"seswar", (Object)"\u2929");
        builder.put((Object)"setminus", (Object)"\u2216");
        builder.put((Object)"setmn", (Object)"\u2216");
        builder.put((Object)"sext", (Object)"\u2736");
        builder.put((Object)"sfr", (Object)"\ud835\udd30");
        builder.put((Object)"sfrown", (Object)"\u2322");
        builder.put((Object)"sharp", (Object)"\u266f");
        builder.put((Object)"shchcy", (Object)"\u0449");
        builder.put((Object)"shcy", (Object)"\u0448");
        builder.put((Object)"shortmid", (Object)"\u2223");
        builder.put((Object)"shortparallel", (Object)"\u2225");
        builder.put((Object)"shy", (Object)"\u00ad");
        builder.put((Object)"sigma", (Object)"\u03c3");
        builder.put((Object)"sigmaf", (Object)"\u03c2");
        builder.put((Object)"sigmav", (Object)"\u03c2");
        builder.put((Object)"sim", (Object)"\u223c");
        builder.put((Object)"simdot", (Object)"\u2a6a");
        builder.put((Object)"sime", (Object)"\u2243");
        builder.put((Object)"simeq", (Object)"\u2243");
        builder.put((Object)"simg", (Object)"\u2a9e");
        builder.put((Object)"simgE", (Object)"\u2aa0");
        builder.put((Object)"siml", (Object)"\u2a9d");
        builder.put((Object)"simlE", (Object)"\u2a9f");
        builder.put((Object)"simne", (Object)"\u2246");
        builder.put((Object)"simplus", (Object)"\u2a24");
        builder.put((Object)"simrarr", (Object)"\u2972");
        builder.put((Object)"slarr", (Object)"\u2190");
        builder.put((Object)"smallsetminus", (Object)"\u2216");
        builder.put((Object)"smashp", (Object)"\u2a33");
        builder.put((Object)"smeparsl", (Object)"\u29e4");
        builder.put((Object)"smid", (Object)"\u2223");
        builder.put((Object)"smile", (Object)"\u2323");
        builder.put((Object)"smt", (Object)"\u2aaa");
        builder.put((Object)"smte", (Object)"\u2aac");
        builder.put((Object)"smtes", (Object)"\u2aac\ufe00");
        builder.put((Object)"softcy", (Object)"\u044c");
        builder.put((Object)"sol", (Object)"/");
        builder.put((Object)"solb", (Object)"\u29c4");
        builder.put((Object)"solbar", (Object)"\u233f");
        builder.put((Object)"sopf", (Object)"\ud835\udd64");
        builder.put((Object)"spades", (Object)"\u2660");
        builder.put((Object)"spadesuit", (Object)"\u2660");
        builder.put((Object)"spar", (Object)"\u2225");
        builder.put((Object)"sqcap", (Object)"\u2293");
        builder.put((Object)"sqcaps", (Object)"\u2293\ufe00");
        builder.put((Object)"sqcup", (Object)"\u2294");
        builder.put((Object)"sqcups", (Object)"\u2294\ufe00");
        builder.put((Object)"sqsub", (Object)"\u228f");
        builder.put((Object)"sqsube", (Object)"\u2291");
        builder.put((Object)"sqsubset", (Object)"\u228f");
        builder.put((Object)"sqsubseteq", (Object)"\u2291");
        builder.put((Object)"sqsup", (Object)"\u2290");
        builder.put((Object)"sqsupe", (Object)"\u2292");
        builder.put((Object)"sqsupset", (Object)"\u2290");
        builder.put((Object)"sqsupseteq", (Object)"\u2292");
        builder.put((Object)"squ", (Object)"\u25a1");
        builder.put((Object)"square", (Object)"\u25a1");
        builder.put((Object)"squarf", (Object)"\u25aa");
        builder.put((Object)"squf", (Object)"\u25aa");
        builder.put((Object)"srarr", (Object)"\u2192");
        builder.put((Object)"sscr", (Object)"\ud835\udcc8");
        builder.put((Object)"ssetmn", (Object)"\u2216");
        builder.put((Object)"ssmile", (Object)"\u2323");
        builder.put((Object)"sstarf", (Object)"\u22c6");
        builder.put((Object)"star", (Object)"\u2606");
        builder.put((Object)"starf", (Object)"\u2605");
        builder.put((Object)"straightepsilon", (Object)"\u03f5");
        builder.put((Object)"straightphi", (Object)"\u03d5");
        builder.put((Object)"strns", (Object)"\u00af");
        builder.put((Object)"sub", (Object)"\u2282");
        builder.put((Object)"subE", (Object)"\u2ac5");
        builder.put((Object)"subdot", (Object)"\u2abd");
        builder.put((Object)"sube", (Object)"\u2286");
        builder.put((Object)"subedot", (Object)"\u2ac3");
        builder.put((Object)"submult", (Object)"\u2ac1");
        builder.put((Object)"subnE", (Object)"\u2acb");
        builder.put((Object)"subne", (Object)"\u228a");
        builder.put((Object)"subplus", (Object)"\u2abf");
        builder.put((Object)"subrarr", (Object)"\u2979");
        builder.put((Object)"subset", (Object)"\u2282");
        builder.put((Object)"subseteq", (Object)"\u2286");
        builder.put((Object)"subseteqq", (Object)"\u2ac5");
        builder.put((Object)"subsetneq", (Object)"\u228a");
        builder.put((Object)"subsetneqq", (Object)"\u2acb");
        builder.put((Object)"subsim", (Object)"\u2ac7");
        builder.put((Object)"subsub", (Object)"\u2ad5");
        builder.put((Object)"subsup", (Object)"\u2ad3");
        builder.put((Object)"succ", (Object)"\u227b");
        builder.put((Object)"succapprox", (Object)"\u2ab8");
        builder.put((Object)"succcurlyeq", (Object)"\u227d");
        builder.put((Object)"succeq", (Object)"\u2ab0");
        builder.put((Object)"succnapprox", (Object)"\u2aba");
        builder.put((Object)"succneqq", (Object)"\u2ab6");
        builder.put((Object)"succnsim", (Object)"\u22e9");
        builder.put((Object)"succsim", (Object)"\u227f");
        builder.put((Object)"sum", (Object)"\u2211");
        builder.put((Object)"sung", (Object)"\u266a");
        builder.put((Object)"sup1", (Object)"\u00b9");
        builder.put((Object)"sup2", (Object)"\u00b2");
        builder.put((Object)"sup3", (Object)"\u00b3");
        builder.put((Object)"sup", (Object)"\u2283");
        builder.put((Object)"supE", (Object)"\u2ac6");
        builder.put((Object)"supdot", (Object)"\u2abe");
        builder.put((Object)"supdsub", (Object)"\u2ad8");
        builder.put((Object)"supe", (Object)"\u2287");
        builder.put((Object)"supedot", (Object)"\u2ac4");
        builder.put((Object)"suphsol", (Object)"\u27c9");
        builder.put((Object)"suphsub", (Object)"\u2ad7");
        builder.put((Object)"suplarr", (Object)"\u297b");
        builder.put((Object)"supmult", (Object)"\u2ac2");
        builder.put((Object)"supnE", (Object)"\u2acc");
        builder.put((Object)"supne", (Object)"\u228b");
        builder.put((Object)"supplus", (Object)"\u2ac0");
        builder.put((Object)"supset", (Object)"\u2283");
        builder.put((Object)"supseteq", (Object)"\u2287");
        builder.put((Object)"supseteqq", (Object)"\u2ac6");
        builder.put((Object)"supsetneq", (Object)"\u228b");
        builder.put((Object)"supsetneqq", (Object)"\u2acc");
        builder.put((Object)"supsim", (Object)"\u2ac8");
        builder.put((Object)"supsub", (Object)"\u2ad4");
        builder.put((Object)"supsup", (Object)"\u2ad6");
        builder.put((Object)"swArr", (Object)"\u21d9");
        builder.put((Object)"swarhk", (Object)"\u2926");
        builder.put((Object)"swarr", (Object)"\u2199");
        builder.put((Object)"swarrow", (Object)"\u2199");
        builder.put((Object)"swnwar", (Object)"\u292a");
        builder.put((Object)"szlig", (Object)"\u00df");
        builder.put((Object)"target", (Object)"\u2316");
        builder.put((Object)"tau", (Object)"\u03c4");
        builder.put((Object)"tbrk", (Object)"\u23b4");
        builder.put((Object)"tcaron", (Object)"\u0165");
        builder.put((Object)"tcedil", (Object)"\u0163");
        builder.put((Object)"tcy", (Object)"\u0442");
        builder.put((Object)"tdot", (Object)"\u20db");
        builder.put((Object)"telrec", (Object)"\u2315");
        builder.put((Object)"tfr", (Object)"\ud835\udd31");
        builder.put((Object)"there4", (Object)"\u2234");
        builder.put((Object)"therefore", (Object)"\u2234");
        builder.put((Object)"theta", (Object)"\u03b8");
        builder.put((Object)"thetasym", (Object)"\u03d1");
        builder.put((Object)"thetav", (Object)"\u03d1");
        builder.put((Object)"thickapprox", (Object)"\u2248");
        builder.put((Object)"thicksim", (Object)"\u223c");
        builder.put((Object)"thinsp", (Object)"\u2009");
        builder.put((Object)"thkap", (Object)"\u2248");
        builder.put((Object)"thksim", (Object)"\u223c");
        builder.put((Object)"thorn", (Object)"\u00fe");
        builder.put((Object)"tilde", (Object)"\u02dc");
        builder.put((Object)"times", (Object)"\u00d7");
        builder.put((Object)"timesb", (Object)"\u22a0");
        builder.put((Object)"timesbar", (Object)"\u2a31");
        builder.put((Object)"timesd", (Object)"\u2a30");
        builder.put((Object)"tint", (Object)"\u222d");
        builder.put((Object)"toea", (Object)"\u2928");
        builder.put((Object)"top", (Object)"\u22a4");
        builder.put((Object)"topbot", (Object)"\u2336");
        builder.put((Object)"topcir", (Object)"\u2af1");
        builder.put((Object)"topf", (Object)"\ud835\udd65");
        builder.put((Object)"topfork", (Object)"\u2ada");
        builder.put((Object)"tosa", (Object)"\u2929");
        builder.put((Object)"tprime", (Object)"\u2034");
        builder.put((Object)"trade", (Object)"\u2122");
        builder.put((Object)"triangle", (Object)"\u25b5");
        builder.put((Object)"triangledown", (Object)"\u25bf");
        builder.put((Object)"triangleleft", (Object)"\u25c3");
        builder.put((Object)"trianglelefteq", (Object)"\u22b4");
        builder.put((Object)"triangleq", (Object)"\u225c");
        builder.put((Object)"triangleright", (Object)"\u25b9");
        builder.put((Object)"trianglerighteq", (Object)"\u22b5");
        builder.put((Object)"tridot", (Object)"\u25ec");
        builder.put((Object)"trie", (Object)"\u225c");
        builder.put((Object)"triminus", (Object)"\u2a3a");
        builder.put((Object)"triplus", (Object)"\u2a39");
        builder.put((Object)"trisb", (Object)"\u29cd");
        builder.put((Object)"tritime", (Object)"\u2a3b");
        builder.put((Object)"trpezium", (Object)"\u23e2");
        builder.put((Object)"tscr", (Object)"\ud835\udcc9");
        builder.put((Object)"tscy", (Object)"\u0446");
        builder.put((Object)"tshcy", (Object)"\u045b");
        builder.put((Object)"tstrok", (Object)"\u0167");
        builder.put((Object)"twixt", (Object)"\u226c");
        builder.put((Object)"twoheadleftarrow", (Object)"\u219e");
        builder.put((Object)"twoheadrightarrow", (Object)"\u21a0");
        builder.put((Object)"uArr", (Object)"\u21d1");
        builder.put((Object)"uHar", (Object)"\u2963");
        builder.put((Object)"uacute", (Object)"\u00fa");
        builder.put((Object)"uarr", (Object)"\u2191");
        builder.put((Object)"ubrcy", (Object)"\u045e");
        builder.put((Object)"ubreve", (Object)"\u016d");
        builder.put((Object)"ucirc", (Object)"\u00fb");
        builder.put((Object)"ucy", (Object)"\u0443");
        builder.put((Object)"udarr", (Object)"\u21c5");
        builder.put((Object)"udblac", (Object)"\u0171");
        builder.put((Object)"udhar", (Object)"\u296e");
        builder.put((Object)"ufisht", (Object)"\u297e");
        builder.put((Object)"ufr", (Object)"\ud835\udd32");
        builder.put((Object)"ugrave", (Object)"\u00f9");
        builder.put((Object)"uharl", (Object)"\u21bf");
        builder.put((Object)"uharr", (Object)"\u21be");
        builder.put((Object)"uhblk", (Object)"\u2580");
        builder.put((Object)"ulcorn", (Object)"\u231c");
        builder.put((Object)"ulcorner", (Object)"\u231c");
        builder.put((Object)"ulcrop", (Object)"\u230f");
        builder.put((Object)"ultri", (Object)"\u25f8");
        builder.put((Object)"umacr", (Object)"\u016b");
        builder.put((Object)"uml", (Object)"\u00a8");
        builder.put((Object)"uogon", (Object)"\u0173");
        builder.put((Object)"uopf", (Object)"\ud835\udd66");
        builder.put((Object)"uparrow", (Object)"\u2191");
        builder.put((Object)"updownarrow", (Object)"\u2195");
        builder.put((Object)"upharpoonleft", (Object)"\u21bf");
        builder.put((Object)"upharpoonright", (Object)"\u21be");
        builder.put((Object)"uplus", (Object)"\u228e");
        builder.put((Object)"upsi", (Object)"\u03c5");
        builder.put((Object)"upsih", (Object)"\u03d2");
        builder.put((Object)"upsilon", (Object)"\u03c5");
        builder.put((Object)"upuparrows", (Object)"\u21c8");
        builder.put((Object)"urcorn", (Object)"\u231d");
        builder.put((Object)"urcorner", (Object)"\u231d");
        builder.put((Object)"urcrop", (Object)"\u230e");
        builder.put((Object)"uring", (Object)"\u016f");
        builder.put((Object)"urtri", (Object)"\u25f9");
        builder.put((Object)"uscr", (Object)"\ud835\udcca");
        builder.put((Object)"utdot", (Object)"\u22f0");
        builder.put((Object)"utilde", (Object)"\u0169");
        builder.put((Object)"utri", (Object)"\u25b5");
        builder.put((Object)"utrif", (Object)"\u25b4");
        builder.put((Object)"uuarr", (Object)"\u21c8");
        builder.put((Object)"uuml", (Object)"\u00fc");
        builder.put((Object)"uwangle", (Object)"\u29a7");
        builder.put((Object)"vArr", (Object)"\u21d5");
        builder.put((Object)"vBar", (Object)"\u2ae8");
        builder.put((Object)"vBarv", (Object)"\u2ae9");
        builder.put((Object)"vDash", (Object)"\u22a8");
        builder.put((Object)"vangrt", (Object)"\u299c");
        builder.put((Object)"varepsilon", (Object)"\u03f5");
        builder.put((Object)"varkappa", (Object)"\u03f0");
        builder.put((Object)"varnothing", (Object)"\u2205");
        builder.put((Object)"varphi", (Object)"\u03d5");
        builder.put((Object)"varpi", (Object)"\u03d6");
        builder.put((Object)"varpropto", (Object)"\u221d");
        builder.put((Object)"varr", (Object)"\u2195");
        builder.put((Object)"varrho", (Object)"\u03f1");
        builder.put((Object)"varsigma", (Object)"\u03c2");
        builder.put((Object)"varsubsetneq", (Object)"\u228a\ufe00");
        builder.put((Object)"varsubsetneqq", (Object)"\u2acb\ufe00");
        builder.put((Object)"varsupsetneq", (Object)"\u228b\ufe00");
        builder.put((Object)"varsupsetneqq", (Object)"\u2acc\ufe00");
        builder.put((Object)"vartheta", (Object)"\u03d1");
        builder.put((Object)"vartriangleleft", (Object)"\u22b2");
        builder.put((Object)"vartriangleright", (Object)"\u22b3");
        builder.put((Object)"vcy", (Object)"\u0432");
        builder.put((Object)"vdash", (Object)"\u22a2");
        builder.put((Object)"vee", (Object)"\u2228");
        builder.put((Object)"veebar", (Object)"\u22bb");
        builder.put((Object)"veeeq", (Object)"\u225a");
        builder.put((Object)"vellip", (Object)"\u22ee");
        builder.put((Object)"verbar", (Object)"|");
        builder.put((Object)"vert", (Object)"|");
        builder.put((Object)"vfr", (Object)"\ud835\udd33");
        builder.put((Object)"vltri", (Object)"\u22b2");
        builder.put((Object)"vnsub", (Object)"\u2282\u20d2");
        builder.put((Object)"vnsup", (Object)"\u2283\u20d2");
        builder.put((Object)"vopf", (Object)"\ud835\udd67");
        builder.put((Object)"vprop", (Object)"\u221d");
        builder.put((Object)"vrtri", (Object)"\u22b3");
        builder.put((Object)"vscr", (Object)"\ud835\udccb");
        builder.put((Object)"vsubnE", (Object)"\u2acb\ufe00");
        builder.put((Object)"vsubne", (Object)"\u228a\ufe00");
        builder.put((Object)"vsupnE", (Object)"\u2acc\ufe00");
        builder.put((Object)"vsupne", (Object)"\u228b\ufe00");
        builder.put((Object)"vzigzag", (Object)"\u299a");
        builder.put((Object)"wcirc", (Object)"\u0175");
        builder.put((Object)"wedbar", (Object)"\u2a5f");
        builder.put((Object)"wedge", (Object)"\u2227");
        builder.put((Object)"wedgeq", (Object)"\u2259");
        builder.put((Object)"weierp", (Object)"\u2118");
        builder.put((Object)"wfr", (Object)"\ud835\udd34");
        builder.put((Object)"wopf", (Object)"\ud835\udd68");
        builder.put((Object)"wp", (Object)"\u2118");
        builder.put((Object)"wr", (Object)"\u2240");
        builder.put((Object)"wreath", (Object)"\u2240");
        builder.put((Object)"wscr", (Object)"\ud835\udccc");
        builder.put((Object)"xcap", (Object)"\u22c2");
        builder.put((Object)"xcirc", (Object)"\u25ef");
        builder.put((Object)"xcup", (Object)"\u22c3");
        builder.put((Object)"xdtri", (Object)"\u25bd");
        builder.put((Object)"xfr", (Object)"\ud835\udd35");
        builder.put((Object)"xhArr", (Object)"\u27fa");
        builder.put((Object)"xharr", (Object)"\u27f7");
        builder.put((Object)"xi", (Object)"\u03be");
        builder.put((Object)"xlArr", (Object)"\u27f8");
        builder.put((Object)"xlarr", (Object)"\u27f5");
        builder.put((Object)"xmap", (Object)"\u27fc");
        builder.put((Object)"xnis", (Object)"\u22fb");
        builder.put((Object)"xodot", (Object)"\u2a00");
        builder.put((Object)"xopf", (Object)"\ud835\udd69");
        builder.put((Object)"xoplus", (Object)"\u2a01");
        builder.put((Object)"xotime", (Object)"\u2a02");
        builder.put((Object)"xrArr", (Object)"\u27f9");
        builder.put((Object)"xrarr", (Object)"\u27f6");
        builder.put((Object)"xscr", (Object)"\ud835\udccd");
        builder.put((Object)"xsqcup", (Object)"\u2a06");
        builder.put((Object)"xuplus", (Object)"\u2a04");
        builder.put((Object)"xutri", (Object)"\u25b3");
        builder.put((Object)"xvee", (Object)"\u22c1");
        builder.put((Object)"xwedge", (Object)"\u22c0");
        builder.put((Object)"yacute", (Object)"\u00fd");
        builder.put((Object)"yacy", (Object)"\u044f");
        builder.put((Object)"ycirc", (Object)"\u0177");
        builder.put((Object)"ycy", (Object)"\u044b");
        builder.put((Object)"yen", (Object)"\u00a5");
        builder.put((Object)"yfr", (Object)"\ud835\udd36");
        builder.put((Object)"yicy", (Object)"\u0457");
        builder.put((Object)"yopf", (Object)"\ud835\udd6a");
        builder.put((Object)"yscr", (Object)"\ud835\udcce");
        builder.put((Object)"yucy", (Object)"\u044e");
        builder.put((Object)"yuml", (Object)"\u00ff");
        builder.put((Object)"zacute", (Object)"\u017a");
        builder.put((Object)"zcaron", (Object)"\u017e");
        builder.put((Object)"zcy", (Object)"\u0437");
        builder.put((Object)"zdot", (Object)"\u017c");
        builder.put((Object)"zeetrf", (Object)"\u2128");
        builder.put((Object)"zeta", (Object)"\u03b6");
        builder.put((Object)"zfr", (Object)"\ud835\udd37");
        builder.put((Object)"zhcy", (Object)"\u0436");
        builder.put((Object)"zigrarr", (Object)"\u21dd");
        builder.put((Object)"zopf", (Object)"\ud835\udd6b");
        builder.put((Object)"zscr", (Object)"\ud835\udccf");
        builder.put((Object)"zwj", (Object)"\u200d");
        builder.put((Object)"zwnj", (Object)"\u200c");
        ImmutableMap entityNameToCodePointMap = builder.build();
        int longestEntityName = 0;
        for (String entityName : entityNameToCodePointMap.keySet()) {
            if (entityName.length() <= longestEntityName) continue;
            longestEntityName = entityName.length();
        }
        ENTITY_TRIE = new Trie(entityNameToCodePointMap);
        LONGEST_ENTITY_NAME = longestEntityName;
    }
}

