/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import org.owasp.html.AttributePolicy;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;

public final class Sanitizers {
    public static final PolicyFactory FORMATTING = new HtmlPolicyBuilder().allowCommonInlineFormattingElements().toFactory();
    public static final PolicyFactory BLOCKS = new HtmlPolicyBuilder().allowCommonBlockElements().toFactory();
    public static final PolicyFactory STYLES = new HtmlPolicyBuilder().allowStyling().toFactory();
    public static final PolicyFactory LINKS = new HtmlPolicyBuilder().allowStandardUrlProtocols().allowElements("a").allowAttributes("href").onElements("a").requireRelNofollowOnLinks().toFactory();
    public static final PolicyFactory TABLES = new HtmlPolicyBuilder().allowStandardUrlProtocols().allowElements("table", "tr", "td", "th", "colgroup", "caption", "col", "thead", "tbody", "tfoot").allowAttributes("summary").onElements("table").allowAttributes("align", "valign").onElements("table", "tr", "td", "th", "colgroup", "col", "thead", "tbody", "tfoot").allowTextIn("table").toFactory();
    private static final AttributePolicy INTEGER = new AttributePolicy(){

        @Override
        public String apply(String elementName, String attributeName, String value) {
            int n = value.length();
            if (n == 0) {
                return null;
            }
            for (int i2 = 0; i2 < n; ++i2) {
                char ch = value.charAt(i2);
                if (ch == '.') {
                    if (i2 == 0) {
                        return null;
                    }
                    return value.substring(0, i2);
                }
                if ('0' <= ch && ch <= '9') continue;
                return null;
            }
            return value;
        }
    };
    public static final PolicyFactory IMAGES = new HtmlPolicyBuilder().allowUrlProtocols("http", "https").allowElements("img").allowAttributes("alt", "src").onElements("img").allowAttributes("border", "height", "width").matching(INTEGER).onElements("img").toFactory();

    private Sanitizers() {
    }
}

