/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

final class Strings {
    private static final char[] LCASE_CHARS;
    private static final char[] UCASE_CHARS;
    private static final long HTML_SPACE_CHAR_BITMASK = 4294981120L;

    public static boolean regionMatchesIgnoreCase(CharSequence a, int aoffset, CharSequence b, int boffset, int n) {
        if (aoffset + n > a.length() || boffset + n > b.length()) {
            return false;
        }
        int i2 = n;
        while (--i2 >= 0) {
            char d;
            char c = a.charAt(aoffset + i2);
            if (c == (d = b.charAt(boffset + i2))) continue;
            if (c <= 'z' && c >= 'A') {
                if (c <= 'Z') {
                    c = (char)(c | 0x20);
                }
                if (d <= 'Z' && d >= 'A') {
                    d = (char)(d | 0x20);
                }
                if (c == d) continue;
            }
            return false;
        }
        return true;
    }

    public static String toLowerCase(String s) {
        int i2 = s.length();
        while (--i2 >= 0) {
            char c = s.charAt(i2);
            if (c > 'Z' || c < 'A') continue;
            char[] chars = s.toCharArray();
            chars[i2] = LCASE_CHARS[c];
            while (--i2 >= 0) {
                c = chars[i2];
                if (c > 'Z') continue;
                chars[i2] = LCASE_CHARS[c];
            }
            return String.valueOf(chars);
        }
        return s;
    }

    static boolean isHtmlSpace(int ch) {
        return ch <= 32 && (0x100003600L & 1L << ch) != 0L;
    }

    static boolean containsHtmlSpace(String s) {
        int n = s.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if (!Strings.isHtmlSpace(s.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    static String stripHtmlSpaces(String s) {
        int n;
        int i2 = 0;
        for (n = s.length(); n > i2 && Strings.isHtmlSpace(s.charAt(n - 1)); --n) {
        }
        while (i2 < n && Strings.isHtmlSpace(s.charAt(i2))) {
            ++i2;
        }
        if (i2 == 0 && n == s.length()) {
            return s;
        }
        return s.substring(i2, n);
    }

    static int skipValidFloatingPointNumber(String value, int start) {
        char ch;
        int i2 = start;
        int n = value.length();
        if (i2 >= n) {
            return -1;
        }
        if (value.charAt(i2) == '-') {
            ++i2;
        }
        boolean hasMantissa = false;
        while (i2 < n && '0' <= (ch = value.charAt(i2)) && ch <= '9') {
            ++i2;
            hasMantissa = true;
        }
        if (i2 < n && value.charAt(i2) == '.') {
            ++i2;
            hasMantissa = false;
            while (i2 < n && '0' <= (ch = value.charAt(i2)) && ch <= '9') {
                ++i2;
                hasMantissa = true;
            }
        }
        if (!hasMantissa) {
            return -1;
        }
        if (i2 < n && (value.charAt(i2) | 0x20) == 101) {
            char ch2;
            if (++i2 < n && ((ch = value.charAt(i2)) == '+' || ch == '-')) {
                ++i2;
            }
            boolean hasExponent = false;
            while (i2 < n && '0' <= (ch2 = value.charAt(i2)) && ch2 <= '9') {
                ++i2;
                hasExponent = true;
            }
            if (!hasExponent) {
                return -1;
            }
        }
        return i2;
    }

    private Strings() {
    }

    static {
        int i2;
        LCASE_CHARS = new char[91];
        UCASE_CHARS = new char[123];
        for (i2 = 0; i2 < 65; ++i2) {
            Strings.LCASE_CHARS[i2] = (char)i2;
        }
        for (i2 = 65; i2 <= 90; ++i2) {
            Strings.LCASE_CHARS[i2] = (char)(i2 | 0x20);
        }
        for (i2 = 0; i2 < 97; ++i2) {
            Strings.UCASE_CHARS[i2] = (char)i2;
        }
        for (i2 = 97; i2 <= 122; ++i2) {
            Strings.UCASE_CHARS[i2] = (char)(i2 & 0xFFFFFFDF);
        }
    }
}

