/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.owasp.html.HtmlElementTables;
import org.owasp.html.HtmlLexer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlTextEscapingMode;
import org.owasp.html.IntVector;
import org.owasp.html.Strings;
import org.owasp.html.TCB;

@TCB
public class TagBalancingHtmlStreamEventReceiver
implements HtmlStreamEventReceiver {
    private final HtmlStreamEventReceiver underlying;
    private int nestingLimit = Integer.MAX_VALUE;
    private final IntVector openElements = new IntVector();
    private final IntVector toResumeInReverse = new IntVector();
    private static final HtmlElementTables METADATA;
    private static final int UNRECOGNIZED_TAG;
    private static final int A_TAG;
    private static final int BODY_TAG;
    private static final boolean DEBUG = false;
    private static final BitSet TRANSPARENT;
    private static final byte ALL_SCOPES;
    private static final byte[] SCOPES_BY_ELEMENT;
    private static final byte[] SCOPE_FOR_END_TAG;

    public TagBalancingHtmlStreamEventReceiver(HtmlStreamEventReceiver underlying) {
        this.underlying = underlying;
    }

    public void setNestingLimit(int limit) {
        if (this.openElements.size() > limit) {
            throw new IllegalStateException();
        }
        this.nestingLimit = limit;
    }

    @Override
    public void openDocument() {
        this.underlying.openDocument();
    }

    @Override
    public void closeDocument() {
        int i2 = Math.min(this.nestingLimit, this.openElements.size());
        while (--i2 >= 0) {
            int elIndex = this.openElements.get(i2);
            String elname = METADATA.canonNameForIndex(elIndex);
            this.underlying.closeTag(elname);
        }
        this.openElements.clear();
        this.toResumeInReverse.clear();
        this.underlying.closeDocument();
    }

    @Override
    public void openTag(String elementName, List<String> attrs) {
        String canonElementName = HtmlLexer.canonicalName(elementName);
        int elIndex = METADATA.indexForName(canonElementName);
        if (elIndex == UNRECOGNIZED_TAG) {
            if (this.openElements.size() < this.nestingLimit) {
                this.underlying.openTag(elementName, attrs);
            }
            return;
        }
        this.prepareForContent(elIndex);
        if (this.openElements.size() < this.nestingLimit) {
            this.underlying.openTag(METADATA.canonNameForIndex(elIndex), attrs);
        }
        if (!HtmlTextEscapingMode.isVoidElement(canonElementName)) {
            this.openElements.add(elIndex);
        }
    }

    private void prepareForContent(int elIndex) {
        int nOpen = this.openElements.size();
        int top = nOpen != 0 ? this.openElements.get(nOpen - 1) : BODY_TAG;
        int[] impliedElIndices = METADATA.impliedElements(top, elIndex);
        if (impliedElIndices.length != 0) {
            int impliedElIndex;
            int i2;
            ArrayList attrs = Lists.newArrayList();
            int startPos = 0;
            int n = impliedElIndices.length;
            for (i2 = 0; i2 < n; ++i2) {
                impliedElIndex = impliedElIndices[i2];
                if (impliedElIndex != top) continue;
                startPos = i2 + 1;
                break;
            }
            n = impliedElIndices.length;
            for (i2 = startPos; i2 < n; ++i2) {
                impliedElIndex = impliedElIndices[i2];
                String impliedElName = METADATA.canonNameForIndex(impliedElIndex);
                attrs.clear();
                this.underlying.openTag(impliedElName, attrs);
                this.openElements.add(impliedElIndex);
                top = impliedElIndex;
                ++nOpen;
            }
        }
        if (nOpen != 0) {
            top = this.openElements.get(nOpen - 1);
            while (true) {
                boolean canContain;
                boolean bl = canContain = this.canContain(elIndex, top, nOpen - 1) && (elIndex != A_TAG || this.openElements.lastIndexOf(A_TAG) < 0);
                if (canContain) break;
                if (this.openElements.size() < this.nestingLimit) {
                    this.underlying.closeTag(METADATA.canonNameForIndex(top));
                }
                this.openElements.remove(--nOpen);
                if (METADATA.resumable(top) && top != elIndex) {
                    this.toResumeInReverse.add(top);
                }
                if (nOpen == 0) break;
                top = this.openElements.get(nOpen - 1);
            }
        }
        while (!this.toResumeInReverse.isEmpty()) {
            int toResume = this.toResumeInReverse.getLast();
            nOpen = this.openElements.size();
            if (nOpen != 0 && !this.canContain(toResume, this.openElements.get(nOpen - 1), nOpen) || !this.canContain(elIndex, toResume, nOpen)) break;
            this.toResumeInReverse.removeLast();
            if (this.openElements.size() < this.nestingLimit) {
                this.underlying.openTag(METADATA.canonNameForIndex(toResume), Lists.newArrayList());
            }
            this.openElements.add(toResume);
        }
    }

    private boolean canContain(int child, int container, int containerIndexOnStack) {
        Preconditions.checkArgument((containerIndexOnStack >= 0 ? 1 : 0) != 0);
        int anc = container;
        int ancIndexOnStack = containerIndexOnStack;
        while (!METADATA.canContain(anc, child)) {
            if (!TRANSPARENT.get(anc)) {
                return false;
            }
            if (ancIndexOnStack == 0) {
                return METADATA.canContain(BODY_TAG, child);
            }
            anc = this.openElements.get(--ancIndexOnStack);
        }
        return true;
    }

    @Override
    public void closeTag(String elementName) {
        byte openElementScope;
        int openElementIndex;
        int i2;
        String canonElementName = HtmlLexer.canonicalName(elementName);
        int elIndex = METADATA.indexForName(canonElementName);
        if (elIndex == UNRECOGNIZED_TAG) {
            if (this.openElements.size() < this.nestingLimit) {
                this.underlying.closeTag(elementName);
            }
            return;
        }
        byte blockingScopes = SCOPE_FOR_END_TAG[elIndex];
        int index = -1;
        if (TagBalancingHtmlStreamEventReceiver.isHeaderElementName(canonElementName)) {
            i2 = this.openElements.size();
            while (--i2 >= 0) {
                openElementIndex = this.openElements.get(i2);
                if (TagBalancingHtmlStreamEventReceiver.isHeaderElement(openElementIndex)) {
                    elIndex = openElementIndex;
                    index = i2;
                    canonElementName = METADATA.canonNameForIndex(openElementIndex);
                } else {
                    openElementScope = SCOPES_BY_ELEMENT[openElementIndex];
                    if ((openElementScope & blockingScopes) == 0) continue;
                }
                break;
            }
        } else {
            i2 = this.openElements.size();
            while (--i2 >= 0) {
                openElementIndex = this.openElements.get(i2);
                if (openElementIndex == elIndex) {
                    index = i2;
                } else {
                    openElementScope = SCOPES_BY_ELEMENT[openElementIndex];
                    if ((openElementScope & blockingScopes) == 0) continue;
                }
                break;
            }
        }
        if (index < 0) {
            return;
        }
        int last = this.openElements.size();
        while (--last > index) {
            int unclosed = this.openElements.remove(last);
            if (last + 1 < this.nestingLimit) {
                this.underlying.closeTag(METADATA.canonNameForIndex(unclosed));
            }
            if (!METADATA.resumable(unclosed)) continue;
            this.toResumeInReverse.add(unclosed);
        }
        if (this.openElements.size() < this.nestingLimit) {
            this.underlying.closeTag(METADATA.canonNameForIndex(elIndex));
        }
        this.openElements.remove(index);
    }

    public static boolean isInterElementWhitespace(String text) {
        int n = text.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if (Strings.isHtmlSpace(text.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void text(String text) {
        boolean isInterElementWhitespace = TagBalancingHtmlStreamEventReceiver.isInterElementWhitespace(text);
        if (isInterElementWhitespace) {
            int top;
            int nOpenElements = this.openElements.size();
            if (!(nOpenElements == 0 || METADATA.canContainText(top = this.openElements.get(nOpenElements - 1)) && METADATA.impliedElements(top, A_TAG).length == 0)) {
                return;
            }
        } else {
            this.prepareForContent(-1);
        }
        if (this.openElements.size() < this.nestingLimit) {
            this.underlying.text(text);
        }
    }

    private static boolean isHeaderElement(int elIndex) {
        String canonElementName = METADATA.canonNameForIndex(elIndex);
        return TagBalancingHtmlStreamEventReceiver.isHeaderElementName(canonElementName);
    }

    private static boolean isHeaderElementName(String canonElementName) {
        return canonElementName.length() == 2 && (canonElementName.charAt(0) | 0x20) == 104 && canonElementName.charAt(1) <= '9';
    }

    private void dumpState(String msg) {
        int idx;
        int i2;
        System.err.println(msg);
        System.err.println("\tstack");
        int n = this.openElements.size();
        for (i2 = 0; i2 < n; ++i2) {
            idx = this.openElements.get(i2);
            System.err.println("\t\t" + METADATA.canonNameForIndex(idx));
        }
        System.err.println("\tresumable");
        n = this.toResumeInReverse.size();
        for (i2 = 0; i2 < n; ++i2) {
            idx = this.toResumeInReverse.get(i2);
            System.err.println("\t\t" + METADATA.canonNameForIndex(idx));
        }
    }

    static {
        String[] tableScopeElements;
        int tn2;
        String[] inScopeElements;
        METADATA = HtmlElementTables.get();
        UNRECOGNIZED_TAG = METADATA.indexForName("xcustom");
        A_TAG = METADATA.indexForName("a");
        BODY_TAG = METADATA.indexForName("body");
        TRANSPARENT = new BitSet();
        for (String transparentElement : new String[]{"a", "audio", "canvas", "del", "ins", "map", "object", "video"}) {
            TRANSPARENT.set(METADATA.indexForName(transparentElement));
        }
        boolean IN = true;
        int BUTTON = 2;
        int LIST_ITEM = 4;
        int TABLE = 8;
        int SELECT = 16;
        ALL_SCOPES = (byte)31;
        SCOPES_BY_ELEMENT = new byte[METADATA.nElementTypes()];
        for (String tn2 : inScopeElements = new String[]{"applet", "caption", "html", "table", "td", "th", "marquee", "object", "template"}) {
            int n = METADATA.indexForName(tn2);
            SCOPES_BY_ELEMENT[n] = (byte)(SCOPES_BY_ELEMENT[n] | 1);
        }
        String[] listItemScopeExtras = new String[]{"dir", "ol", "ul"};
        String[][] stringArrayArray = new String[][]{listItemScopeExtras, inScopeElements};
        int n = stringArrayArray.length;
        for (tn2 = 0; tn2 < n; ++tn2) {
            String[] tns;
            for (String tn3 : tns = stringArrayArray[tn2]) {
                int n2 = METADATA.indexForName(tn3);
                SCOPES_BY_ELEMENT[n2] = (byte)(SCOPES_BY_ELEMENT[n2] | 4);
            }
        }
        String[] buttonScopeExtras = new String[]{"button"};
        String[][] stringArrayArray2 = new String[][]{buttonScopeExtras, inScopeElements};
        tn2 = stringArrayArray2.length;
        for (int tns = 0; tns < tn2; ++tns) {
            String[] tns2;
            for (String tn4 : tns2 = stringArrayArray2[tns]) {
                int n3 = METADATA.indexForName(tn4);
                SCOPES_BY_ELEMENT[n3] = (byte)(SCOPES_BY_ELEMENT[n3] | 2);
            }
        }
        for (String tn5 : tableScopeElements = new String[]{"html", "table", "template"}) {
            int n4 = METADATA.indexForName(tn5);
            SCOPES_BY_ELEMENT[n4] = (byte)(SCOPES_BY_ELEMENT[n4] | 8);
        }
        String[] selectScopeExceptions = new String[]{"optgroup", "option"};
        int i2 = 0;
        int n5 = SCOPES_BY_ELEMENT.length;
        while (i2 < n5) {
            int n6 = i2++;
            SCOPES_BY_ELEMENT[n6] = (byte)(SCOPES_BY_ELEMENT[n6] | 0x10);
        }
        for (String tn6 : selectScopeExceptions) {
            int n7 = METADATA.indexForName(tn6);
            SCOPES_BY_ELEMENT[n7] = (byte)(SCOPES_BY_ELEMENT[n7] & 0xFFFFFFEF);
        }
        byte by = ALL_SCOPES;
        TagBalancingHtmlStreamEventReceiver.SCOPES_BY_ELEMENT[TagBalancingHtmlStreamEventReceiver.METADATA.indexForName((String)"noscript")] = by;
        TagBalancingHtmlStreamEventReceiver.SCOPES_BY_ELEMENT[TagBalancingHtmlStreamEventReceiver.METADATA.indexForName((String)"noframes")] = by;
        TagBalancingHtmlStreamEventReceiver.SCOPES_BY_ELEMENT[TagBalancingHtmlStreamEventReceiver.METADATA.indexForName((String)"noembed")] = by;
        SCOPE_FOR_END_TAG = new byte[METADATA.nElementTypes()];
        for (i = 0; i < SCOPE_FOR_END_TAG.length; ++i) {
            TagBalancingHtmlStreamEventReceiver.SCOPE_FOR_END_TAG[i] = 1;
        }
        TagBalancingHtmlStreamEventReceiver.SCOPE_FOR_END_TAG[TagBalancingHtmlStreamEventReceiver.METADATA.indexForName((String)"th")] = 8;
        TagBalancingHtmlStreamEventReceiver.SCOPE_FOR_END_TAG[TagBalancingHtmlStreamEventReceiver.METADATA.indexForName((String)"td")] = 8;
        TagBalancingHtmlStreamEventReceiver.SCOPE_FOR_END_TAG[TagBalancingHtmlStreamEventReceiver.METADATA.indexForName((String)"tr")] = 8;
        TagBalancingHtmlStreamEventReceiver.SCOPE_FOR_END_TAG[TagBalancingHtmlStreamEventReceiver.METADATA.indexForName((String)"thead")] = 8;
        TagBalancingHtmlStreamEventReceiver.SCOPE_FOR_END_TAG[TagBalancingHtmlStreamEventReceiver.METADATA.indexForName((String)"tfoot")] = 8;
        TagBalancingHtmlStreamEventReceiver.SCOPE_FOR_END_TAG[TagBalancingHtmlStreamEventReceiver.METADATA.indexForName((String)"tbody")] = 8;
        TagBalancingHtmlStreamEventReceiver.SCOPE_FOR_END_TAG[TagBalancingHtmlStreamEventReceiver.METADATA.indexForName((String)"table")] = 8;
        TagBalancingHtmlStreamEventReceiver.SCOPE_FOR_END_TAG[TagBalancingHtmlStreamEventReceiver.METADATA.indexForName((String)"colgroup")] = 8;
        TagBalancingHtmlStreamEventReceiver.SCOPE_FOR_END_TAG[TagBalancingHtmlStreamEventReceiver.METADATA.indexForName((String)"col")] = 8;
        TagBalancingHtmlStreamEventReceiver.SCOPE_FOR_END_TAG[TagBalancingHtmlStreamEventReceiver.METADATA.indexForName((String)"caption")] = 8;
        TagBalancingHtmlStreamEventReceiver.SCOPE_FOR_END_TAG[TagBalancingHtmlStreamEventReceiver.METADATA.indexForName((String)"select")] = 16;
        TagBalancingHtmlStreamEventReceiver.SCOPE_FOR_END_TAG[TagBalancingHtmlStreamEventReceiver.METADATA.indexForName((String)"p")] = 2;
        TagBalancingHtmlStreamEventReceiver.SCOPE_FOR_END_TAG[TagBalancingHtmlStreamEventReceiver.METADATA.indexForName((String)"li")] = 4;
    }
}

