/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.VisitorCallback;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrAccessibilityChecker;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class InaccessibleElementVisitor
extends GroovyRecursiveElementVisitor {
    private final GrAccessibilityChecker myReferenceChecker;
    private final VisitorCallback myCallback;
    private int myTriggerCounter = 0;

    public InaccessibleElementVisitor(GroovyFileBase file, Project project, VisitorCallback callback) {
        this.myCallback = callback;
        this.myReferenceChecker = new GrAccessibilityChecker(file, project);
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
        HighlightInfo info;
        if (referenceExpression == null) {
            InaccessibleElementVisitor.$$$reportNull$$$0(0);
        }
        int oldValue = this.myTriggerCounter;
        super.visitReferenceExpression(referenceExpression);
        if (oldValue == this.myTriggerCounter && (info = this.myReferenceChecker.checkReferenceExpression(referenceExpression)) != null) {
            this.myCallback.trigger(referenceExpression, info);
            ++this.myTriggerCounter;
        }
    }

    @Override
    public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
        HighlightInfo info;
        if (refElement == null) {
            InaccessibleElementVisitor.$$$reportNull$$$0(1);
        }
        int oldValue = this.myTriggerCounter;
        super.visitCodeReferenceElement(refElement);
        if (oldValue == this.myTriggerCounter && (info = this.myReferenceChecker.checkCodeReferenceElement(refElement)) != null) {
            this.myCallback.trigger(refElement, info);
            ++this.myTriggerCounter;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/InaccessibleElementVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCodeReferenceElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

