/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicMethodDialog;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class DynamicMethodFix
implements IntentionAction,
LowPriorityAction {
    private final GrReferenceExpression myReferenceExpression;
    private final String mySignature;

    public DynamicMethodFix(GrReferenceExpression referenceExpression, PsiType[] argumentTypes) {
        this.myReferenceExpression = referenceExpression;
        this.mySignature = this.calcSignature(argumentTypes);
    }

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("add.dynamic.method.0", this.mySignature);
        if (string == null) {
            DynamicMethodFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    private String calcSignature(PsiType[] argTypes) {
        StringBuilder builder = new StringBuilder().append(this.myReferenceExpression.getReferenceName());
        builder.append("(");
        for (int i = 0; i < argTypes.length; ++i) {
            PsiType type2 = argTypes[i];
            if (i > 0) {
                builder.append(", ");
            }
            if (type2 == null) {
                builder.append("Object");
                continue;
            }
            builder.append(type2.getPresentableText());
        }
        builder.append(")");
        return builder.toString();
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("add.dynamic.element", new Object[0]);
        if (string == null) {
            DynamicMethodFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            DynamicMethodFix.$$$reportNull$$$0(2);
        }
        return this.myReferenceExpression.isValid() && !PsiUtil.isInStaticCompilationContext(this.myReferenceExpression);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            DynamicMethodFix.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            DynamicManager.getInstance(project).addMethod(QuickfixUtil.createSettings(this.myReferenceExpression));
            return;
        }
        DynamicMethodDialog dialog = new DynamicMethodDialog(this.myReferenceExpression);
        dialog.show();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public GrReferenceExpression getReferenceExpression() {
        return this.myReferenceExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicMethodFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicMethodFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

