/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="DslActivationStatus", storages={@Storage(value="dslActivationStatus.xml", roamingType=RoamingType.DISABLED)})
public final class DslActivationStatus
implements PersistentStateComponent<State> {
    private final Map<VirtualFile, Entry> myStatus = new HashMap<VirtualFile, Entry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Entry getGdslFileInfo(@NotNull VirtualFile file) {
        if (file == null) {
            DslActivationStatus.$$$reportNull$$$0(0);
        }
        Map<VirtualFile, Entry> map2 = this.myStatus;
        synchronized (map2) {
            return this.myStatus.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Entry getGdslFileInfoOrCreate(@NotNull VirtualFile file) {
        Entry entry;
        if (file == null) {
            DslActivationStatus.$$$reportNull$$$0(1);
        }
        Map<VirtualFile, Entry> map2 = this.myStatus;
        synchronized (map2) {
            entry = this.myStatus.get(file);
            if (entry == null) {
                entry = new Entry(file.getUrl(), Status.ACTIVE, null);
                this.myStatus.put(file, entry);
            }
        }
        Entry entry2 = entry;
        if (entry2 == null) {
            DslActivationStatus.$$$reportNull$$$0(2);
        }
        return entry2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public State getState() {
        Map<VirtualFile, Entry> map2 = this.myStatus;
        synchronized (map2) {
            this.myStatus.entrySet().removeIf(entry -> ((Entry)entry.getValue()).status == Status.ACTIVE && ((Entry)entry.getValue()).error == null);
            if (this.myStatus.isEmpty()) {
                return new State(Collections.emptyList());
            }
            Object[] entries = this.myStatus.values().toArray(new Entry[0]);
            Arrays.sort(entries);
            return new State(Arrays.asList(entries));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull State state) {
        if (state == null) {
            DslActivationStatus.$$$reportNull$$$0(3);
        }
        Map<VirtualFile, Entry> map2 = this.myStatus;
        synchronized (map2) {
            this.myStatus.clear();
            if (ContainerUtil.isEmpty(state.entries)) {
                return;
            }
            VirtualFileManager fileManager = VirtualFileManager.getInstance();
            for (Entry entry : state.entries) {
                VirtualFile file;
                if (entry.url == null || entry.status == null || (file = fileManager.findFileByUrl(entry.url)) == null) continue;
                this.myStatus.put(file, entry);
            }
        }
    }

    public static DslActivationStatus getInstance() {
        return (DslActivationStatus)ApplicationManager.getApplication().getService(DslActivationStatus.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/dsl/DslActivationStatus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/dsl/DslActivationStatus";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGdslFileInfoOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGdslFileInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getGdslFileInfoOrCreate";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        @XCollection
        public Collection<Entry> entries;

        public State(@NotNull Collection<Entry> entries) {
            if (entries == null) {
                State.$$$reportNull$$$0(0);
            }
            this.entries = entries;
        }

        public State() {
            this((Collection<Entry>)new SmartList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "org/jetbrains/plugins/groovy/dsl/DslActivationStatus$State", "<init>"));
        }
    }

    public static class Entry
    implements Comparable<Entry> {
        @Attribute
        public String url;
        @Attribute
        public Status status;
        @Attribute
        @NlsSafe
        public String error;

        public Entry() {
        }

        public Entry(String url, Status status, String error) {
            this.url = url;
            this.status = status;
            this.error = error;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.url != null ? !this.url.equals(entry.url) : entry.url != null) {
                return false;
            }
            if (this.status != entry.status) {
                return false;
            }
            return !(this.error != null ? !this.error.equals(entry.error) : entry.error != null);
        }

        public int hashCode() {
            int result2 = this.url != null ? this.url.hashCode() : 0;
            result2 = 31 * result2 + (this.status != null ? this.status.hashCode() : 0);
            result2 = 31 * result2 + (this.error != null ? this.error.hashCode() : 0);
            return result2;
        }

        @Override
        public int compareTo(Entry o) {
            return this.equals(o) ? 0 : this.url.compareTo(o.url);
        }
    }

    public static enum Status {
        ACTIVE,
        MODIFIED,
        ERROR;

    }
}

