/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.holders;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dsl.ClosureDescriptor;
import org.jetbrains.plugins.groovy.dsl.Descriptor;
import org.jetbrains.plugins.groovy.dsl.GdslNamedParameter;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.MethodDescriptor;
import org.jetbrains.plugins.groovy.dsl.NamedParameterDescriptor;
import org.jetbrains.plugins.groovy.dsl.VariableDescriptor;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.dsl.toplevel.ClassContextFilter;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.extensions.impl.NamedArgumentDescriptorImpl;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class NonCodeMembersHolder
implements CustomMembersHolder {
    private static final Logger LOG = Logger.getInstance(NonCodeMembersHolder.class);
    public static final Key<@Nls String> DOCUMENTATION = Key.create((String)"GdslDocumentation");
    public static final Key<@NlsSafe String> DOCUMENTATION_URL = Key.create((String)"GdslDocumentationUrl");
    private final List<PsiVariable> myVariables;
    private final List<PsiMethod> myMethods;
    private final List<ClosureDescriptor> myClosureDescriptors;

    public static NonCodeMembersHolder generateMembers(List<Descriptor> methods, PsiFile file) {
        Map map2 = (Map)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            ConcurrentMap map1 = ContainerUtil.createConcurrentSoftMap();
            return CachedValueProvider.Result.create((Object)map1, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        NonCodeMembersHolder result2 = (NonCodeMembersHolder)map2.get(methods);
        if (result2 == null) {
            result2 = new NonCodeMembersHolder(methods, file);
            map2.put(methods, result2);
        }
        return result2;
    }

    public NonCodeMembersHolder() {
        this.myVariables = new ArrayList<PsiVariable>();
        this.myMethods = new ArrayList<PsiMethod>();
        this.myClosureDescriptors = new ArrayList<ClosureDescriptor>();
    }

    private NonCodeMembersHolder(@NotNull List<Descriptor> data, @NotNull PsiFile file) {
        if (data == null) {
            NonCodeMembersHolder.$$$reportNull$$$0(0);
        }
        if (file == null) {
            NonCodeMembersHolder.$$$reportNull$$$0(1);
        }
        this.myVariables = new ArrayList<PsiVariable>();
        this.myMethods = new ArrayList<PsiMethod>();
        this.myClosureDescriptors = new ArrayList<ClosureDescriptor>();
        PsiManager manager = file.getManager();
        for (Descriptor descriptor : data) {
            if (descriptor instanceof ClosureDescriptor) {
                this.myClosureDescriptors.add((ClosureDescriptor)descriptor);
                continue;
            }
            if (descriptor instanceof VariableDescriptor) {
                this.myVariables.add(NonCodeMembersHolder.createVariable((VariableDescriptor)descriptor, (PsiElement)file, manager));
                continue;
            }
            this.myMethods.add(NonCodeMembersHolder.createMethod((MethodDescriptor)descriptor, (PsiElement)file, manager));
        }
    }

    public void addDeclaration(@NotNull PsiElement element) {
        if (element == null) {
            NonCodeMembersHolder.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiMethod) {
            this.myMethods.add((PsiMethod)element);
        } else if (element instanceof PsiVariable) {
            this.myVariables.add((PsiVariable)element);
        } else {
            LOG.error("Unknown declaration: " + element);
        }
    }

    private static PsiVariable createVariable(@NotNull VariableDescriptor descriptor, PsiElement place, PsiManager manager) {
        if (descriptor == null) {
            NonCodeMembersHolder.$$$reportNull$$$0(3);
        }
        String name = descriptor.getName();
        String type2 = descriptor.getType();
        return new GrLightVariable(manager, name, type2, Collections.emptyList(), (PsiElement)place.getContainingFile());
    }

    private static GrLightMethodBuilder createMethod(@NonNls MethodDescriptor descriptor, PsiElement place, PsiManager manager) {
        PsiClass foundClass;
        String qName;
        String docUrl;
        PsiElement bindsTo;
        GrLightMethodBuilder method = new GrLightMethodBuilder(manager, descriptor.getName()).addModifier("public");
        if (descriptor.isConstructor()) {
            method.setConstructor(true);
        } else {
            method.setReturnType(NonCodeMembersHolder.convertToPsiType(descriptor.getReturnType(), place));
        }
        List<NamedParameterDescriptor> descriptorNamedParams = descriptor.getNamedParameters();
        if (!descriptorNamedParams.isEmpty()) {
            HashMap namedParams = new HashMap();
            for (NamedParameterDescriptor namedParameterDescriptor : descriptorNamedParams) {
                final String typeString = namedParameterDescriptor.getType();
                GdslNamedParameter parameter = new GdslNamedParameter(namedParameterDescriptor.getName(), namedParameterDescriptor.getDoc(), place, typeString);
                namedParams.put(namedParameterDescriptor.getName(), new NamedArgumentDescriptorImpl(NamedArgumentDescriptor.Priority.ALWAYS_ON_TOP, (PsiElement)parameter){

                    @Override
                    public boolean checkType(@NotNull PsiType type2, @NotNull GroovyPsiElement context) {
                        if (type2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (context == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return ClassContextFilter.isSubtype(type2, context.getContainingFile(), typeString);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "type";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "context";
                                break;
                            }
                        }
                        objectArray[1] = "org/jetbrains/plugins/groovy/dsl/holders/NonCodeMembersHolder$1";
                        objectArray[2] = "checkType";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            method.addParameter("args", NonCodeMembersHolder.convertToPsiType("java.util.Map", place));
            method.setNamedParameters(namedParams);
        }
        for (VariableDescriptor paramDescriptor : descriptor.getParameters()) {
            method.addParameter(paramDescriptor.getName(), NonCodeMembersHolder.convertToPsiType(paramDescriptor.getType(), place));
        }
        if (descriptor.isStatic()) {
            method.addModifier("static");
        }
        if ((bindsTo = descriptor.getBindsTo()) != null) {
            method.setNavigationElement(bindsTo);
        }
        List<String> toThrow = descriptor.getThrows();
        for (String o : toThrow) {
            PsiType psiType = NonCodeMembersHolder.convertToPsiType(o, place);
            if (!(psiType instanceof PsiClassType)) continue;
            method.addException((PsiClassType)psiType);
        }
        String string = descriptor.getDoc();
        if (string != null) {
            method.putUserData(DOCUMENTATION, string);
        }
        if ((docUrl = descriptor.getDocUrl()) != null) {
            method.putUserData(DOCUMENTATION_URL, docUrl);
        }
        if ((qName = descriptor.getContainingClass()) != null && (foundClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(qName, place.getResolveScope())) != null) {
            method.setContainingClass(foundClass);
        }
        return method;
    }

    private static PsiType convertToPsiType(String type2, PsiElement place) {
        return JavaPsiFacade.getElementFactory((Project)place.getProject()).createTypeFromText(type2, place);
    }

    @Override
    public boolean processMembers(GroovyClassDescriptor descriptor, PsiScopeProcessor _processor, ResolveState state) {
        String hint = ResolveUtil.getNameHint(_processor);
        ElementClassHint classHint = (ElementClassHint)_processor.getHint(ElementClassHint.KEY);
        if (ResolveUtil.shouldProcessMethods(classHint)) {
            for (PsiMethod psiMethod : this.myMethods) {
                if (!NonCodeMembersHolder.checkName(hint, (PsiNamedElement)psiMethod) || _processor.execute((PsiElement)psiMethod, state)) continue;
                return false;
            }
        }
        if (ResolveUtil.shouldProcessProperties(classHint)) {
            for (PsiVariable psiVariable : this.myVariables) {
                if (!NonCodeMembersHolder.checkName(hint, (PsiNamedElement)psiVariable) || _processor.execute((PsiElement)psiVariable, state)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkName(String hint, PsiNamedElement declaration) {
        if (hint != null && !NonCodeMembersHolder.isConstructor((PsiElement)declaration)) {
            return hint.equals(declaration.getName());
        }
        return true;
    }

    private static boolean isConstructor(PsiElement declaration) {
        return declaration instanceof PsiMethod && ((PsiMethod)declaration).isConstructor();
    }

    @Override
    public void consumeClosureDescriptors(GroovyClassDescriptor descriptor, Consumer<? super ClosureDescriptor> consumer) {
        this.myClosureDescriptors.forEach(consumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/dsl/holders/NonCodeMembersHolder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createVariable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

