/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.GrBlockLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrInExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSwitchExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.readWrite.ReadBeforeWriteInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.readWrite.ReadBeforeWriteSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.readWrite.ReadBeforeWriteState;

public final class ControlFlowBuilderUtil {
    private ControlFlowBuilderUtil() {
    }

    @NotNull
    private static @NotNull Pair<@Nullable ReadBeforeWriteState, @NotNull Object2IntMap<VariableDescriptor>> getLastReadBeforeWriteState(Instruction[] flow, boolean onlyFirstRead) {
        Object2IntMap<VariableDescriptor> index = ControlFlowBuilderUtil.buildVariablesIndex(flow);
        DFAEngine<ReadBeforeWriteState> engine = new DFAEngine<ReadBeforeWriteState>(flow, new ReadBeforeWriteInstance(index, onlyFirstRead), ReadBeforeWriteSemilattice.INSTANCE);
        List<ReadBeforeWriteState> dfaResult = engine.performDFAWithTimeout();
        ReadBeforeWriteState lastState = dfaResult == null ? null : dfaResult.get(dfaResult.size() - 1);
        Pair pair = Pair.create(lastState, index);
        if (pair == null) {
            ControlFlowBuilderUtil.$$$reportNull$$$0(0);
        }
        return pair;
    }

    public static ReadWriteVariableInstruction[] getReadsWithoutPriorWrites(Instruction[] flow, boolean onlyFirstRead) {
        ReadBeforeWriteState lastState = (ReadBeforeWriteState)ControlFlowBuilderUtil.getLastReadBeforeWriteState((Instruction[])flow, (boolean)onlyFirstRead).first;
        if (lastState == null) {
            return null;
        }
        BitSet reads = lastState.getReads();
        ArrayList<ReadWriteVariableInstruction> result2 = new ArrayList<ReadWriteVariableInstruction>();
        int i = reads.nextSetBit(0);
        while (i >= 0 && i != Integer.MAX_VALUE) {
            result2.add((ReadWriteVariableInstruction)flow[i]);
            i = reads.nextSetBit(i + 1);
        }
        return result2.toArray(ReadWriteVariableInstruction.EMPTY_ARRAY);
    }

    @NotNull
    public static @NotNull Set<@NotNull VariableDescriptor> getDescriptorsWithoutWrites(Instruction @NotNull [] flow) {
        if (flow == null) {
            ControlFlowBuilderUtil.$$$reportNull$$$0(1);
        }
        Pair<ReadBeforeWriteState, Object2IntMap<VariableDescriptor>> dfaResult = ControlFlowBuilderUtil.getLastReadBeforeWriteState(flow, true);
        ReadBeforeWriteState lastState = (ReadBeforeWriteState)dfaResult.first;
        if (lastState == null) {
            Set<VariableDescriptor> set = Collections.emptySet();
            if (set == null) {
                ControlFlowBuilderUtil.$$$reportNull$$$0(2);
            }
            return set;
        }
        BitSet reads = lastState.getReads();
        BitSet writes = lastState.getWrites();
        HashSet<VariableDescriptor> result2 = new HashSet<VariableDescriptor>();
        int i = reads.nextSetBit(0);
        while (i >= 0 && i != Integer.MAX_VALUE) {
            result2.add(((ReadWriteVariableInstruction)flow[i]).getDescriptor());
            i = reads.nextSetBit(i + 1);
        }
        Object2IntMap index = (Object2IntMap)dfaResult.second;
        for (Object2IntMap.Entry entry : index.object2IntEntrySet()) {
            if (writes.get(entry.getIntValue())) continue;
            result2.add((VariableDescriptor)entry.getKey());
        }
        HashSet<VariableDescriptor> hashSet = result2;
        if (hashSet == null) {
            ControlFlowBuilderUtil.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static Object2IntMap<VariableDescriptor> buildVariablesIndex(Instruction[] flow) {
        Object2IntOpenHashMap variablesIndex = new Object2IntOpenHashMap();
        variablesIndex.defaultReturnValue(-1);
        int idx = 0;
        for (Instruction instruction : flow) {
            VariableDescriptor descriptor;
            if (!(instruction instanceof ReadWriteVariableInstruction) || variablesIndex.containsKey((Object)(descriptor = ((ReadWriteVariableInstruction)instruction).getDescriptor()))) continue;
            variablesIndex.put((Object)descriptor, idx++);
        }
        return variablesIndex;
    }

    public static boolean isInstanceOfBinary(GrBinaryExpression binary) {
        if (binary instanceof GrInExpression) {
            GrExpression left = binary.getLeftOperand();
            GrExpression right = binary.getRightOperand();
            if (left instanceof GrReferenceExpression && ((GrReferenceExpression)left).getQualifier() == null && right instanceof GrReferenceExpression && ControlFlowBuilderUtil.findClassByText((GrReferenceExpression)right)) {
                return true;
            }
        }
        return false;
    }

    private static boolean findClassByText(GrReferenceExpression ref) {
        String text = ref.getText();
        int i = text.indexOf(60);
        String className = i == -1 ? text : text.substring(0, i);
        PsiClass[] names = PsiShortNamesCache.getInstance((Project)ref.getProject()).getClassesByName(className, ref.getResolveScope());
        if (names.length > 0) {
            return true;
        }
        PsiFile file = ref.getContainingFile();
        if (file instanceof GroovyFile) {
            GrImportStatement[] imports2;
            for (GrImportStatement anImport : imports2 = ((GroovyFile)file).getImportStatements()) {
                if (!className.equals(anImport.getImportedName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCertainlyReturnStatement(GrStatement st) {
        PsiElement parent2 = st.getParent();
        if (parent2 instanceof GrOpenBlock) {
            if (st != ArrayUtil.getLastElement((Object[])((GrOpenBlock)parent2).getStatements())) {
                return false;
            }
            PsiElement pparent = parent2.getParent();
            if (pparent instanceof GrMethod) {
                return true;
            }
            if (pparent instanceof GrBlockStatement || pparent instanceof GrCatchClause || pparent instanceof GrLabeledStatement) {
                pparent = pparent.getParent();
            }
            if (pparent instanceof GrControlStatement || pparent instanceof GrTryCatchStatement) {
                return ControlFlowBuilderUtil.isCertainlyReturnStatement((GrStatement)pparent);
            }
        } else {
            if (parent2 instanceof GrClosableBlock || parent2 instanceof GrBlockLambdaBody) {
                return st == ArrayUtil.getLastElement((Object[])((GrCodeBlock)parent2).getStatements());
            }
            if (parent2 instanceof GroovyFileBase) {
                return st == ArrayUtil.getLastElement((Object[])((GroovyFileBase)parent2).getStatements());
            }
            if (parent2 instanceof GrForStatement || parent2 instanceof GrIfStatement && st != ((GrIfStatement)parent2).getCondition() || parent2 instanceof GrSynchronizedStatement && st != ((GrSynchronizedStatement)parent2).getMonitor() || parent2 instanceof GrWhileStatement && st != ((GrWhileStatement)parent2).getCondition() || parent2 instanceof GrConditionalExpression && st != ((GrConditionalExpression)parent2).getCondition() || parent2 instanceof GrElvisExpression) {
                return ControlFlowBuilderUtil.isCertainlyReturnStatement((GrStatement)parent2);
            }
            if (parent2 instanceof GrCaseSection) {
                GrStatement switchAsStatement;
                Object[] statements2 = ((GrCaseSection)parent2).getStatements();
                GrStatement last = (GrStatement)ArrayUtil.getLastElement((Object[])statements2);
                GrSwitchElement switchElement = (GrSwitchElement)parent2.getParent();
                GrStatement grStatement = switchAsStatement = switchElement instanceof GrSwitchExpression ? (GrSwitchExpression)switchElement : (GrStatement)((Object)switchElement);
                if (last instanceof GrBreakStatement && statements2.length > 1 && statements2[statements2.length - 2] == st) {
                    return ControlFlowBuilderUtil.isCertainlyReturnStatement(switchAsStatement);
                }
                if (st == last && (st instanceof GrBreakStatement || ControlFlowBuilderUtil.isLastStatementInCaseSection((GrCaseSection)parent2, switchElement))) {
                    return ControlFlowBuilderUtil.isCertainlyReturnStatement(switchAsStatement);
                }
            }
        }
        return false;
    }

    private static boolean isLastStatementInCaseSection(GrCaseSection caseSection, GrSwitchElement switchStatement) {
        Object[] sections = switchStatement.getCaseSections();
        int i = ArrayUtilRt.find((Object[])sections, (Object)caseSection);
        if (i == sections.length - 1) {
            return true;
        }
        for (int j = i + 1; j < sections.length; ++j) {
            Object section = sections[j];
            for (GrStatement statement : section.getStatements()) {
                if (statement instanceof GrBreakStatement) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isCertainlyYieldStatement(GrStatement statement) {
        PsiElement parent2 = statement.getParent();
        if (parent2 instanceof GrOpenBlock || parent2 instanceof GrCaseSection) {
            if (statement != ArrayUtil.getLastElement((Object[])((GrStatementOwner)parent2).getStatements())) {
                return false;
            }
            PsiElement pparent = parent2.getParent();
            if (parent2 instanceof GrCaseSection && pparent instanceof GrSwitchElement) {
                return true;
            }
            if (pparent instanceof GrStatement) {
                return ControlFlowBuilderUtil.isCertainlyYieldStatement((GrStatement)pparent);
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/ControlFlowBuilderUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastReadBeforeWriteState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/ControlFlowBuilderUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorsWithoutWrites";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorsWithoutWrites";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

