/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiListLikeElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.IncorrectOperationException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrAnnotationCollector;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListUtil;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrModifierListStub;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

public final class GrModifierListImpl
extends GrStubElementBase<GrModifierListStub>
implements GrModifierList,
StubBasedPsiElement<GrModifierListStub>,
PsiListLikeElement {
    public static final Object2IntMap<String> NAME_TO_MODIFIER_FLAG_MAP = new Object2IntOpenHashMap();
    public static final Map<String, IElementType> NAME_TO_MODIFIER_ELEMENT_TYPE = new HashMap<String, IElementType>();
    private static final Object2IntMap<String> PRIORITY = new Object2IntOpenHashMap(16);

    public GrModifierListImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrModifierListImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public GrModifierListImpl(GrModifierListStub stub) {
        this(stub, (IStubElementType)GroovyElementTypes.MODIFIER_LIST);
    }

    public GrModifierListImpl(GrModifierListStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrModifierListImpl.$$$reportNull$$$0(1);
        }
        visitor2.visitModifierList(this);
    }

    public String toString() {
        return "Modifiers";
    }

    @Override
    public int getModifierFlags() {
        GrModifierListStub stub = (GrModifierListStub)this.getGreenStub();
        if (stub != null) {
            return stub.getModifiersFlags();
        }
        return (Integer)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            int flags = 0;
            for (PsiElement modifier : this.findChildrenByType(TokenSets.MODIFIERS)) {
                flags |= NAME_TO_MODIFIER_FLAG_MAP.getInt((Object)modifier.getText());
            }
            return CachedValueProvider.Result.create((Object)flags, (Object[])new Object[]{this});
        });
    }

    @Override
    public PsiElement @NotNull [] getModifiers() {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrAnnotation) && !TokenSets.MODIFIERS.contains(cur.getNode().getElementType())) continue;
            result2.add(cur);
        }
        PsiElement[] psiElementArray = result2.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            GrModifierListImpl.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    @Override
    @Nullable
    public PsiElement getModifier(@GrModifier.GrModifierConstant @NotNull @NonNls String name) {
        if (name == null) {
            GrModifierListImpl.$$$reportNull$$$0(3);
        }
        return this.findChildByType(NAME_TO_MODIFIER_ELEMENT_TYPE.get(name));
    }

    @Override
    public boolean hasExplicitVisibilityModifiers() {
        return GrModifierListUtil.hasExplicitVisibilityModifiers(this);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            GrModifierListImpl.$$$reportNull$$$0(4);
        }
        return GrModifierListUtil.hasModifierProperty(this, name);
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        if (name == null) {
            GrModifierListImpl.$$$reportNull$$$0(5);
        }
        return GrModifierListUtil.hasExplicitModifier(this, name);
    }

    @Override
    public void setModifierProperty(@NotNull @NonNls String name, boolean doSet) throws IncorrectOperationException {
        if (name == null) {
            GrModifierListImpl.$$$reportNull$$$0(6);
        }
        if (this.hasModifierProperty(name) == doSet) {
            return;
        }
        if (doSet && ("private".equals(name) || "protected".equals(name) || "public".equals(name) || "packageLocal".equals(name))) {
            this.setModifierPropertyInternal("public", false);
            this.setModifierPropertyInternal("protected", false);
            this.setModifierPropertyInternal("private", false);
        }
        if ("packageLocal".equals(name)) {
            if (this.getModifiers().length == 0) {
                this.setModifierProperty("def", true);
            }
        } else {
            this.setModifierPropertyInternal(name, doSet);
        }
        if (this.isEmptyModifierList() && !PsiUtilKt.modifierListMayBeEmpty(this.getParent())) {
            this.setModifierPropertyInternal("def", true);
        }
    }

    @Override
    public GrAnnotation @NotNull [] getRawAnnotations() {
        GrAnnotation[] grAnnotationArray = (GrAnnotation[])this.getStubOrPsiChildren(GroovyElementTypes.ANNOTATION, GrAnnotation.ARRAY_FACTORY);
        if (grAnnotationArray == null) {
            GrModifierListImpl.$$$reportNull$$$0(7);
        }
        return grAnnotationArray;
    }

    private void setModifierPropertyInternal(String name, boolean doSet) {
        if (doSet) {
            PsiElement nextSibling;
            if (this.isEmptyModifierList() && (nextSibling = this.getNextSibling()) != null && !PsiImplUtil.isWhiteSpaceOrNls(nextSibling)) {
                this.getNode().getTreeParent().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", nextSibling.getNode());
            }
            PsiElement modifier = GroovyPsiElementFactory.getInstance(this.getProject()).createModifierFromText(name);
            PsiElement anchor = this.findAnchor(name);
            this.addAfter(modifier, anchor);
        } else {
            PsiElement nextSibling;
            PsiElement[] modifiers;
            for (PsiElement modifier : modifiers = this.findChildrenByType(TokenSets.MODIFIERS, PsiElement.class)) {
                if (!name.equals(modifier.getText())) continue;
                this.deleteChildRange(modifier, modifier);
                break;
            }
            if (this.isEmptyModifierList() && (nextSibling = this.getNextSibling()) != null && PsiImplUtil.isWhiteSpaceOrNls(nextSibling)) {
                nextSibling.delete();
            }
        }
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        ASTNode node = super.addInternal(first, last, anchor, before);
        PsiElement sibling = this.getNextSibling();
        if (sibling != null && sibling.getText().contains("\n")) {
            sibling.replace(GroovyPsiElementFactory.getInstance(this.getProject()).createWhiteSpace());
        }
        return node;
    }

    private boolean isEmptyModifierList() {
        return this.getTextLength() == 0 || this.getModifiers().length == 0 && this.getRawAnnotations().length == 0;
    }

    @Nullable
    private PsiElement findAnchor(String name) {
        int myPriority = PRIORITY.getInt((Object)name);
        PsiElement anchor = null;
        for (PsiElement modifier : this.getModifiers()) {
            int otherPriority = PRIORITY.getInt((Object)modifier.getText());
            if (otherPriority <= myPriority) {
                anchor = modifier;
                continue;
            }
            if (otherPriority > myPriority && anchor != null) break;
        }
        return anchor;
    }

    public void checkSetModifierProperty(@NotNull @NonNls String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            GrModifierListImpl.$$$reportNull$$$0(8);
        }
    }

    @Override
    public GrAnnotation @NotNull [] getAnnotations() {
        GrAnnotation[] grAnnotationArray = (GrAnnotation[])CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)GrAnnotationCollector.getResolvedAnnotations(this), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}));
        if (grAnnotationArray == null) {
            GrModifierListImpl.$$$reportNull$$$0(9);
        }
        return grAnnotationArray;
    }

    public PsiAnnotation @NotNull [] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            GrModifierListImpl.$$$reportNull$$$0(10);
        }
        return psiAnnotationArray;
    }

    @Nullable
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            GrModifierListImpl.$$$reportNull$$$0(11);
        }
        for (GrAnnotation annotation : this.getAnnotations()) {
            if (!annotation.hasQualifiedName(qualifiedName)) continue;
            return annotation;
        }
        return null;
    }

    @NotNull
    public GrAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        GrAnnotation annotation;
        if (qualifiedName == null) {
            GrModifierListImpl.$$$reportNull$$$0(12);
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(qualifiedName, this.getResolveScope());
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        if (psiClass != null) {
            annotation = (GrAnnotation)this.addAfter(factory.createModifierFromText("@xxx"), null);
            annotation.getClassReference().bindToElement((PsiElement)psiClass);
        } else {
            annotation = (GrAnnotation)this.addAfter(factory.createModifierFromText("@" + qualifiedName), null);
        }
        PsiElement parent2 = this.getParent();
        if (!(parent2 instanceof GrParameter)) {
            ASTNode node = annotation.getNode();
            ASTNode treeNext = node.getTreeNext();
            if (treeNext != null) {
                this.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)"\n", treeNext);
            } else {
                parent2.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)"\n", this.getNode().getTreeNext());
            }
        }
        GrAnnotation grAnnotation = annotation;
        if (grAnnotation == null) {
            GrModifierListImpl.$$$reportNull$$$0(13);
        }
        return grAnnotation;
    }

    @NotNull
    public List<? extends PsiElement> getComponents() {
        List<PsiElement> list = Arrays.asList(this.getModifiers());
        if (list == null) {
            GrModifierListImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    static {
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"public", 1);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"protected", 4);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"private", 2);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"packageLocal", 4096);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"static", 8);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"abstract", 1024);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"final", 16);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"native", 256);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"synchronized", 32);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"strictfp", 2048);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"transient", 128);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"volatile", 64);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"def", 131072);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"default", 262144);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"sealed", 524288);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"non-sealed", 0x100000);
        PRIORITY.put((Object)"public", 0);
        PRIORITY.put((Object)"protected", 0);
        PRIORITY.put((Object)"private", 0);
        PRIORITY.put((Object)"packageLocal", 0);
        PRIORITY.put((Object)"static", 1);
        PRIORITY.put((Object)"abstract", 1);
        PRIORITY.put((Object)"default", 1);
        PRIORITY.put((Object)"final", 2);
        PRIORITY.put((Object)"sealed", 2);
        PRIORITY.put((Object)"non-sealed", 2);
        PRIORITY.put((Object)"native", 3);
        PRIORITY.put((Object)"synchronized", 3);
        PRIORITY.put((Object)"strictfp", 3);
        PRIORITY.put((Object)"transient", 3);
        PRIORITY.put((Object)"volatile", 3);
        PRIORITY.put((Object)"def", 4);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("public", GroovyTokenTypes.kPUBLIC);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("abstract", GroovyTokenTypes.kABSTRACT);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("default", GroovyTokenTypes.kDEFAULT);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("private", GroovyTokenTypes.kPRIVATE);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("protected", GroovyTokenTypes.kPROTECTED);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("synchronized", GroovyTokenTypes.kSYNCHRONIZED);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("strictfp", GroovyTokenTypes.kSTRICTFP);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("static", GroovyTokenTypes.kSTATIC);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("final", GroovyTokenTypes.kFINAL);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("transient", GroovyTokenTypes.kTRANSIENT);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("native", GroovyTokenTypes.kNATIVE);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("def", GroovyTokenTypes.kDEF);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("volatile", GroovyTokenTypes.kVOLATILE);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("sealed", GroovyTokenTypes.kSEALED);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("non-sealed", GroovyTokenTypes.kNON_SEALED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawAnnotations";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addAnnotation";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModifier";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitModifier";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setModifierProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkSetModifierProperty";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

