/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals;

import com.intellij.lang.ASTNode;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrAbstractLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralEscaper;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GrStringImpl
extends GrAbstractLiteral
implements GrString {
    public GrStringImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrStringImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public String toString() {
        return "Compound Gstring";
    }

    @Override
    public PsiType getType() {
        return this.getTypeByFQName(this.findChildByClass(GrStringInjection.class) != null ? "groovy.lang.GString" : "java.lang.String");
    }

    @Override
    public boolean isPlainString() {
        return !this.getText().startsWith("\"\"\"");
    }

    @Override
    public GrStringInjection[] getInjections() {
        return (GrStringInjection[])this.findChildrenByClass(GrStringInjection.class);
    }

    @Override
    public String[] getTextParts() {
        List parts = this.findChildrenByType(GroovyElementTypes.GSTRING_CONTENT);
        String[] result2 = new String[parts.size()];
        int i = 0;
        for (PsiElement part : parts) {
            result2[i++] = part.getText();
        }
        return result2;
    }

    @Override
    public GrStringContent[] getContents() {
        List parts = this.findChildrenByType(GroovyElementTypes.GSTRING_CONTENT);
        return parts.toArray(new GrStringContent[0]);
    }

    @Override
    public GroovyPsiElement[] getAllContentParts() {
        List result2 = this.findChildrenByType(TokenSets.GSTRING_CONTENT_PARTS);
        return result2.toArray(GroovyPsiElement.EMPTY_ARRAY);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrStringImpl.$$$reportNull$$$0(1);
        }
        visitor2.visitGStringExpression(this);
    }

    public Object getValue() {
        StringBuilder chars2;
        if (this.findChildByClass(GrStringInjection.class) != null) {
            return null;
        }
        PsiElement fchild = this.getFirstChild();
        if (fchild == null) {
            return null;
        }
        PsiElement content = fchild.getNextSibling();
        if (content == null || content.getNode().getElementType() != GroovyElementTypes.GSTRING_CONTENT) {
            return null;
        }
        String text = content.getText();
        boolean result2 = GrStringUtil.parseStringCharacters(text, chars2 = new StringBuilder(text.length()), null);
        return result2 ? chars2.toString() : null;
    }

    public boolean isValidHost() {
        return false;
    }

    @Override
    public GrStringImpl updateText(@NotNull String text) {
        if (text == null) {
            GrStringImpl.$$$reportNull$$$0(2);
        }
        return this;
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new GrLiteralEscaper(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrStringImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

