/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.AbstractClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.SignatureHintProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSessionBuilder;

public final class ClosureParamsEnhancer
extends AbstractClosureParameterEnhancer {
    @Override
    @Nullable
    protected PsiType getClosureParameterType(@NotNull GrFunctionalExpression expression, int index) {
        if (expression == null) {
            ClosureParamsEnhancer.$$$reportNull$$$0(0);
        }
        if (!GroovyConfigUtils.getInstance().isVersionAtLeast(expression, "2.3")) {
            return null;
        }
        GrParameter[] parameters2 = expression.getAllParameters();
        if (ClosureParamsEnhancer.containsParametersWithDeclaredType(parameters2)) {
            return null;
        }
        List<PsiType[]> fittingSignatures = ClosureParamsEnhancer.findFittingSignatures(expression);
        if (fittingSignatures.size() == 1) {
            PsiType[] expectedSignature = fittingSignatures.get(0);
            return expectedSignature[index];
        }
        return null;
    }

    @NotNull
    public static List<PsiType[]> findFittingSignatures(@NotNull GrFunctionalExpression expression) {
        GrMethodCall call;
        if (expression == null) {
            ClosureParamsEnhancer.$$$reportNull$$$0(1);
        }
        if ((call = GrClosureSignatureUtil.findCall(expression)) == null) {
            List<PsiType[]> list = Collections.emptyList();
            if (list == null) {
                ClosureParamsEnhancer.$$$reportNull$$$0(2);
            }
            return list;
        }
        GroovyResolveResult variant = call.advancedResolve();
        List<PsiType[]> expectedSignatures = ClosureParamsEnhancer.inferExpectedSignatures(variant, call, expression);
        GrParameter[] parameters2 = expression.getAllParameters();
        List list = ContainerUtil.findAll(expectedSignatures, types -> ((PsiType[])types).length == parameters2.length);
        if (list == null) {
            ClosureParamsEnhancer.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static List<PsiType[]> inferExpectedSignatures(@NotNull GroovyResolveResult variant, @NotNull GrMethodCall call, @NotNull GrFunctionalExpression expression) {
        GroovyMethodCandidate candidate;
        if (variant == null) {
            ClosureParamsEnhancer.$$$reportNull$$$0(4);
        }
        if (call == null) {
            ClosureParamsEnhancer.$$$reportNull$$$0(5);
        }
        if (expression == null) {
            ClosureParamsEnhancer.$$$reportNull$$$0(6);
        }
        PsiElement element = variant.getElement();
        while (element instanceof PsiMirrorElement) {
            element = ((PsiMirrorElement)element).getPrototype();
        }
        if (!(element instanceof PsiMethod)) {
            return Collections.emptyList();
        }
        PsiParameter param = null;
        if (variant instanceof GroovyMethodResult) {
            ArgumentMapping<PsiCallParameter> mapping2;
            GroovyMethodCandidate candidate2 = ((GroovyMethodResult)variant).getCandidate();
            if (candidate2 != null && (mapping2 = candidate2.getArgumentMapping()) != null) {
                PsiCallParameter obj = mapping2.targetParameter(new ExpressionArgument(expression));
                param = obj == null ? null : obj.getPsi();
            }
        } else {
            List<Pair<PsiParameter, PsiType>> params = ResolveUtil.collectExpectedParamsByArg(expression, new GroovyResolveResult[]{variant}, call.getNamedArguments(), call.getExpressionArguments(), call.getClosureArguments(), expression);
            if (params.isEmpty()) {
                return Collections.emptyList();
            }
            Pair<PsiParameter, PsiType> pair = params.get(0);
            param = (PsiParameter)pair.getFirst();
        }
        if (param == null) {
            return Collections.emptyList();
        }
        PsiModifierList modifierList = param.getModifierList();
        if (modifierList == null) {
            return Collections.emptyList();
        }
        PsiAnnotation anno = modifierList.findAnnotation("groovy.transform.stc.ClosureParams");
        if (anno == null) {
            return Collections.emptyList();
        }
        PsiClass closureSignatureHint = GrAnnotationUtil.inferClassAttribute(anno, "value");
        if (closureSignatureHint == null) {
            return Collections.emptyList();
        }
        String qnameOfClosureSignatureHint = closureSignatureHint.getQualifiedName();
        if (qnameOfClosureSignatureHint == null) {
            return Collections.emptyList();
        }
        SignatureHintProcessor signatureHintProcessor = SignatureHintProcessor.getHintProcessor(qnameOfClosureSignatureHint);
        if (signatureHintProcessor == null) {
            return Collections.emptyList();
        }
        PsiSubstitutor substitutor2 = null;
        if (variant instanceof GroovyMethodResult && (candidate = ((GroovyMethodResult)variant).getCandidate()) != null) {
            GroovyInferenceSessionBuilder builder = new GroovyInferenceSessionBuilder(call, candidate, variant.getContextSubstitutor());
            substitutor2 = ClosureParamsEnhancer.computeAnnotationBasedSubstitutor(call, builder);
        }
        if (substitutor2 == null) {
            substitutor2 = variant.getSubstitutor();
        }
        return signatureHintProcessor.inferExpectedSignatures((PsiMethod)element, substitutor2, SignatureHintProcessor.buildOptions(anno));
    }

    @NotNull
    private static PsiSubstitutor computeAnnotationBasedSubstitutor(@NotNull GrCall call, @NotNull GroovyInferenceSessionBuilder builder) {
        if (call == null) {
            ClosureParamsEnhancer.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            ClosureParamsEnhancer.$$$reportNull$$$0(8);
        }
        PsiSubstitutor psiSubstitutor = builder.skipClosureIn(call).resolveMode(false).build().inferSubst();
        if (psiSubstitutor == null) {
            ClosureParamsEnhancer.$$$reportNull$$$0(9);
        }
        return psiSubstitutor;
    }

    private static boolean containsParametersWithDeclaredType(GrParameter[] parameters2) {
        return ContainerUtil.find((Object[])parameters2, parameter -> parameter.getDeclaredType() != null) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureParamsEnhancer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureParamsEnhancer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findFittingSignatures";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAnnotationBasedSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClosureParameterType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFittingSignatures";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "inferExpectedSignatures";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeAnnotationBasedSubstitutor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

