/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.changeSignature.PossiblyIncorrectUsage;
import com.intellij.usageView.UsageInfo;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConstructorCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class GrMethodCallUsageInfo
extends UsageInfo
implements PossiblyIncorrectUsage {
    private final boolean myToChangeArguments;
    private final boolean myToCatchExceptions;
    private final GrClosureSignatureUtil.ArgInfo<PsiElement>[] myMapToArguments;
    private PsiSubstitutor mySubstitutor;

    public boolean isToCatchExceptions() {
        return this.myToCatchExceptions;
    }

    public boolean isToChangeArguments() {
        return this.myToChangeArguments;
    }

    public GrMethodCallUsageInfo(PsiElement element, boolean isToChangeArguments, boolean isToCatchExceptions, PsiMethod method) {
        super(element);
        GroovyResolveResult resolveResult2 = GrMethodCallUsageInfo.resolveMethod(element);
        if (resolveResult2 == null || resolveResult2.getElement() == null) {
            this.mySubstitutor = PsiSubstitutor.EMPTY;
        } else if (resolveResult2.getElement() instanceof PsiMethod) {
            PsiMethod resolved = (PsiMethod)resolveResult2.getElement();
            this.mySubstitutor = resolveResult2.getSubstitutor();
            if (!element.getManager().areElementsEquivalent((PsiElement)method, (PsiElement)resolved)) {
                PsiClass baseClass = method.getContainingClass();
                PsiClass derivedClass = resolved.getContainingClass();
                if (baseClass != null && derivedClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)derivedClass, (PsiClass)baseClass, (boolean)true)) {
                    PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)derivedClass, (PsiSubstitutor)this.mySubstitutor);
                    MethodSignature superMethodSignature = method.getSignature(superClassSubstitutor);
                    MethodSignature methodSignature = resolved.getSignature(PsiSubstitutor.EMPTY);
                    PsiSubstitutor superMethodSignatureSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superMethodSignature);
                    this.mySubstitutor = TypesUtil.composeSubstitutors(superMethodSignatureSubstitutor, this.mySubstitutor);
                }
            }
        }
        GrSignature signature = GrClosureSignatureUtil.createSignature(method, this.mySubstitutor);
        this.myToChangeArguments = isToChangeArguments;
        this.myToCatchExceptions = isToCatchExceptions;
        GrCall call = GroovyRefactoringUtil.getCallExpressionByMethodReference(element);
        this.myMapToArguments = call == null ? GrClosureSignatureUtil.ArgInfo.empty_array() : GrClosureSignatureUtil.mapParametersToArguments(signature, call.getNamedArguments(), call.getExpressionArguments(), call.getClosureArguments(), call, false, false);
    }

    @Nullable
    public PsiMethod getReferencedMethod() {
        GroovyResolveResult result2 = GrMethodCallUsageInfo.resolveMethod(this.getElement());
        if (result2 == null) {
            return null;
        }
        PsiElement element = result2.getElement();
        return element instanceof PsiMethod ? (PsiMethod)element : null;
    }

    @Nullable
    private static GroovyResolveResult resolveMethod(PsiElement ref) {
        if (ref instanceof GrEnumConstant) {
            return ((GrEnumConstant)ref).advancedResolve();
        }
        PsiElement parent2 = ref.getParent();
        if (parent2 instanceof GrMethodCall) {
            GrExpression expression = ((GrMethodCall)parent2).getInvokedExpression();
            if (expression instanceof GrReferenceExpression) {
                return ((GrReferenceExpression)expression).advancedResolve();
            }
        } else if (parent2 instanceof GrConstructorCall) {
            return ((GrConstructorCall)parent2).advancedResolve();
        }
        return null;
    }

    public GrClosureSignatureUtil.ArgInfo<PsiElement>[] getMapToArguments() {
        return this.myMapToArguments;
    }

    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    public boolean isPossibleUsage() {
        GroovyResolveResult resolveResult2 = GrMethodCallUsageInfo.resolveMethod(this.getElement());
        return resolveResult2 == null || resolveResult2.getElement() == null;
    }

    public boolean isCorrect() {
        return this.myMapToArguments != null;
    }
}

