/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public final class InlineMethodConflictSolver {
    private InlineMethodConflictSolver() {
    }

    @NotNull
    public static String suggestNewName(@NotNull String startName, @Nullable GrMethod method, @NotNull PsiElement call, String ... otherNames) {
        String newName;
        PsiElement parent2;
        if (startName == null) {
            InlineMethodConflictSolver.$$$reportNull$$$0(0);
        }
        if (call == null) {
            InlineMethodConflictSolver.$$$reportNull$$$0(1);
        }
        int i = 1;
        for (parent2 = call.getParent(); !(parent2 instanceof GrVariableDeclarationOwner) && parent2 != null; parent2 = parent2.getParent()) {
        }
        if (parent2 == null || InlineMethodConflictSolver.isValidName(startName, parent2, call) && InlineMethodConflictSolver.isValid(startName, otherNames)) {
            String string = startName;
            if (string == null) {
                InlineMethodConflictSolver.$$$reportNull$$$0(2);
            }
            return string;
        }
        do {
            newName = startName + i;
            ++i;
        } while (method != null && !InlineMethodConflictSolver.isValidNameInMethod(newName, method) || !InlineMethodConflictSolver.isValidName(newName, parent2, call) || !InlineMethodConflictSolver.isValid(newName, otherNames));
        String string = newName;
        if (string == null) {
            InlineMethodConflictSolver.$$$reportNull$$$0(3);
        }
        return string;
    }

    static boolean isValid(@Nullable String name, String ... otherNames) {
        for (String otherName : otherNames) {
            if (!otherName.equals(name)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidNameInMethod(@NotNull String name, @NotNull GrMethod method) {
        if (name == null) {
            InlineMethodConflictSolver.$$$reportNull$$$0(4);
        }
        if (method == null) {
            InlineMethodConflictSolver.$$$reportNull$$$0(5);
        }
        for (GrParameter parameter : method.getParameters()) {
            if (!name.equals(parameter.getName())) continue;
            return false;
        }
        GrOpenBlock block = method.getBlock();
        if (block != null) {
            return InlineMethodConflictSolver.isValidNameDown(name, block, null);
        }
        return true;
    }

    public static boolean isValidName(@NotNull String name, @NotNull PsiElement scopeElement, PsiElement call) {
        if (name == null) {
            InlineMethodConflictSolver.$$$reportNull$$$0(6);
        }
        if (scopeElement == null) {
            InlineMethodConflictSolver.$$$reportNull$$$0(7);
        }
        if (InlineMethodConflictSolver.isValidNameDown(name, scopeElement, call)) {
            if (!(scopeElement instanceof GroovyFileBase)) {
                return InlineMethodConflictSolver.isValidNameUp(name, scopeElement, call);
            }
            return true;
        }
        return false;
    }

    private static boolean isValidNameDown(@NotNull String name, @NotNull PsiElement startElement, @Nullable PsiElement call) {
        if (name == null) {
            InlineMethodConflictSolver.$$$reportNull$$$0(8);
        }
        if (startElement == null) {
            InlineMethodConflictSolver.$$$reportNull$$$0(9);
        }
        PsiElement child = startElement.getFirstChild();
        while (child != null) {
            GrReferenceExpression expr;
            GrExpression lValue;
            if (child instanceof GrTypeDefinition || child instanceof GrMethod || call != null && GroovyRefactoringUtil.isAppropriateContainerForIntroduceVariable(child) && child.getTextRange().getEndOffset() < call.getTextRange().getStartOffset()) {
                child = child.getNextSibling();
                continue;
            }
            if (child instanceof GrAssignmentExpression && (lValue = ((GrAssignmentExpression)child).getLValue()) instanceof GrReferenceExpression && (expr = (GrReferenceExpression)lValue).getQualifierExpression() == null && name.equals(expr.getReferenceName())) {
                return false;
            }
            if (child instanceof GrVariable && name.equals(((GrVariable)child).getName())) {
                return false;
            }
            boolean inner = InlineMethodConflictSolver.isValidNameDown(name, child, call);
            if (!inner) {
                return false;
            }
            child = child.getNextSibling();
        }
        return true;
    }

    private static boolean isValidNameUp(@NotNull String name, @NotNull PsiElement startElement, @Nullable PsiElement call) {
        if (name == null) {
            InlineMethodConflictSolver.$$$reportNull$$$0(10);
        }
        if (startElement == null) {
            InlineMethodConflictSolver.$$$reportNull$$$0(11);
        }
        if (startElement instanceof PsiFile) {
            return true;
        }
        for (PsiElement prevSibling = startElement.getPrevSibling(); prevSibling != null; prevSibling = prevSibling.getPrevSibling()) {
            if (InlineMethodConflictSolver.isValidNameDown(name, prevSibling, call)) continue;
            return false;
        }
        PsiElement parent2 = startElement.getParent();
        return parent2 == null || parent2 instanceof PsiDirectory || InlineMethodConflictSolver.isValidNameUp(name, parent2, call);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/inline/InlineMethodConflictSolver";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/inline/InlineMethodConflictSolver";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNewName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestNewName";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidNameInMethod";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isValidNameDown";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isValidNameUp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

