/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.field;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.KeyboardComboSwitcher;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.introduceField.IntroduceFieldHandler;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrAbstractInplaceIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrFinalListener;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldProcessor;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GroovyInplaceFieldValidator;

public class GrInplaceFieldIntroducer
extends GrAbstractInplaceIntroducer<GrIntroduceFieldSettings> {
    private final EnumSet<GrIntroduceFieldSettings.Init> myApplicablePlaces;
    private GrInplaceIntroduceFieldPanel myPanel;
    private final GrFinalListener finalListener;
    private final String[] mySuggestedNames;
    private boolean myIsStatic;
    private final GrVariable myLocalVar;

    public GrInplaceFieldIntroducer(GrIntroduceContext context, OccurrencesChooser.ReplaceChoice choice) {
        super(IntroduceFieldHandler.getRefactoringNameText(), choice, context);
        this.finalListener = new GrFinalListener(this.myEditor);
        this.myLocalVar = GrIntroduceHandlerBase.resolveLocalVar(context);
        if (this.myLocalVar != null) {
            ArrayList result2 = ContainerUtil.newArrayList((Object[])new String[]{this.myLocalVar.getName()});
            GrExpression initializer = this.myLocalVar.getInitializerGroovy();
            if (initializer != null) {
                ContainerUtil.addAll((Collection)result2, (Object[])GroovyNameSuggestionUtil.suggestVariableNames(initializer, new GroovyInplaceFieldValidator(this.getContext()), false));
            }
            this.mySuggestedNames = ArrayUtilRt.toStringArray((Collection)result2);
        } else {
            this.mySuggestedNames = GroovyNameSuggestionUtil.suggestVariableNames(context.getExpression(), new GroovyInplaceFieldValidator(this.getContext()), false);
        }
        this.myApplicablePlaces = this.getApplicableInitPlaces();
    }

    @Nullable
    protected PsiElement checkLocalScope() {
        GrVariable variable = this.getVariable();
        if (variable instanceof PsiField) {
            return ((PsiField)this.getVariable()).getContainingClass();
        }
        PsiFile file = variable.getContainingFile();
        if (file instanceof GroovyFile) {
            return ((GroovyFile)file).getScriptClass();
        }
        return null;
    }

    @Override
    protected GrVariable runRefactoring(GrIntroduceContext context, GrIntroduceFieldSettings settings, boolean processUsages) {
        return this.refactorInWriteAction((Computable<GrVariable>)((Computable)() -> {
            GrIntroduceFieldProcessor processor = new GrIntroduceFieldProcessor(context, settings);
            return processUsages ? processor.run() : processor.insertField((PsiClass)context.getScope()).getVariables()[0];
        }));
    }

    @Override
    @Nullable
    protected GrIntroduceFieldSettings getInitialSettingsForInplace(final @NotNull GrIntroduceContext context, final @NotNull OccurrencesChooser.ReplaceChoice choice, final String[] names) {
        if (context == null) {
            GrInplaceFieldIntroducer.$$$reportNull$$$0(0);
        }
        if (choice == null) {
            GrInplaceFieldIntroducer.$$$reportNull$$$0(1);
        }
        return new GrIntroduceFieldSettings(){

            @Override
            public boolean declareFinal() {
                return false;
            }

            @Override
            public GrIntroduceFieldSettings.Init initializeIn() {
                return GrIntroduceFieldSettings.Init.FIELD_DECLARATION;
            }

            @Override
            public String getVisibilityModifier() {
                return "private";
            }

            @Override
            public boolean isStatic() {
                boolean hasInstanceInScope = true;
                PsiClass clazz = (PsiClass)context.getScope();
                if (this.replaceAllOccurrences()) {
                    for (PsiElement occurrence : context.getOccurrences()) {
                        if (PsiUtil.hasEnclosingInstanceInScope(clazz, occurrence, false)) continue;
                        hasInstanceInScope = false;
                        break;
                    }
                } else if (context.getExpression() != null) {
                    hasInstanceInScope = PsiUtil.hasEnclosingInstanceInScope(clazz, context.getExpression(), false);
                } else if (context.getStringPart() != null) {
                    hasInstanceInScope = PsiUtil.hasEnclosingInstanceInScope(clazz, context.getStringPart().getLiteral(), false);
                }
                return !hasInstanceInScope;
            }

            @Override
            public boolean removeLocalVar() {
                return GrInplaceFieldIntroducer.this.myLocalVar != null;
            }

            @Override
            @Nullable
            public String getName() {
                return names[0];
            }

            @Override
            public boolean replaceAllOccurrences() {
                return context.getVar() != null || choice == OccurrencesChooser.ReplaceChoice.ALL;
            }

            @Override
            @Nullable
            public PsiType getSelectedType() {
                GrExpression expression = context.getExpression();
                GrVariable var = context.getVar();
                StringPartInfo stringPart = context.getStringPart();
                return var != null ? var.getDeclaredType() : (expression != null ? expression.getType() : (stringPart != null ? stringPart.getLiteral().getType() : null));
            }
        };
    }

    @Override
    protected GrIntroduceFieldSettings getSettings() {
        return new GrIntroduceFieldSettings(){

            @Override
            public boolean declareFinal() {
                return GrInplaceFieldIntroducer.this.myPanel.isFinal();
            }

            @Override
            public GrIntroduceFieldSettings.Init initializeIn() {
                return GrInplaceFieldIntroducer.this.myPanel.getInitPlace();
            }

            @Override
            public String getVisibilityModifier() {
                return "private";
            }

            @Override
            public boolean isStatic() {
                return GrInplaceFieldIntroducer.this.myIsStatic;
            }

            @Override
            public boolean removeLocalVar() {
                return GrInplaceFieldIntroducer.this.myLocalVar != null;
            }

            @Override
            @Nullable
            public String getName() {
                return GrInplaceFieldIntroducer.this.getInputName();
            }

            @Override
            public boolean replaceAllOccurrences() {
                return GrInplaceFieldIntroducer.this.isReplaceAllOccurrences();
            }

            @Override
            @Nullable
            public PsiType getSelectedType() {
                return GrInplaceFieldIntroducer.this.getSelectedType();
            }
        };
    }

    protected String getActionName() {
        return IntroduceFieldHandler.getRefactoringNameText();
    }

    protected String @NotNull [] suggestNames(boolean replaceAll, @Nullable GrVariable variable) {
        if (this.mySuggestedNames == null) {
            GrInplaceFieldIntroducer.$$$reportNull$$$0(2);
        }
        return this.mySuggestedNames;
    }

    protected void saveSettings(@NotNull GrVariable variable) {
        if (variable == null) {
            GrInplaceFieldIntroducer.$$$reportNull$$$0(3);
        }
    }

    @Override
    protected void restoreState(@NotNull GrVariable psiField) {
        if (psiField == null) {
            GrInplaceFieldIntroducer.$$$reportNull$$$0(4);
        }
        this.myIsStatic = psiField.hasModifierProperty("static");
        super.restoreState(psiField);
    }

    @Nullable
    protected JComponent getComponent() {
        this.myPanel = new GrInplaceIntroduceFieldPanel();
        return this.myPanel.getRootPane();
    }

    private EnumSet<GrIntroduceFieldSettings.Init> getApplicableInitPlaces() {
        return GrInplaceFieldIntroducer.getApplicableInitPlaces(this.getContext(), this.isReplaceAllOccurrences());
    }

    public static EnumSet<GrIntroduceFieldSettings.Init> getApplicableInitPlaces(GrIntroduceContext context, boolean replaceAllOccurrences) {
        PsiElement scope;
        EnumSet<GrIntroduceFieldSettings.Init> result2 = EnumSet.noneOf(GrIntroduceFieldSettings.Init.class);
        if (!(context.getScope() instanceof GroovyScriptClass) && !(context.getScope() instanceof GroovyFileBase)) {
            if (context.getExpression() != null || context.getVar() != null && context.getVar().getInitializerGroovy() != null || context.getStringPart() != null) {
                result2.add(GrIntroduceFieldSettings.Init.FIELD_DECLARATION);
            }
            result2.add(GrIntroduceFieldSettings.Init.CONSTRUCTOR);
        }
        if ((scope = context.getScope()) instanceof GroovyScriptClass) {
            scope = scope.getContainingFile();
        }
        if (replaceAllOccurrences || context.getExpression() != null) {
            PsiElement anchor;
            PsiElement[] psiElementArray;
            if (replaceAllOccurrences) {
                psiElementArray = context.getOccurrences();
            } else {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = context.getExpression();
            }
            PsiElement[] occurrences = psiElementArray;
            PsiElement parent2 = PsiTreeUtil.findCommonParent((PsiElement[])occurrences);
            PsiElement container = GrIntroduceHandlerBase.getEnclosingContainer(parent2);
            if (container != null && PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)container, (boolean)false) && (anchor = GrIntroduceHandlerBase.findAnchor(occurrences, container)) != null) {
                result2.add(GrIntroduceFieldSettings.Init.CUR_METHOD);
            }
        }
        if (scope instanceof GrTypeDefinition && TestFrameworks.getInstance().isTestClass((PsiClass)scope)) {
            result2.add(GrIntroduceFieldSettings.Init.SETUP_METHOD);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "choice";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrInplaceFieldIntroducer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrInplaceFieldIntroducer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInitialSettingsForInplace";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restoreState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class GrInplaceIntroduceFieldPanel {
        private JPanel myRootPane;
        private JComboBox myInitCB;
        private NonFocusableCheckBox myDeclareFinalCB;
        private JComponent myPreview;

        public GrInplaceIntroduceFieldPanel() {
            this.$$$setupUI$$$();
            KeyboardComboSwitcher.setupActions((JComboBox)this.myInitCB, (Project)GrInplaceFieldIntroducer.this.myProject);
            for (GrIntroduceFieldSettings.Init place : GrInplaceFieldIntroducer.this.myApplicablePlaces) {
                this.myInitCB.addItem(place);
            }
            this.myDeclareFinalCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WriteCommandAction.writeCommandAction((Project)GrInplaceFieldIntroducer.this.myProject).withName(GrInplaceFieldIntroducer.this.getCommandName()).withGroupId(GrInplaceFieldIntroducer.this.getCommandName()).run(() -> {
                        PsiDocumentManager.getInstance((Project)GrInplaceFieldIntroducer.this.myProject).commitDocument(GrInplaceFieldIntroducer.this.myEditor.getDocument());
                        GrVariable variable = GrInplaceFieldIntroducer.this.getVariable();
                        if (variable != null) {
                            GrInplaceFieldIntroducer.this.finalListener.perform(GrInplaceIntroduceFieldPanel.this.myDeclareFinalCB.isSelected(), variable);
                        }
                    });
                }
            });
        }

        public JPanel getRootPane() {
            return this.myRootPane;
        }

        public GrIntroduceFieldSettings.Init getInitPlace() {
            return (GrIntroduceFieldSettings.Init)((Object)this.myInitCB.getSelectedItem());
        }

        public boolean isFinal() {
            return this.myDeclareFinalCB.isSelected();
        }

        private void createUIComponents() {
            this.myPreview = GrInplaceFieldIntroducer.this.getPreviewComponent();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            NonFocusableCheckBox nonFocusableCheckBox;
            JComboBox jComboBox;
            JPanel jPanel;
            this.createUIComponents();
            this.myRootPane = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
            JBLabel jBLabel = new JBLabel();
            this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/GroovyRefactoringBundle", GrInplaceIntroduceFieldPanel.class).getString("initialize.in.label"));
            jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
            this.myInitCB = jComboBox = new JComboBox();
            jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myDeclareFinalCB = nonFocusableCheckBox = new NonFocusableCheckBox();
            nonFocusableCheckBox.setHorizontalAlignment(10);
            this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox, DynamicBundle.getBundle((String)"messages/GroovyRefactoringBundle", GrInplaceIntroduceFieldPanel.class).getString("declare.final.checkbox"));
            jPanel.add((Component)nonFocusableCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null));
            JComponent jComponent = this.myPreview;
            jPanel.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
            jBLabel.setLabelFor(jComboBox);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myRootPane;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

