/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public final class GrTypeComboBox
extends ComboBox {
    private static final Logger LOG = Logger.getInstance(GrTypeComboBox.class);

    public static GrTypeComboBox createTypeComboBoxWithDefType(@Nullable PsiType type2, @NotNull PsiElement context) {
        if (context == null) {
            GrTypeComboBox.$$$reportNull$$$0(0);
        }
        return new GrTypeComboBox(type2, null, true, context, false);
    }

    public static GrTypeComboBox createTypeComboBoxFromExpression(@NotNull GrExpression expression) {
        if (expression == null) {
            GrTypeComboBox.$$$reportNull$$$0(1);
        }
        return GrTypeComboBox.createTypeComboBoxFromExpression(expression, false);
    }

    public static GrTypeComboBox createTypeComboBoxFromExpression(@NotNull GrExpression expression, boolean selectDef) {
        PsiElement resolved;
        if (expression == null) {
            GrTypeComboBox.$$$reportNull$$$0(2);
        }
        PsiType type2 = expression.getType();
        if (expression instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)expression).resolve()) instanceof PsiClass) {
            type2 = TypesUtil.createJavaLangClassType(type2, expression);
        }
        if (GroovyRefactoringUtil.isDiamondNewOperator(expression)) {
            LOG.assertTrue(expression instanceof GrNewExpression);
            PsiType expected = PsiImplUtil.inferExpectedTypeForDiamond(expression);
            return new GrTypeComboBox(type2, expected, expected == null, expression, selectDef);
        }
        if (type2 == PsiType.NULL) {
            type2 = PsiType.getJavaLangObject((PsiManager)expression.getManager(), (GlobalSearchScope)expression.getResolveScope());
        }
        return new GrTypeComboBox(type2, null, true, expression, selectDef);
    }

    public static GrTypeComboBox createEmptyTypeComboBox() {
        return new GrTypeComboBox(null, null, false, null, false);
    }

    private GrTypeComboBox(@Nullable PsiType type2, @Nullable PsiType min, boolean createDef, @Nullable PsiElement context, boolean selectDef) {
        LOG.assertTrue(min == null || context != null);
        LOG.assertTrue(type2 == null || context != null);
        if (type2 instanceof PsiDisjunctionType) {
            type2 = ((PsiDisjunctionType)type2).getLeastUpperBound();
        }
        Map<Object, Object> types = Collections.emptyMap();
        if (type2 != null) {
            types = GrTypeComboBox.getCompatibleTypeNames(type2, min, context);
        }
        if (createDef || types.isEmpty()) {
            this.addItem(new PsiTypeItem(null));
        }
        if (type2 != null && type2.equalsToText("java.math.BigDecimal")) {
            this.addItem(new PsiTypeItem(type2));
            types.remove("java.math.BigDecimal");
            this.addItem(new PsiTypeItem((PsiType)PsiType.DOUBLE));
        }
        for (String string : types.keySet()) {
            this.addItem(new PsiTypeItem((PsiType)types.get(string)));
        }
        if (!selectDef && createDef && this.getItemCount() > 1) {
            this.setSelectedIndex(1);
        }
    }

    public void addClosureTypesFrom(@Nullable PsiType type2, @NotNull PsiElement context) {
        if (context == null) {
            GrTypeComboBox.$$$reportNull$$$0(3);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        PsiType cl = type2 == null || type2 == PsiType.NULL ? factory.createTypeFromText("groovy.lang.Closure", context) : factory.createTypeFromText("groovy.lang.Closure<" + type2.getCanonicalText() + ">", context);
        this.addItem(new PsiTypeItem(cl, true));
    }

    @Nullable
    public PsiType getSelectedType() {
        Object selected = this.getSelectedItem();
        assert (selected instanceof PsiTypeItem);
        return ((PsiTypeItem)selected).getType();
    }

    public boolean isClosureSelected() {
        return ((PsiTypeItem)this.getSelectedItem()).isClosure();
    }

    private static Map<String, PsiType> getCompatibleTypeNames(@NotNull PsiType type2, @Nullable PsiType min, @NotNull PsiElement context) {
        if (type2 == null) {
            GrTypeComboBox.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GrTypeComboBox.$$$reportNull$$$0(5);
        }
        if (type2 instanceof PsiDisjunctionType) {
            type2 = ((PsiDisjunctionType)type2).getLeastUpperBound();
        }
        if (min != null && !TypesUtil.isAssignable(min, type2, context)) {
            min = null;
        }
        LinkedHashMap<String, PsiType> map2 = new LinkedHashMap<String, PsiType>();
        PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)type2);
        if (unboxed != null) {
            type2 = unboxed;
        }
        LinkedHashSet<PsiType> set = new LinkedHashSet<PsiType>();
        set.add(type2);
        while (!set.isEmpty()) {
            PsiType cur = (PsiType)set.iterator().next();
            set.remove(cur);
            if (map2.containsValue(cur) || min != null && !TypesUtil.isAssignable(min, cur, context)) continue;
            if (GrTypeComboBox.isPartiallySubstituted(cur)) {
                LOG.assertTrue(cur instanceof PsiClassType);
                PsiClassType rawType = ((PsiClassType)cur).rawType();
                map2.put(rawType.getPresentableText(), (PsiType)rawType);
            } else {
                map2.put(cur.getPresentableText(), cur);
            }
            for (PsiType superType : cur.getSuperTypes()) {
                if (map2.containsValue(superType)) continue;
                set.add(superType);
            }
        }
        return map2;
    }

    private static boolean isPartiallySubstituted(PsiType type2) {
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiType[] parameters2 = ((PsiClassType)type2).getParameters();
        PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)type2).resolveGenerics();
        PsiClass clazz = classResolveResult.getElement();
        if (clazz == null) {
            return false;
        }
        return clazz.getTypeParameters().length != parameters2.length;
    }

    public static void registerUpDownHint(JComponent component, final GrTypeComboBox combo) {
        AnAction arrow = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getInputEvent() instanceof KeyEvent) {
                    int code = ((KeyEvent)e.getInputEvent()).getKeyCode();
                    GrTypeComboBox.scrollBy(code == 40 ? 1 : (code == 38 ? -1 : 0), combo);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/refactoring/ui/GrTypeComboBox$1", "actionPerformed"));
            }
        };
        KeyboardShortcut up = new KeyboardShortcut(KeyStroke.getKeyStroke(38, 512), null);
        KeyboardShortcut down = new KeyboardShortcut(KeyStroke.getKeyStroke(40, 512), null);
        arrow.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{up, down}), component);
    }

    private static void scrollBy(int delta, GrTypeComboBox combo) {
        if (delta == 0) {
            return;
        }
        int size = combo.getModel().getSize();
        int next = combo.getSelectedIndex() + delta;
        if (next < 0 || next >= size) {
            if (!UISettings.getInstance().getCycleScrolling()) {
                return;
            }
            next = (next + size) % size;
        }
        combo.setSelectedIndex(next);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/ui/GrTypeComboBox";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeComboBoxWithDefType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeComboBoxFromExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addClosureTypesFrom";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getCompatibleTypeNames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class PsiTypeItem {
        @Nullable
        private final PsiType myType;
        private final boolean isClosure;

        private PsiTypeItem(PsiType type2) {
            this(type2, false);
        }

        private PsiTypeItem(@Nullable PsiType type2, boolean closure) {
            this.myType = type2;
            this.isClosure = closure;
        }

        @Nullable
        public PsiType getType() {
            return this.myType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PsiTypeItem that = (PsiTypeItem)o;
            return !(this.myType == null ? that.myType != null : !this.myType.equals(that.myType));
        }

        public int hashCode() {
            return this.myType == null ? 0 : this.myType.hashCode();
        }

        public String toString() {
            return this.myType == null ? "def" : this.myType.getPresentableText();
        }

        public boolean isClosure() {
            return this.isClosure;
        }
    }
}

