/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.regexp;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.JavaRegExpHost;
import java.util.EnumSet;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;

public class GroovyRegExpHost
extends JavaRegExpHost {
    public boolean supportsNamedGroupSyntax(RegExpGroup group) {
        if (group.getType() == RegExpGroup.Type.NAMED_GROUP) {
            String version = GroovyRegExpHost.getGroovyVersion((PsiElement)group);
            return version != null && version.compareTo("2.0") >= 0;
        }
        return false;
    }

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        if (ref.isNamedGroupRef()) {
            String version = GroovyRegExpHost.getGroovyVersion((PsiElement)ref);
            return version != null && version.compareTo("2.0") >= 0;
        }
        return false;
    }

    @NotNull
    public EnumSet<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        String version = GroovyRegExpHost.getGroovyVersion((PsiElement)context);
        if (version == null || version.compareTo("2.0") < 0) {
            EnumSet enumSet = EMPTY_NAMED_GROUP_TYPES;
            if (enumSet == null) {
                GroovyRegExpHost.$$$reportNull$$$0(0);
            }
            return enumSet;
        }
        EnumSet enumSet = SUPPORTED_NAMED_GROUP_TYPES;
        if (enumSet == null) {
            GroovyRegExpHost.$$$reportNull$$$0(1);
        }
        return enumSet;
    }

    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        String version = GroovyRegExpHost.getGroovyVersion((PsiElement)regExpChar);
        return version != null && version.compareTo("2.0") >= 0;
    }

    private static String getGroovyVersion(PsiElement element) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        return GroovyConfigUtils.getInstance().getSDKVersion(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/regexp/GroovyRegExpHost", "getSupportedNamedGroupTypes"));
    }
}

