/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters;

import com.intellij.rt.coverage.instrumentation.filters.enumerating.LineEnumeratorFilter;
import com.intellij.rt.coverage.instrumentation.filters.enumerating.NotNullAssertionsFilter;
import com.intellij.rt.coverage.instrumentation.filters.signature.EnumMethodsFilter;
import com.intellij.rt.coverage.instrumentation.filters.signature.MethodSignatureFilter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.ClosingBracesFilter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.MethodVisitingFilter;
import com.intellij.rt.coverage.instrumentation.kotlin.KotlinUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterUtils {
    private static final boolean ourIgnorePrivateConstructorOfUtilClass = "true".equals(System.getProperty("coverage.ignore.private.constructor.util.class", "false"));

    public static boolean ignorePrivateConstructorOfUtilClassEnabled() {
        return ourIgnorePrivateConstructorOfUtilClass;
    }

    public static List<MethodSignatureFilter> createSignatureFilters() {
        List<MethodSignatureFilter> result = KotlinUtils.createSignatureFilters();
        result.add(new EnumMethodsFilter());
        return result;
    }

    public static List<MethodVisitingFilter> createVisitingFilters() {
        List<MethodVisitingFilter> result = KotlinUtils.createVisitingFilters();
        result.add(new ClosingBracesFilter());
        return result;
    }

    public static List<LineEnumeratorFilter> createLineEnumeratorFilters() {
        List<LineEnumeratorFilter> result = KotlinUtils.createLineEnumeratorFilters();
        result.add(new NotNullAssertionsFilter());
        return result;
    }
}

