/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public final class DefaultBranchConfig {
    private static final Logger LOG = Logger.getInstance(DefaultBranchConfig.class);
    @NlsSafe
    public static final String TRUNK_NAME = "trunk";
    @NlsSafe
    public static final String BRANCHES_NAME = "branches";
    @NlsSafe
    public static final String TAGS_NAME = "tags";

    @Nullable
    public static SvnBranchConfigurationNew detect(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            DefaultBranchConfig.$$$reportNull$$$0(0);
        }
        if (root == null) {
            DefaultBranchConfig.$$$reportNull$$$0(1);
        }
        SvnBranchConfigurationNew result = null;
        SvnVcs vcs = SvnVcs.getInstance(project);
        Url rootUrl = SvnUtil.getUrl(vcs, VfsUtilCore.virtualToIoFile((VirtualFile)root));
        if (rootUrl != null) {
            try {
                result = DefaultBranchConfig.detect(vcs, rootUrl);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        } else {
            LOG.info("Directory is not a working copy: " + root.getPresentableUrl());
        }
        return result;
    }

    @NotNull
    private static SvnBranchConfigurationNew detect(@NotNull SvnVcs vcs, @NotNull Url url) throws VcsException {
        if (vcs == null) {
            DefaultBranchConfig.$$$reportNull$$$0(2);
        }
        if (url == null) {
            DefaultBranchConfig.$$$reportNull$$$0(3);
        }
        SvnBranchConfigurationNew result = new SvnBranchConfigurationNew();
        result.setTrunk(url);
        Url branchLocationsParent = DefaultBranchConfig.getBranchLocationsParent(url);
        if (branchLocationsParent != null) {
            Target target = Target.on(branchLocationsParent);
            vcs.getFactory(target).createBrowseClient().list(target, Revision.HEAD, Depth.IMMEDIATES, DefaultBranchConfig.createHandler(result, target.getUrl()));
        }
        SvnBranchConfigurationNew svnBranchConfigurationNew = result;
        if (svnBranchConfigurationNew == null) {
            DefaultBranchConfig.$$$reportNull$$$0(4);
        }
        return svnBranchConfigurationNew;
    }

    @Nullable
    private static Url getBranchLocationsParent(@NotNull Url url) throws SvnBindException {
        if (url == null) {
            DefaultBranchConfig.$$$reportNull$$$0(5);
        }
        while (!DefaultBranchConfig.hasEmptyName(url) && !DefaultBranchConfig.hasDefaultName(url)) {
            url = SvnUtil.removePathTail(url);
        }
        return DefaultBranchConfig.hasDefaultName(url) ? SvnUtil.removePathTail(url) : null;
    }

    private static boolean hasEmptyName(@NotNull Url url) {
        if (url == null) {
            DefaultBranchConfig.$$$reportNull$$$0(6);
        }
        return StringUtil.isEmpty((String)url.getTail());
    }

    private static boolean hasDefaultName(@NotNull Url url) {
        String name;
        if (url == null) {
            DefaultBranchConfig.$$$reportNull$$$0(7);
        }
        return (name = url.getTail()).equalsIgnoreCase(TRUNK_NAME) || name.equalsIgnoreCase(BRANCHES_NAME) || name.equalsIgnoreCase(TAGS_NAME);
    }

    @NotNull
    private static DirectoryEntryConsumer createHandler(@NotNull SvnBranchConfigurationNew result, @NotNull Url rootPath) {
        if (result == null) {
            DefaultBranchConfig.$$$reportNull$$$0(8);
        }
        if (rootPath == null) {
            DefaultBranchConfig.$$$reportNull$$$0(9);
        }
        DirectoryEntryConsumer directoryEntryConsumer = entry -> {
            if (entry.isDirectory()) {
                Url childUrl = SvnUtil.append(rootPath, entry.getName());
                if (StringUtil.endsWithIgnoreCase((String)entry.getName(), (String)TRUNK_NAME)) {
                    result.setTrunk(childUrl);
                } else {
                    result.addBranches(childUrl, new InfoStorage<List<SvnBranchItem>>(new ArrayList(0), InfoReliability.defaultValues));
                }
            }
        };
        if (directoryEntryConsumer == null) {
            DefaultBranchConfig.$$$reportNull$$$0(10);
        }
        return directoryEntryConsumer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/branchConfig/DefaultBranchConfig";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/branchConfig/DefaultBranchConfig";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 4: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBranchLocationsParent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasEmptyName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

