/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class QuantitySelection<T> {
    @NotNull
    private final Group<T> mySelected = new Group();
    @NotNull
    private final Group<T> myUnselected = new Group();

    public QuantitySelection(boolean startFromSelectAll) {
        if (startFromSelectAll) {
            this.mySelected.setAll();
        } else {
            this.myUnselected.setAll();
        }
    }

    public void add(T t) {
        if (this.mySelected.hasAll()) {
            this.myUnselected.remove(t);
        } else {
            this.mySelected.add(t);
        }
    }

    public void remove(T t) {
        if (this.mySelected.hasAll()) {
            this.myUnselected.add(t);
        } else {
            this.mySelected.remove(t);
        }
    }

    public void clearAll() {
        this.mySelected.clearAll();
        this.myUnselected.setAll();
    }

    public void setAll() {
        this.myUnselected.clearAll();
        this.mySelected.setAll();
    }

    @NotNull
    public Set<T> getSelected() {
        Set<T> set = this.mySelected.getItems();
        if (set == null) {
            QuantitySelection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public Set<T> getUnselected() {
        Set<T> set = this.myUnselected.getItems();
        if (set == null) {
            QuantitySelection.$$$reportNull$$$0(1);
        }
        return set;
    }

    public boolean isSelected(T t) {
        return this.mySelected.hasAll() && !this.myUnselected.has(t) || this.myUnselected.hasAll() && this.mySelected.has(t);
    }

    public boolean areAllSelected() {
        return this.mySelected.hasAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/svn/integrate/QuantitySelection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelected";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnselected";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Group<T> {
        private boolean myAll;
        @NotNull
        private final Set<T> myItems = new HashSet<T>();

        private Group() {
        }

        public void add(T t) {
            this.myItems.add(t);
        }

        public void remove(T t) {
            this.myAll = false;
            this.myItems.remove(t);
        }

        public void clearAll() {
            this.myAll = false;
            this.myItems.clear();
        }

        public void setAll() {
            this.myAll = true;
            this.myItems.clear();
        }

        @NotNull
        public Set<T> getItems() {
            Set<T> set = this.myItems;
            if (set == null) {
                Group.$$$reportNull$$$0(0);
            }
            return set;
        }

        public boolean hasAll() {
            return this.myAll;
        }

        public boolean has(T t) {
            return this.myItems.contains(t);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/QuantitySelection$Group", "getItems"));
        }
    }
}

