/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.org.apache.ivy.core.IvyContext;
import org.jetbrains.kotlin.org.apache.ivy.core.cache.ArtifactOrigin;
import org.jetbrains.kotlin.org.apache.ivy.core.cache.RepositoryCacheManager;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.Artifact;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.jetbrains.kotlin.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.org.apache.ivy.core.settings.IvyVariableContainer;
import org.jetbrains.kotlin.org.apache.ivy.core.settings.IvyVariableContainerImpl;
import org.jetbrains.kotlin.org.apache.ivy.util.Message;
import org.jetbrains.kotlin.org.apache.ivy.util.StringUtils;

public final class IvyPatternHelper {
    private static final Pattern PARAM_PATTERN = Pattern.compile("\\@\\{(.*?)\\}");
    private static final Pattern VAR_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");

    public static String substitute(String pattern, ModuleRevisionId moduleRevision) {
        return IvyPatternHelper.substitute(pattern, moduleRevision.getOrganisation(), moduleRevision.getName(), moduleRevision.getBranch(), moduleRevision.getRevision(), "ivy", "ivy", "xml", null, null, moduleRevision.getQualifiedExtraAttributes(), null);
    }

    public static String substitute(String pattern, Artifact artifact) {
        return IvyPatternHelper.substitute(pattern, artifact, (String)null);
    }

    public static String substitute(String pattern, Artifact artifact, ArtifactOrigin origin) {
        return IvyPatternHelper.substitute(pattern, artifact.getModuleRevisionId(), artifact, null, origin);
    }

    public static String substitute(String pattern, Artifact artifact, String conf) {
        return IvyPatternHelper.substitute(pattern, artifact.getModuleRevisionId(), artifact, conf, null);
    }

    public static String substitute(String pattern, ModuleRevisionId mrid, Artifact artifact) {
        return IvyPatternHelper.substitute(pattern, mrid, artifact, null, null);
    }

    public static String substitute(String pattern, ModuleRevisionId mrid, Artifact artifact, String conf, ArtifactOrigin origin) {
        return IvyPatternHelper.substitute(pattern, mrid.getOrganisation(), mrid.getName(), mrid.getBranch(), mrid.getRevision(), artifact.getName(), artifact.getType(), artifact.getExt(), conf, origin, mrid.getQualifiedExtraAttributes(), artifact.getQualifiedExtraAttributes());
    }

    public static String substitute(String pattern, String org, String module, String revision, String artifact, String type, String ext) {
        return IvyPatternHelper.substitute(pattern, org, module, null, revision, artifact, type, ext, null, null, null, null);
    }

    public static String substitute(String pattern, String org, String module, String branch, String revision, String artifact, String type, String ext, String conf, ArtifactOrigin origin, Map<String, String> extraModuleAttributes, Map<String, String> extraArtifactAttributes) {
        String token;
        HashMap<String, Object> tokens = new HashMap<String, Object>();
        if (extraModuleAttributes != null) {
            for (Map.Entry<String, String> entry : extraModuleAttributes.entrySet()) {
                token = entry.getKey();
                if (token.indexOf(58) > 0) {
                    token = token.substring(token.indexOf(58) + 1);
                }
                tokens.put(token, entry.getValue());
            }
        }
        if (extraArtifactAttributes != null) {
            for (Map.Entry<String, String> entry : extraArtifactAttributes.entrySet()) {
                token = entry.getKey();
                if (token.indexOf(58) > 0) {
                    token = token.substring(token.indexOf(58) + 1);
                }
                tokens.put(token, entry.getValue());
            }
        }
        tokens.put("organisation", org == null ? "" : org);
        tokens.put("organization", org == null ? "" : org);
        tokens.put("orgPath", org == null ? "" : org.replace('.', '/'));
        tokens.put("module", module == null ? "" : module);
        tokens.put("branch", branch == null ? "" : branch);
        tokens.put("revision", revision == null ? "" : revision);
        tokens.put("artifact", artifact == null ? module : artifact);
        tokens.put("type", type == null ? "jar" : type);
        tokens.put("ext", ext == null ? "jar" : ext);
        tokens.put("conf", conf == null ? "default" : conf);
        if (origin == null) {
            tokens.put("originalname", new OriginalArtifactNameValue(org, module, branch, revision, artifact, type, ext, extraModuleAttributes, extraArtifactAttributes));
        } else {
            tokens.put("originalname", new OriginalArtifactNameValue(origin));
        }
        return IvyPatternHelper.substituteTokens(pattern, tokens, false);
    }

    public static String substituteVariables(String pattern, Map<String, String> variables) {
        return IvyPatternHelper.substituteVariables(pattern, new IvyVariableContainerImpl(variables), new Stack<String>());
    }

    public static String substituteVariables(String pattern, IvyVariableContainer variables) {
        return IvyPatternHelper.substituteVariables(pattern, variables, new Stack<String>());
    }

    private static String substituteVariables(String pattern, IvyVariableContainer variables, Stack<String> substituting) {
        if (pattern == null) {
            return null;
        }
        Matcher m = VAR_PATTERN.matcher(pattern);
        boolean useVariables = false;
        StringBuffer sb = null;
        while (m.find()) {
            String var;
            String val;
            if (!useVariables) {
                useVariables = true;
                sb = new StringBuffer();
            }
            if ((val = variables.getVariable(var = m.group(1))) != null) {
                int index = substituting.indexOf(var);
                if (index != -1) {
                    ArrayList<String> cycle = new ArrayList<String>(substituting.subList(index, substituting.size()));
                    cycle.add(var);
                    throw new IllegalArgumentException("cyclic variable definition: cycle = " + cycle);
                }
                substituting.push(var);
                val = IvyPatternHelper.substituteVariables(val, variables, substituting);
                substituting.pop();
            } else {
                val = m.group();
            }
            m.appendReplacement(sb, val.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$"));
        }
        if (useVariables) {
            m.appendTail(sb);
            return sb.toString();
        }
        return pattern;
    }

    public static String substituteTokens(String pattern, Map<String, String> tokens) {
        HashMap<String, Object> tokensCopy = new HashMap<String, Object>();
        tokensCopy.putAll(tokens);
        return IvyPatternHelper.substituteTokens(pattern, tokensCopy, true);
    }

    private static String substituteTokens(String pattern, Map<String, Object> tokens, boolean external) {
        HashMap tokensCopy;
        HashMap hashMap = tokensCopy = external ? tokens : new HashMap(tokens);
        if (tokensCopy.containsKey("organisation") && !tokensCopy.containsKey("organization")) {
            tokensCopy.put("organization", tokensCopy.get("organisation"));
        }
        if (tokensCopy.containsKey("organisation") && !tokensCopy.containsKey("orgPath")) {
            String org = (String)tokensCopy.get("organisation");
            tokensCopy.put("orgPath", org == null ? "" : org.replace('.', '/'));
        }
        StringBuilder buffer = new StringBuilder();
        StringBuffer optionalPart = null;
        StringBuffer tokenBuffer = null;
        boolean insideOptionalPart = false;
        boolean insideToken = false;
        boolean tokenSeen = false;
        boolean tokenHadValue = false;
        block6: for (char ch : pattern.toCharArray()) {
            int i = pattern.indexOf(ch);
            switch (ch) {
                case '(': {
                    if (insideOptionalPart) {
                        throw new IllegalArgumentException("invalid start of optional part at position " + i + " in pattern " + pattern);
                    }
                    optionalPart = new StringBuffer();
                    insideOptionalPart = true;
                    tokenSeen = false;
                    tokenHadValue = false;
                    continue block6;
                }
                case ')': {
                    if (!insideOptionalPart || insideToken) {
                        throw new IllegalArgumentException("invalid end of optional part at position " + i + " in pattern " + pattern);
                    }
                    if (tokenHadValue) {
                        buffer.append(optionalPart.toString());
                    } else if (!tokenSeen) {
                        buffer.append('(').append(optionalPart.toString()).append(')');
                    }
                    insideOptionalPart = false;
                    continue block6;
                }
                case '[': {
                    if (insideToken) {
                        throw new IllegalArgumentException("invalid start of token at position " + i + " in pattern " + pattern);
                    }
                    tokenBuffer = new StringBuffer();
                    insideToken = true;
                    continue block6;
                }
                case ']': {
                    String value;
                    if (!insideToken) {
                        throw new IllegalArgumentException("invalid end of token at position " + i + " in pattern " + pattern);
                    }
                    String token = tokenBuffer.toString();
                    Object tokenValue = tokensCopy.get(token);
                    String string = value = tokenValue == null ? null : tokenValue.toString();
                    if (insideOptionalPart) {
                        tokenHadValue = !StringUtils.isNullOrEmpty(value);
                        optionalPart.append(value);
                    } else {
                        if (value == null) {
                            value = "[" + token + "]";
                        }
                        buffer.append(value);
                    }
                    insideToken = false;
                    tokenSeen = true;
                    continue block6;
                }
                default: {
                    if (insideToken) {
                        tokenBuffer.append(ch);
                        continue block6;
                    }
                    if (insideOptionalPart) {
                        optionalPart.append(ch);
                        continue block6;
                    }
                    buffer.append(ch);
                }
            }
        }
        if (insideToken) {
            throw new IllegalArgumentException("last token hasn't been closed in pattern " + pattern);
        }
        if (insideOptionalPart) {
            throw new IllegalArgumentException("optional part hasn't been closed in pattern " + pattern);
        }
        return buffer.toString();
    }

    public static String substituteToken(String pattern, String token, String value) {
        StringBuffer buf = new StringBuffer(pattern);
        IvyPatternHelper.substituteToken(buf, token, value);
        return buf.toString();
    }

    public static void substituteToken(StringBuffer buf, String token, String value) {
        String from = IvyPatternHelper.getTokenString(token);
        int fromLength = from.length();
        int index = buf.indexOf(from);
        while (index != -1) {
            buf.replace(index, index + fromLength, value);
            index = buf.indexOf(from, index);
        }
    }

    public static String getTokenString(String token) {
        return "[" + token + "]";
    }

    public static String substituteParams(String pattern, Map<String, String> params) {
        return IvyPatternHelper.substituteParams(pattern, new IvyVariableContainerImpl(params), new Stack<String>());
    }

    private static String substituteParams(String pattern, IvyVariableContainer params, Stack<String> substituting) {
        if (pattern == null) {
            return null;
        }
        Matcher m = PARAM_PATTERN.matcher(pattern);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String var = m.group(1);
            String val = params.getVariable(var);
            if (val != null) {
                int index = substituting.indexOf(var);
                if (index != -1) {
                    ArrayList<String> cycle = new ArrayList<String>(substituting.subList(index, substituting.size()));
                    cycle.add(var);
                    throw new IllegalArgumentException("cyclic param definition: cycle = " + cycle);
                }
                substituting.push(var);
                val = IvyPatternHelper.substituteVariables(val, params, substituting);
                substituting.pop();
            } else {
                val = m.group();
            }
            m.appendReplacement(sb, val.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\@", "\\\\\\@"));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static class OriginalArtifactNameValue {
        private String org;
        private String moduleName;
        private String branch;
        private String revision;
        private Map<String, String> extraModuleAttributes;
        private String artifactName;
        private String artifactType;
        private String artifactExt;
        private Map<String, String> extraArtifactAttributes;
        private ArtifactOrigin origin;

        public OriginalArtifactNameValue(String org, String moduleName, String branch, String revision, String artifactName, String artifactType, String artifactExt, Map<String, String> extraModuleAttributes, Map<String, String> extraArtifactAttributes) {
            this.org = org;
            this.moduleName = moduleName;
            this.branch = branch;
            this.revision = revision;
            this.artifactName = artifactName;
            this.artifactType = artifactType;
            this.artifactExt = artifactExt;
            this.extraModuleAttributes = extraModuleAttributes;
            this.extraArtifactAttributes = extraArtifactAttributes;
        }

        public OriginalArtifactNameValue(ArtifactOrigin origin) {
            this.origin = origin;
        }

        public String toString() {
            if (this.origin == null) {
                ModuleRevisionId revId = ModuleRevisionId.newInstance(this.org, this.moduleName, this.branch, this.revision, this.extraModuleAttributes);
                DefaultArtifact artifact = new DefaultArtifact(revId, null, this.artifactName, this.artifactType, this.artifactExt, this.extraArtifactAttributes);
                RepositoryCacheManager cacheManager = IvyContext.getContext().getSettings().getResolver(revId).getRepositoryCacheManager();
                this.origin = cacheManager.getSavedArtifactOrigin(artifact);
                if (ArtifactOrigin.isUnknown(this.origin)) {
                    Message.debug("no artifact origin found for " + artifact + " in " + cacheManager);
                    return null;
                }
            }
            if (ArtifactOrigin.isUnknown(this.origin)) {
                return null;
            }
            String location = this.origin.getLocation();
            int lastPathIndex = location.lastIndexOf(47);
            if (lastPathIndex == -1) {
                lastPathIndex = location.lastIndexOf(92);
            }
            int lastColonIndex = location.lastIndexOf(46);
            return location.substring(lastPathIndex + 1, lastColonIndex);
        }
    }
}

