/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnTypeFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.containers.ContainerUtil;
import com.theoryinpractice.testng.TestngBundle;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.annotations.DataProvider;

public class DataProviderReturnTypeInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(DataProviderReturnTypeInspection.class);
    private static final String[] KNOWN_RETURN_TYPES = new String[]{"java.util.Iterator<java.lang.Object[]>", "java.lang.Object[][]"};
    private static final String[] KNOWN_WITH_ONE_DIMENSIONAL_RETURN_TYPES = new String[]{"java.util.Iterator<java.lang.Object[]>", "java.lang.Object[][]", "java.util.Iterator<java.lang.Object>", "java.lang.Object[]"};

    public ProblemDescriptor @Nullable [] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiType returnType;
        String dataProviderFqn;
        PsiAnnotation annotation;
        if (method == null) {
            DataProviderReturnTypeInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DataProviderReturnTypeInspection.$$$reportNull$$$0(1);
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{dataProviderFqn = DataProvider.class.getName()})) != null && (returnType = method.getReturnType()) != null && !DataProviderReturnTypeInspection.isSuitableReturnType(method, returnType, annotation)) {
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            LOG.assertTrue(returnTypeElement != null);
            boolean supportOneDimensional = DataProviderReturnTypeInspection.supportOneDimensional(method);
            String message = TestngBundle.message("inspection.data.provider.return.type.check", supportOneDimensional ? "Object[][]/Object[] or Iterator<Object[]>/Iterator<Object>" : "Object[][] or Iterator<Object[]>");
            return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)returnTypeElement, message, isOnTheFly, DataProviderReturnTypeInspection.createFixes(supportOneDimensional, method), ProblemHighlightType.ERROR)};
        }
        return null;
    }

    private static boolean isAppropriateType(PsiType returnType, @NotNull PsiAnnotation annotation) {
        PsiReference[] refs;
        if (annotation == null) {
            DataProviderReturnTypeInspection.$$$reportNull$$$0(2);
        }
        PsiAnnotationMemberValue nameValue = annotation.findAttributeValue("name");
        ArrayList<PsiReference> references = new ArrayList<PsiReference>();
        if (nameValue != null && (refs = nameValue.getReferences()).length != 0) {
            references.addAll(Arrays.asList(refs));
        }
        PsiMethod resolvedMethod = null;
        if (references.size() > 0) {
            for (PsiReference ref : references) {
                PsiElement resolve = ref.resolve();
                if (!(resolve instanceof PsiMethod) || AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiMethod)resolve), (String[])new String[]{TestNGUtil.TEST_ANNOTATION_FQN}) == null) continue;
                resolvedMethod = (PsiMethod)resolve;
            }
        }
        if (resolvedMethod == null) {
            return false;
        }
        PsiParameter[] parameters = resolvedMethod.getParameterList().getParameters();
        ArrayList appropriateTypes = Arrays.stream(parameters).map(PsiParameter::getType).map(PsiType::getDeepComponentType).collect(Collectors.toCollection(ArrayList::new));
        return appropriateTypes.contains(returnType.getDeepComponentType());
    }

    private static LocalQuickFix[] createFixes(boolean supportOneDimensional, @NotNull PsiMethod method) {
        String[] applicableReturnTypes;
        if (method == null) {
            DataProviderReturnTypeInspection.$$$reportNull$$$0(3);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        ArrayList<MethodReturnTypeFix> fixes = new ArrayList<MethodReturnTypeFix>();
        for (String typeText : applicableReturnTypes = supportOneDimensional ? KNOWN_WITH_ONE_DIMENSIONAL_RETURN_TYPES : KNOWN_RETURN_TYPES) {
            fixes.add(new MethodReturnTypeFix(method, elementFactory.createTypeFromText(typeText, (PsiElement)method), false));
        }
        return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    private static boolean isSuitableReturnType(PsiMethod method, @NotNull PsiType type, @NotNull PsiAnnotation annotation) {
        if (type == null) {
            DataProviderReturnTypeInspection.$$$reportNull$$$0(4);
        }
        if (annotation == null) {
            DataProviderReturnTypeInspection.$$$reportNull$$$0(5);
        }
        if (type instanceof PsiArrayType) {
            return DataProviderReturnTypeInspection.isAppropriateTypeArray(method, ((PsiArrayType)type).getComponentType(), annotation);
        }
        if (type instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type).resolveGenerics();
            PsiClass resolvedClass = resolveResult.getElement();
            if (resolvedClass == null || !"java.util.Iterator".equals(resolvedClass.getQualifiedName())) {
                return false;
            }
            Map substitutionMap = resolveResult.getSubstitutor().getSubstitutionMap();
            if (substitutionMap.size() != 1) {
                return false;
            }
            PsiType genericType = (PsiType)ContainerUtil.getFirstItem(substitutionMap.values());
            if (genericType == null) {
                return false;
            }
            return DataProviderReturnTypeInspection.isAppropriateTypeArray(method, genericType, annotation);
        }
        return false;
    }

    private static boolean supportOneDimensional(PsiMethod method) {
        Version version = TestNGUtil.detectVersion(method.getProject(), ModuleUtilCore.findModuleForPsiElement((PsiElement)method));
        return version != null && version.isOrGreaterThan(Integer.valueOf(6), Integer.valueOf(11));
    }

    private static boolean isAppropriateTypeArray(PsiMethod method, @NotNull PsiType type, @NotNull PsiAnnotation annotation) {
        if (type == null) {
            DataProviderReturnTypeInspection.$$$reportNull$$$0(6);
        }
        if (annotation == null) {
            DataProviderReturnTypeInspection.$$$reportNull$$$0(7);
        }
        if (!(type instanceof PsiArrayType)) {
            return DataProviderReturnTypeInspection.supportOneDimensional(method) && (type.equalsToText("java.lang.Object") || DataProviderReturnTypeInspection.isAppropriateType(type, annotation));
        }
        PsiType componentType = type.getDeepComponentType();
        if (!(componentType instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolvedClass = ((PsiClassType)componentType).resolve();
        if (resolvedClass == null) {
            return false;
        }
        return "java.lang.Object".equals(resolvedClass.getQualifiedName()) || DataProviderReturnTypeInspection.isAppropriateType(type, annotation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/theoryinpractice/testng/inspection/DataProviderReturnTypeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAppropriateType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createFixes";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitableReturnType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isAppropriateTypeArray";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

