/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElementVisitor;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeInspectionBase;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YamlRecursivePsiElementVisitor;

@ApiStatus.Internal
public abstract class YamlNonEditableKeysInspectionBase
extends YamlMetaTypeInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
        if (holder == null) {
            YamlNonEditableKeysInspectionBase.$$$reportNull$$$0(0);
        }
        if (metaTypeProvider == null) {
            YamlNonEditableKeysInspectionBase.$$$reportNull$$$0(1);
        }
        return new StructureChecker(holder, metaTypeProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "metaTypeProvider";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/yaml/meta/impl/YamlNonEditableKeysInspectionBase";
        objectArray[2] = "doBuildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class StructureChecker
    extends YamlMetaTypeInspectionBase.SimpleYamlPsiVisitor {
        private final YamlMetaTypeProvider myMetaTypeProvider;
        private final ProblemsHolder myProblemsHolder;
        private final StripNonEditableKeysQuickFix myQuickFix;

        StructureChecker(@NotNull ProblemsHolder problemsHolder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
            if (problemsHolder == null) {
                StructureChecker.$$$reportNull$$$0(0);
            }
            if (metaTypeProvider == null) {
                StructureChecker.$$$reportNull$$$0(1);
            }
            this.myProblemsHolder = problemsHolder;
            this.myMetaTypeProvider = metaTypeProvider;
            this.myQuickFix = new StripNonEditableKeysQuickFix(this.myMetaTypeProvider);
        }

        @Override
        protected void visitYAMLKeyValue(@NotNull YAMLKeyValue keyValue) {
            if (keyValue == null) {
                StructureChecker.$$$reportNull$$$0(2);
            }
            if (keyValue.getKey() == null) {
                return;
            }
            YamlMetaTypeProvider.MetaTypeProxy meta = this.myMetaTypeProvider.getKeyValueMetaType(keyValue);
            if (meta != null && !meta.getField().isEditable()) {
                String msg = YAMLBundle.message("YamlNonEditableKeysInspectionBase.noneditable.key", keyValue.getKeyText());
                this.myProblemsHolder.registerProblem(keyValue.getKey(), msg, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{this.myQuickFix});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemsHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "metaTypeProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyValue";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlNonEditableKeysInspectionBase$StructureChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitYAMLKeyValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class StripNonEditableKeysQuickFix
        implements LocalQuickFix {
            @NotNull
            private final YamlMetaTypeProvider myMetaTypeProvider;

            private StripNonEditableKeysQuickFix(@NotNull YamlMetaTypeProvider provider) {
                if (provider == null) {
                    StripNonEditableKeysQuickFix.$$$reportNull$$$0(0);
                }
                this.myMetaTypeProvider = provider;
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                String string = YAMLBundle.message("YamlNonEditableKeyInspectionBase.strip.noneditable.keys.quickfix.name", new Object[0]);
                if (string == null) {
                    StripNonEditableKeysQuickFix.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    StripNonEditableKeysQuickFix.$$$reportNull$$$0(2);
                }
                if (descriptor == null) {
                    StripNonEditableKeysQuickFix.$$$reportNull$$$0(3);
                }
                final ArrayList keysToDelete = new ArrayList();
                descriptor.getPsiElement().getContainingFile().accept((PsiElementVisitor)new YamlRecursivePsiElementVisitor(){

                    @Override
                    public void visitKeyValue(@NotNull YAMLKeyValue keyValue) {
                        YamlMetaTypeProvider.MetaTypeProxy meta;
                        if (keyValue == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((meta = myMetaTypeProvider.getKeyValueMetaType(keyValue)) != null && !meta.getField().isEditable()) {
                            if (keyValue.getParentMapping() != null) {
                                keysToDelete.add(keyValue);
                            } else {
                                Logger.getInstance(YamlNonEditableKeysInspectionBase.class).warn("Wanted to remove KV, but it does not have a parent mapping");
                            }
                            return;
                        }
                        super.visitKeyValue(keyValue);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyValue", "org/jetbrains/yaml/meta/impl/YamlNonEditableKeysInspectionBase$StructureChecker$StripNonEditableKeysQuickFix$1", "visitKeyValue"));
                    }
                });
                for (YAMLKeyValue keyValue : keysToDelete) {
                    Objects.requireNonNull(keyValue.getParentMapping()).deleteKeyValue(keyValue);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "provider";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/yaml/meta/impl/YamlNonEditableKeysInspectionBase$StructureChecker$StripNonEditableKeysQuickFix";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlNonEditableKeysInspectionBase$StructureChecker$StripNonEditableKeysQuickFix";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

