/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.testFramework.JUnit38AssumeSupportRunner;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.tests.DynamicExtensionPointsTester;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@RunWith(value=JUnit38AssumeSupportRunner.class)
public class _LastInSuiteTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        Disposer.setDebugMode((boolean)true);
    }

    public String getName() {
        return _LastInSuiteTest.getTestName(super.getName());
    }

    private static String getTestName(String name) {
        String buildConf = System.getProperty("teamcity.buildConfName");
        return buildConf == null ? name : name + "[" + buildConf + "]";
    }

    public void testDynamicExtensions() {
        boolean testDynamicExtensions = SystemProperties.getBooleanProperty((String)"intellij.test.all.dynamic.extension.points", (boolean)false);
        Assume.assumeTrue((String)"intellij.test.all.dynamic.extension.points is off, no dynamic extensions to test", (!DynamicExtensionPointsTester.EXTENSION_POINTS_WHITE_LIST.isEmpty() || testDynamicExtensions ? 1 : 0) != 0);
        DynamicExtensionPointsTester.checkDynamicExtensionPoints((Function<? super String, String>)((Function)_LastInSuiteTest::getTestName));
    }

    public void testProjectLeak() {
        if (Boolean.getBoolean("idea.test.guimode")) {
            Application application = ApplicationManager.getApplication();
            application.invokeAndWait(() -> {
                UIUtil.dispatchAllInvocationEvents();
                application.exit(true, true, false);
            });
            ShutDownTracker.getInstance().waitFor(100L, TimeUnit.SECONDS);
            return;
        }
        TestApplicationManagerKt.disposeApplicationAndCheckForLeaks();
    }

    public void testLanguagesHaveDifferentDisplayNames() throws ClassNotFoundException {
        Collection languages = Language.getRegisteredLanguages();
        HashMap<String, Language> displayNames = new HashMap<String, Language>();
        for (Language language : languages) {
            System.out.println(language);
            Language prev = displayNames.put(language.getDisplayName(), language);
            if (prev == null) continue;
            _LastInSuiteTest.fail((String)(prev + " (" + prev.getClass() + ") and " + language + " (" + language.getClass() + ") both have identical display name: " + language.getDisplayName()));
        }
    }

    public void testStatistics() {
        long started = _FirstInSuiteTest.getSuiteStartTime();
        if (started != 0L) {
            long testSuiteDuration = System.nanoTime() - started;
            System.out.printf("##teamcity[buildStatisticValue key='ideaTests.totalTimeMs' value='%d']%n", testSuiteDuration / 1000000L);
        }
        LightPlatformTestCase.reportTestExecutionStatistics();
    }
}

