/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import javax.annotation.Nullable;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.ivy.IvyModuleDescriptor;
import org.gradle.api.internal.artifacts.ComponentSelectionInternal;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.MetadataProvider;

public class DefaultComponentSelection
implements ComponentSelectionInternal {
    private final ModuleComponentIdentifier candidate;
    private final MetadataProvider metadataProvider;
    private boolean rejected;
    private String rejectionReason;

    public DefaultComponentSelection(ModuleComponentIdentifier candidate, MetadataProvider metadataProvider) {
        this.candidate = candidate;
        this.metadataProvider = metadataProvider;
    }

    @Override
    public ModuleComponentIdentifier getCandidate() {
        return this.candidate;
    }

    @Override
    public ComponentMetadata getMetadata() {
        if (this.metadataProvider.isUsable()) {
            return this.metadataProvider.getComponentMetadata();
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T getDescriptor(Class<T> descriptorClass) {
        if (this.metadataProvider.isUsable() && IvyModuleDescriptor.class.isAssignableFrom(descriptorClass)) {
            return descriptorClass.cast(this.metadataProvider.getIvyModuleDescriptor());
        }
        return null;
    }

    @Override
    public void reject(String reason) {
        this.rejected = true;
        this.rejectionReason = reason;
    }

    @Override
    public boolean isRejected() {
        return this.rejected;
    }

    @Override
    public String getRejectionReason() {
        return this.rejectionReason;
    }
}

