/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.GraphValidationException;
import org.gradle.internal.Pair;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.logging.text.TreeFormatter;

public class VersionConflictException
extends GraphValidationException {
    private static final int MAX_SEEN_MODULE_COUNT = 10;
    private final List<Pair<List<? extends ModuleVersionIdentifier>, String>> conflicts;

    public VersionConflictException(String projectPath, String configurationName, Collection<Pair<List<? extends ModuleVersionIdentifier>, String>> conflicts) {
        super(VersionConflictException.buildMessage(projectPath, configurationName, conflicts));
        this.conflicts = ImmutableList.copyOf(conflicts);
    }

    public List<Pair<List<? extends ModuleVersionIdentifier>, String>> getConflicts() {
        return this.conflicts;
    }

    private static String buildMessage(String projectPath, String configurationName, Collection<Pair<List<? extends ModuleVersionIdentifier>, String>> conflicts) {
        TreeFormatter formatter = new TreeFormatter();
        String dependencyNotation = null;
        int count = 0;
        formatter.node("Conflict(s) found for the following module(s)");
        formatter.startChildren();
        for (Pair<List<? extends ModuleVersionIdentifier>, String> allConflict : conflicts) {
            if (count > 10) {
                formatter.node("... and more");
                break;
            }
            formatter.node((String)allConflict.right);
            ++count;
            if (dependencyNotation != null) continue;
            ModuleVersionIdentifier identifier = allConflict.getLeft().get(0);
            dependencyNotation = identifier.getGroup() + ":" + identifier.getName();
        }
        formatter.endChildren();
        VersionConflictException.appendInsight(projectPath, configurationName, formatter, dependencyNotation);
        return formatter.toString();
    }

    private static void appendInsight(String projectPath, String configurationName, TreeFormatter formatter, String dependencyNotation) {
        if (projectPath.equals(":")) {
            projectPath = "";
        }
        formatter.node("Run with:");
        formatter.node("    --scan or");
        formatter.node("    " + projectPath + ":dependencyInsight --configuration " + configurationName + " --dependency " + dependencyNotation);
        formatter.node("to get more insight on how to solve the conflict.");
    }
}

