/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import java.net.URI;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.repositories.UrlArtifactRepository;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.verifier.HttpRedirectVerifier;
import org.gradle.internal.verifier.HttpRedirectVerifierFactory;

public class DefaultUrlArtifactRepository
implements UrlArtifactRepository {
    private Object url;
    private boolean allowInsecureProtocol;
    private final String repositoryType;
    private final FileResolver fileResolver;
    private final Supplier<String> displayNameSupplier;

    DefaultUrlArtifactRepository(FileResolver fileResolver, String repositoryType, Supplier<String> displayNameSupplier) {
        this.fileResolver = fileResolver;
        this.repositoryType = repositoryType;
        this.displayNameSupplier = displayNameSupplier;
    }

    @Override
    public URI getUrl() {
        return this.url == null ? null : this.fileResolver.resolveUri(this.url);
    }

    @Override
    public void setUrl(URI url) {
        this.url = url;
    }

    @Override
    public void setUrl(Object url) {
        this.url = url;
    }

    @Override
    public void setAllowInsecureProtocol(boolean allowInsecureProtocol) {
        this.allowInsecureProtocol = allowInsecureProtocol;
    }

    @Override
    public boolean isAllowInsecureProtocol() {
        return this.allowInsecureProtocol;
    }

    @Nonnull
    public URI validateUrl() {
        URI rootUri = this.getUrl();
        if (rootUri == null) {
            throw new InvalidUserDataException(String.format("You must specify a URL for a %s repository.", this.repositoryType));
        }
        return rootUri;
    }

    private void throwExceptionDueToInsecureProtocol() throws InvalidUserCodeException {
        String switchToAdvice = String.format("Switch %s repository '%s' to redirect to a secure protocol (like HTTPS) or allow insecure protocols. ", this.repositoryType, this.displayNameSupplier.get());
        String dslMessage = Documentation.dslReference(UrlArtifactRepository.class, "allowInsecureProtocol").consultDocumentationMessage() + " ";
        String message2 = "Using insecure protocols with repositories, without explicit opt-in, is unsupported. " + switchToAdvice + dslMessage;
        throw new InvalidUserCodeException(message2);
    }

    private void throwExceptionDueToInsecureRedirect(@Nullable URI redirectFrom, URI redirectLocation) throws InvalidUserCodeException {
        String contextualAdvice = redirectFrom != null ? String.format("'%s' is redirecting to '%s'. ", redirectFrom, redirectLocation) : "";
        String switchToAdvice = String.format("Switch %s repository '%s' to redirect to a secure protocol (like HTTPS) or allow insecure protocols. ", this.repositoryType, this.displayNameSupplier.get());
        String dslMessage = Documentation.dslReference(UrlArtifactRepository.class, "allowInsecureProtocol").consultDocumentationMessage() + " ";
        String message2 = "Redirecting from secure protocol to insecure protocol, without explict opt-in, is unsupported. " + contextualAdvice + switchToAdvice + dslMessage;
        throw new InvalidUserCodeException(message2);
    }

    HttpRedirectVerifier createRedirectVerifier() {
        URI uri = this.getUrl();
        return HttpRedirectVerifierFactory.create(uri, this.allowInsecureProtocol, this::throwExceptionDueToInsecureProtocol, redirection -> this.throwExceptionDueToInsecureRedirect(uri, (URI)redirection));
    }

    public static class Factory {
        private final FileResolver fileResolver;

        @Inject
        public Factory(FileResolver fileResolver) {
            this.fileResolver = fileResolver;
        }

        DefaultUrlArtifactRepository create(String repositoryType, Supplier<String> displayNameSupplier) {
            return new DefaultUrlArtifactRepository(this.fileResolver, repositoryType, displayNameSupplier);
        }
    }
}

