/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.VersionLister;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.ivy.core.IvyPatternHelper;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.ResourceExceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceVersionLister
implements VersionLister {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceVersionLister.class);
    private static final String REVISION_TOKEN = IvyPatternHelper.getTokenString((String)"revision");
    public static final int REV_TOKEN_LENGTH = REVISION_TOKEN.length();
    private final ExternalResourceRepository repository;
    private final String fileSeparator = "/";
    private final Map<ExternalResourceName, List<String>> directoriesToList = new HashMap<ExternalResourceName, List<String>>();

    public ResourceVersionLister(ExternalResourceRepository repository) {
        this.repository = repository;
    }

    @Override
    public void listVersions(ModuleIdentifier module, IvyArtifactName artifact, List<ResourcePattern> patterns, BuildableModuleVersionListingResolveResult result) {
        ArrayList collector = Lists.newArrayList();
        List<ResourcePattern> filteredPatterns = this.filterDuplicates(patterns);
        Map<ResourcePattern, ExternalResourceName> versionListPatterns = filteredPatterns.stream().collect(Collectors.toMap(pattern -> pattern, pattern -> pattern.toVersionListPattern(module, artifact)));
        for (ResourcePattern pattern2 : filteredPatterns) {
            this.visit(pattern2, versionListPatterns, collector, result);
        }
        if (!collector.isEmpty()) {
            result.listed(collector);
        }
    }

    private List<ResourcePattern> filterDuplicates(List<ResourcePattern> patterns) {
        if (patterns.size() <= 1) {
            return patterns;
        }
        ArrayList<ResourcePattern> toRemove = new ArrayList<ResourcePattern>(patterns.size());
        block0: for (int i = 0; i < patterns.size() - 1; ++i) {
            ResourcePattern first = patterns.get(i);
            if (toRemove.contains(first)) continue;
            for (int j = i + 1; j < patterns.size(); ++j) {
                ResourcePattern second = patterns.get(j);
                if (first.getPattern().startsWith(second.getPattern())) {
                    toRemove.add(second);
                    continue;
                }
                if (!second.getPattern().startsWith(first.getPattern())) continue;
                toRemove.add(first);
                continue block0;
            }
        }
        if (toRemove.isEmpty()) {
            return patterns;
        }
        ArrayList<ResourcePattern> result = new ArrayList<ResourcePattern>(patterns);
        result.removeAll(toRemove);
        return result;
    }

    private void visit(ResourcePattern pattern, Map<ResourcePattern, ExternalResourceName> versionListPatterns, List<String> collector, BuildableModuleVersionListingResolveResult result) {
        ExternalResourceName versionListPattern = versionListPatterns.get(pattern);
        LOGGER.debug("Listing all in {}", (Object)versionListPattern);
        try {
            collector.addAll(this.listRevisionToken(versionListPattern, result, versionListPatterns));
        }
        catch (Exception e) {
            throw ResourceExceptions.failure(versionListPattern.getUri(), String.format("Could not list versions using %s.", pattern), e);
        }
    }

    private List<String> listRevisionToken(ExternalResourceName versionListPattern, BuildableModuleVersionListingResolveResult result, Map<ResourcePattern, ExternalResourceName> versionListPatterns) {
        List<String> listedVersions;
        String pattern = versionListPattern.getPath();
        if (!pattern.contains(REVISION_TOKEN)) {
            LOGGER.debug("revision token not defined in pattern {}.", (Object)pattern);
            return Collections.emptyList();
        }
        String prefix = pattern.substring(0, pattern.indexOf(REVISION_TOKEN));
        if (this.revisionMatchesDirectoryName(pattern)) {
            ExternalResourceName parent = versionListPattern.getRoot().resolve(prefix);
            listedVersions = this.listAll(parent, result);
        } else {
            int parentFolderSlashIndex = prefix.lastIndexOf("/");
            String revisionParentFolder = parentFolderSlashIndex == -1 ? "" : prefix.substring(0, parentFolderSlashIndex + 1);
            ExternalResourceName parent = versionListPattern.getRoot().resolve(revisionParentFolder);
            LOGGER.debug("using {} to list all in {} ", (Object)this.repository, (Object)revisionParentFolder);
            result.attempted(parent);
            List<String> all = this.listWithCache(parent);
            if (all == null) {
                return Collections.emptyList();
            }
            LOGGER.debug("found {} urls", (Object)all.size());
            Pattern regexPattern = this.createRegexPattern(pattern, parentFolderSlashIndex);
            listedVersions = this.filterMatchedValues(all, regexPattern);
            LOGGER.debug("{} matched {}", (Object)listedVersions.size(), (Object)pattern);
        }
        if (versionListPatterns.size() > 1) {
            return this.filterOutMatchesWithOverlappingPatterns(listedVersions, versionListPattern, versionListPatterns.values());
        }
        return listedVersions;
    }

    private List<String> filterOutMatchesWithOverlappingPatterns(List<String> listedVersions, ExternalResourceName currentVersionListPattern, Collection<ExternalResourceName> versionListPatterns) {
        ArrayList remaining = Lists.newArrayList(listedVersions);
        for (ExternalResourceName otherVersionListPattern : versionListPatterns) {
            if (otherVersionListPattern == currentVersionListPattern) continue;
            String patternPath = otherVersionListPattern.getPath();
            Pattern regexPattern = this.toControlRegexPattern(patternPath);
            List matching = listedVersions.stream().filter(version -> regexPattern.matcher(currentVersionListPattern.getPath().replace(REVISION_TOKEN, (CharSequence)version)).matches()).collect(Collectors.toList());
            if (matching.isEmpty()) continue;
            LOGGER.debug("Filtered out {} from results for overlapping match with {}", matching, (Object)otherVersionListPattern);
            remaining.removeAll(matching);
        }
        return remaining;
    }

    private List<String> filterMatchedValues(List<String> all, Pattern p) {
        ArrayList<String> ret = new ArrayList<String>(all.size());
        for (String path : all) {
            Matcher m = p.matcher(path);
            if (!m.matches()) continue;
            String value = m.group(1);
            ret.add(value);
        }
        return ret;
    }

    private Pattern createRegexPattern(String pattern, int prefixLastSlashIndex) {
        int endNameIndex = pattern.indexOf("/", prefixLastSlashIndex + 1);
        String namePattern = endNameIndex != -1 ? pattern.substring(prefixLastSlashIndex + 1, endNameIndex) : pattern.substring(prefixLastSlashIndex + 1);
        namePattern = namePattern.replaceAll("\\.", "\\\\.");
        String acceptNamePattern = namePattern.replaceAll("\\[revision]", "(.+)");
        return Pattern.compile(acceptNamePattern);
    }

    private Pattern toControlRegexPattern(String pattern) {
        pattern = pattern.replaceAll("\\.", "\\\\.");
        String acceptNamePattern = pattern.replaceFirst("\\[revision]", "(.+)").replaceAll("\\[revision]", "\u0001");
        return Pattern.compile(acceptNamePattern);
    }

    private boolean revisionMatchesDirectoryName(String pattern) {
        int startToken = pattern.indexOf(REVISION_TOKEN);
        if (startToken > 0 && !pattern.startsWith("/", startToken - 1)) {
            return false;
        }
        int endToken = startToken + REV_TOKEN_LENGTH;
        return endToken >= pattern.length() || pattern.startsWith("/", endToken);
    }

    private List<String> listAll(ExternalResourceName parent, BuildableModuleVersionListingResolveResult result) {
        LOGGER.debug("using {} to list all in {}", (Object)this.repository, (Object)parent);
        result.attempted(parent.toString());
        List<String> paths = this.listWithCache(parent);
        if (paths == null) {
            return Collections.emptyList();
        }
        LOGGER.debug("found {} resources", (Object)paths.size());
        return paths;
    }

    @Nullable
    private List<String> listWithCache(ExternalResourceName parent) {
        if (this.directoriesToList.containsKey(parent)) {
            return this.directoriesToList.get(parent);
        }
        List<String> result = this.repository.resource(parent).list();
        this.directoriesToList.put(parent, result);
        return result;
    }
}

