/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.FilePropertyContainer;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.DefaultTaskInputFilePropertyRegistration;
import org.gradle.api.internal.tasks.DefaultTaskInputPropertyRegistration;
import org.gradle.api.internal.tasks.PropertyFileCollection;
import org.gradle.api.internal.tasks.StaticValue;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskInputFilePropertyBuilderInternal;
import org.gradle.api.internal.tasks.TaskInputFilePropertyRegistration;
import org.gradle.api.internal.tasks.TaskInputPropertyRegistration;
import org.gradle.api.internal.tasks.TaskInputsDeprecationSupport;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.properties.FileParameterUtils;
import org.gradle.api.internal.tasks.properties.GetInputFilesVisitor;
import org.gradle.api.internal.tasks.properties.GetInputPropertiesVisitor;
import org.gradle.api.internal.tasks.properties.InputFilePropertyType;
import org.gradle.api.internal.tasks.properties.InputParameterUtils;
import org.gradle.api.internal.tasks.properties.InputPropertySpec;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.api.tasks.TaskInputPropertyBuilder;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

@NonNullApi
public class DefaultTaskInputs
implements TaskInputsInternal {
    private final FileCollection allInputFiles;
    private final FileCollection allSourceFiles;
    private final TaskInternal task;
    private final TaskMutator taskMutator;
    private final PropertyWalker propertyWalker;
    private final FileCollectionFactory fileCollectionFactory;
    private final List<TaskInputPropertyRegistration> registeredProperties = Lists.newArrayList();
    private final FilePropertyContainer<TaskInputFilePropertyRegistration> registeredFileProperties = FilePropertyContainer.create();
    private final TaskInputs deprecatedThis;

    public DefaultTaskInputs(TaskInternal task, TaskMutator taskMutator, PropertyWalker propertyWalker, FileCollectionFactory fileCollectionFactory) {
        this.task = task;
        this.taskMutator = taskMutator;
        this.propertyWalker = propertyWalker;
        this.fileCollectionFactory = fileCollectionFactory;
        String taskDisplayName = task.toString();
        this.allInputFiles = new TaskInputUnionFileCollection(taskDisplayName, "input", false, task, propertyWalker, fileCollectionFactory);
        this.allSourceFiles = new TaskInputUnionFileCollection(taskDisplayName, "source", true, task, propertyWalker, fileCollectionFactory);
        this.deprecatedThis = new TaskInputsDeprecationSupport();
    }

    @Override
    public boolean getHasInputs() {
        HasInputsVisitor visitor = new HasInputsVisitor();
        TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, visitor);
        return visitor.hasInputs();
    }

    @Override
    public void visitRegisteredProperties(PropertyVisitor visitor) {
        for (TaskInputFilePropertyRegistration taskInputFilePropertyRegistration : this.registeredFileProperties) {
            visitor.visitInputFileProperty(taskInputFilePropertyRegistration.getPropertyName(), taskInputFilePropertyRegistration.isOptional(), taskInputFilePropertyRegistration.isSkipWhenEmpty(), taskInputFilePropertyRegistration.getDirectorySensitivity(), false, taskInputFilePropertyRegistration.getNormalizer(), taskInputFilePropertyRegistration.getValue(), taskInputFilePropertyRegistration.getFilePropertyType());
        }
        for (TaskInputPropertyRegistration taskInputPropertyRegistration : this.registeredProperties) {
            visitor.visitInputProperty(taskInputPropertyRegistration.getPropertyName(), taskInputPropertyRegistration.getValue(), taskInputPropertyRegistration.isOptional());
        }
    }

    @Override
    public FileCollection getFiles() {
        return this.allInputFiles;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal files(final Object ... paths) {
        return this.taskMutator.mutate("TaskInputs.files(Object...)", new Callable<TaskInputFilePropertyBuilderInternal>(){

            @Override
            public TaskInputFilePropertyBuilderInternal call() {
                StaticValue value = new StaticValue(DefaultTaskInputs.unpackVarargs(paths));
                DefaultTaskInputFilePropertyRegistration registration = new DefaultTaskInputFilePropertyRegistration(value, InputFilePropertyType.FILES);
                DefaultTaskInputs.this.registeredFileProperties.add(registration);
                return registration;
            }
        });
    }

    private static Object unpackVarargs(Object[] args) {
        if (args.length == 1) {
            return args[0];
        }
        return args;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal file(final Object path) {
        return this.taskMutator.mutate("TaskInputs.file(Object)", new Callable<TaskInputFilePropertyBuilderInternal>(){

            @Override
            public TaskInputFilePropertyBuilderInternal call() {
                StaticValue value = new StaticValue(path);
                DefaultTaskInputFilePropertyRegistration registration = new DefaultTaskInputFilePropertyRegistration(value, InputFilePropertyType.FILE);
                DefaultTaskInputs.this.registeredFileProperties.add(registration);
                return registration;
            }
        });
    }

    @Override
    public TaskInputFilePropertyBuilderInternal dir(final Object dirPath) {
        return this.taskMutator.mutate("TaskInputs.dir(Object)", new Callable<TaskInputFilePropertyBuilderInternal>(){

            @Override
            public TaskInputFilePropertyBuilderInternal call() {
                StaticValue value = new StaticValue(dirPath);
                DefaultTaskInputFilePropertyRegistration registration = new DefaultTaskInputFilePropertyRegistration(value, InputFilePropertyType.DIRECTORY);
                DefaultTaskInputs.this.registeredFileProperties.add(registration);
                return registration;
            }
        });
    }

    @Override
    public boolean getHasSourceFiles() {
        GetInputFilesVisitor visitor = new GetInputFilesVisitor(this.task.toString(), this.fileCollectionFactory);
        TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, visitor);
        return visitor.hasSourceFiles();
    }

    @Override
    public FileCollection getSourceFiles() {
        return this.allSourceFiles;
    }

    @Override
    public Map<String, Object> getProperties() {
        GetInputPropertiesVisitor visitor = new GetInputPropertiesVisitor();
        TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, visitor);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (InputPropertySpec inputProperty : visitor.getProperties()) {
            result.put(inputProperty.getPropertyName(), InputParameterUtils.prepareInputParameterValue(inputProperty, this.task));
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public TaskInputPropertyBuilder property(final String name, final @Nullable Object value) {
        return this.taskMutator.mutate("TaskInputs.property(String, Object)", new Callable<TaskInputPropertyBuilder>(){

            @Override
            public TaskInputPropertyBuilder call() {
                StaticValue staticValue = new StaticValue(value);
                DefaultTaskInputPropertyRegistration registration = new DefaultTaskInputPropertyRegistration(name, staticValue);
                DefaultTaskInputs.this.registeredProperties.add(registration);
                return registration;
            }
        });
    }

    @Override
    public TaskInputs properties(final Map<String, ?> newProps) {
        this.taskMutator.mutate("TaskInputs.properties(Map)", new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : newProps.entrySet()) {
                    StaticValue staticValue = new StaticValue(entry.getValue());
                    String name = (String)entry.getKey();
                    DefaultTaskInputs.this.registeredProperties.add(new DefaultTaskInputPropertyRegistration(name, staticValue));
                }
            }
        });
        return this.deprecatedThis;
    }

    @Override
    public void visitDependencies(final TaskDependencyResolveContext context) {
        TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, new PropertyVisitor.Adapter(){

            @Override
            public void visitInputProperty(String propertyName, PropertyValue value, boolean optional) {
                context.add(value.getTaskDependencies());
            }

            @Override
            public void visitInputFileProperty(String propertyName, boolean optional, boolean skipWhenEmpty, DirectorySensitivity directorySensitivity, boolean incremental, @Nullable Class<? extends FileNormalizer> fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
                FileCollectionInternal actualValue = FileParameterUtils.resolveInputFileValue(DefaultTaskInputs.this.fileCollectionFactory, filePropertyType, value);
                context.add(actualValue);
            }
        });
    }

    private static class HasInputsVisitor
    extends PropertyVisitor.Adapter {
        private boolean hasInputs;

        private HasInputsVisitor() {
        }

        public boolean hasInputs() {
            return this.hasInputs;
        }

        @Override
        public void visitInputFileProperty(String propertyName, boolean optional, boolean skipWhenEmpty, DirectorySensitivity directorySensitivity, boolean incremental, @Nullable Class<? extends FileNormalizer> fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
            this.hasInputs = true;
        }

        @Override
        public void visitInputProperty(String propertyName, PropertyValue value, boolean optional) {
            this.hasInputs = true;
        }
    }

    private static class TaskInputUnionFileCollection
    extends CompositeFileCollection
    implements Describable {
        private final boolean skipWhenEmptyOnly;
        private final String taskDisplayName;
        private final String type;
        private final TaskInternal task;
        private final PropertyWalker propertyWalker;
        private final FileCollectionFactory fileCollectionFactory;

        TaskInputUnionFileCollection(String taskDisplayName, String type, boolean skipWhenEmptyOnly, TaskInternal task, PropertyWalker propertyWalker, FileCollectionFactory fileCollectionFactory) {
            this.taskDisplayName = taskDisplayName;
            this.type = type;
            this.skipWhenEmptyOnly = skipWhenEmptyOnly;
            this.task = task;
            this.propertyWalker = propertyWalker;
            this.fileCollectionFactory = fileCollectionFactory;
        }

        @Override
        public String getDisplayName() {
            return this.taskDisplayName + " " + this.type + " files";
        }

        @Override
        protected void visitChildren(final Consumer<FileCollectionInternal> visitor) {
            TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, new PropertyVisitor.Adapter(){

                @Override
                public void visitInputFileProperty(String propertyName, boolean optional, boolean skipWhenEmpty, DirectorySensitivity directorySensitivity, boolean incremental, @Nullable Class<? extends FileNormalizer> fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
                    if (!skipWhenEmptyOnly || skipWhenEmpty) {
                        FileCollectionInternal actualValue = FileParameterUtils.resolveInputFileValue(fileCollectionFactory, filePropertyType, value);
                        visitor.accept(new PropertyFileCollection(task.toString(), propertyName, "input", actualValue));
                    }
                }
            });
        }
    }
}

