/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.util.internal.RelativePathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class CompilationSourceDirs {
    private static final Logger LOG = LoggerFactory.getLogger(CompilationSourceDirs.class);
    private final List<File> sourceRoots;

    public CompilationSourceDirs(JavaCompileSpec spec) {
        File generatedSourcesDirectory;
        this.sourceRoots = new ArrayList<File>(spec.getSourceRoots());
        File headerOutputDirectory = spec.getCompileOptions().getHeaderOutputDirectory();
        if (headerOutputDirectory != null) {
            this.sourceRoots.add(headerOutputDirectory);
        }
        if ((generatedSourcesDirectory = spec.getCompileOptions().getAnnotationProcessorGeneratedSourcesDirectory()) != null) {
            this.sourceRoots.add(generatedSourcesDirectory);
        }
    }

    @VisibleForTesting
    CompilationSourceDirs(List<File> sourceRoots) {
        this.sourceRoots = sourceRoots;
    }

    public static List<File> inferSourceRoots(FileTreeInternal sources) {
        SourceRoots visitor = new SourceRoots();
        sources.visitStructure(visitor);
        return visitor.canInferSourceRoots ? visitor.sourceRoots : Collections.emptyList();
    }

    public Optional<String> relativize(File sourceFile) {
        return this.sourceRoots.stream().filter(sourceDir -> sourceFile.getAbsolutePath().startsWith(sourceDir.getAbsolutePath())).map(sourceDir -> RelativePathUtil.relativePath(sourceDir, sourceFile)).filter(relativePath -> !relativePath.startsWith("..")).findFirst();
    }

    private static class SourceRoots
    implements FileCollectionStructureVisitor {
        private boolean canInferSourceRoots = true;
        private List<File> sourceRoots = Lists.newArrayList();

        private SourceRoots() {
        }

        @Override
        public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
            this.cannotInferSourceRoots(contents);
        }

        @Override
        public void visitGenericFileTree(FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
            this.cannotInferSourceRoots(fileTree);
        }

        @Override
        public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
            this.cannotInferSourceRoots(fileTree);
        }

        @Override
        public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
            if (!root.exists() || root.isDirectory()) {
                this.sourceRoots.add(root);
            } else {
                this.cannotInferSourceRoots("file '" + root + "'");
            }
        }

        private void cannotInferSourceRoots(Object fileCollection) {
            this.canInferSourceRoots = false;
            LOG.info("Cannot infer source root(s) for source `{}`. Supported types are `File` (directories only), `DirectoryTree` and `SourceDirectorySet`.", fileCollection);
        }
    }
}

