/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.DefaultNestedBuild;
import org.gradle.composite.internal.DefaultRootBuildState;
import org.gradle.composite.internal.RootOfNestedBuildTree;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.build.BuildLifecycleControllerFactory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.session.CrossBuildSessionState;
import org.gradle.util.Path;

@ServiceScope(value=Scopes.BuildTree.class)
public class BuildStateFactory {
    private final BuildTreeState buildTreeState;
    private final BuildLifecycleControllerFactory buildLifecycleControllerFactory;
    private final ListenerManager listenerManager;
    private final GradleUserHomeScopeServiceRegistry userHomeDirServiceRegistry;
    private final CrossBuildSessionState crossBuildSessionState;
    private final BuildCancellationToken buildCancellationToken;
    private final ProjectStateRegistry projectStateRegistry;

    public BuildStateFactory(BuildTreeState buildTreeState, BuildLifecycleControllerFactory buildLifecycleControllerFactory, ListenerManager listenerManager, GradleUserHomeScopeServiceRegistry userHomeDirServiceRegistry, CrossBuildSessionState crossBuildSessionState, BuildCancellationToken buildCancellationToken, ProjectStateRegistry projectStateRegistry) {
        this.buildTreeState = buildTreeState;
        this.buildLifecycleControllerFactory = buildLifecycleControllerFactory;
        this.listenerManager = listenerManager;
        this.userHomeDirServiceRegistry = userHomeDirServiceRegistry;
        this.crossBuildSessionState = crossBuildSessionState;
        this.buildCancellationToken = buildCancellationToken;
        this.projectStateRegistry = projectStateRegistry;
    }

    public RootBuildState createRootBuild(BuildDefinition buildDefinition) {
        return new DefaultRootBuildState(buildDefinition, this.buildTreeState, this.buildLifecycleControllerFactory, this.listenerManager, this.projectStateRegistry);
    }

    public StandAloneNestedBuild createNestedBuild(BuildIdentifier buildIdentifier, Path identityPath, BuildDefinition buildDefinition, BuildState owner) {
        return new DefaultNestedBuild(buildIdentifier, identityPath, buildDefinition, owner, this.buildTreeState, this.buildLifecycleControllerFactory, this.projectStateRegistry);
    }

    public RootOfNestedBuildTree createNestedTree(BuildDefinition buildDefinition, BuildIdentifier buildIdentifier, Path identityPath, BuildState owner) {
        return new RootOfNestedBuildTree(buildDefinition, buildIdentifier, identityPath, owner, this.userHomeDirServiceRegistry, this.crossBuildSessionState, this.buildCancellationToken);
    }
}

