/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal.plugins;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.gradle.composite.internal.plugins.LocalPluginResolution;
import org.gradle.internal.build.BuildIncluder;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.plugin.management.internal.InvalidPluginRequestException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginResolverContributor;

public class CompositeBuildPluginResolverContributor
implements PluginResolverContributor {
    private static final String SOURCE_DESCRIPTION = "Included Builds";
    private final PluginResolver resolver;

    public CompositeBuildPluginResolverContributor(BuildStateRegistry buildRegistry, BuildState consumingBuild, BuildIncluder buildIncluder) {
        this.resolver = new CompositeBuildPluginResolver(buildRegistry, consumingBuild, buildIncluder);
    }

    @Override
    public void collectResolversInto(Collection<PluginResolver> resolvers) {
        resolvers.add(this.resolver);
    }

    private static class CompositeBuildPluginResolver
    implements PluginResolver {
        private final BuildStateRegistry buildRegistry;
        private final BuildState consumingBuild;
        private final BuildIncluder buildIncluder;
        private final Map<PluginId, PluginResolution> results = new HashMap<PluginId, PluginResolution>();

        private CompositeBuildPluginResolver(BuildStateRegistry buildRegistry, BuildState consumingBuild, BuildIncluder buildIncluder) {
            this.buildRegistry = buildRegistry;
            this.consumingBuild = consumingBuild;
            this.buildIncluder = buildIncluder;
        }

        @Override
        public void resolve(PluginRequestInternal pluginRequest, PluginResolutionResult result) throws InvalidPluginRequestException {
            PluginResolution earlyResolution = this.resolveFromIncludedPluginBuilds(pluginRequest.getId());
            if (earlyResolution != null) {
                result.found(CompositeBuildPluginResolverContributor.SOURCE_DESCRIPTION, earlyResolution);
            }
            if (this.buildRegistry.getIncludedBuilds().isEmpty()) {
                return;
            }
            PluginResolution resolution = this.results.computeIfAbsent(pluginRequest.getId(), this::resolvePluginFromIncludedBuilds);
            if (resolution != null) {
                result.found(CompositeBuildPluginResolverContributor.SOURCE_DESCRIPTION, resolution);
            } else {
                result.notFound(CompositeBuildPluginResolverContributor.SOURCE_DESCRIPTION, "None of the included builds contain this plugin");
            }
        }

        private PluginResolution resolvePluginFromIncludedBuilds(PluginId requestedPluginId) {
            for (IncludedBuildState includedBuildState : this.buildRegistry.getIncludedBuilds()) {
                Optional pluginResolution;
                if (includedBuildState == this.consumingBuild || includedBuildState.isImplicitBuild() || includedBuildState.isPluginBuild() || !(pluginResolution = includedBuildState.withState(gradleInternal -> LocalPluginResolution.resolvePlugin(gradleInternal, requestedPluginId))).isPresent()) continue;
                return (PluginResolution)pluginResolution.get();
            }
            return null;
        }

        private PluginResolution resolveFromIncludedPluginBuilds(PluginId requestedPluginId) {
            for (IncludedBuildState build : this.buildIncluder.includeRegisteredPluginBuilds()) {
                this.buildRegistry.ensureConfigured(build);
                Optional pluginResolution = build.withState(gradleInternal -> LocalPluginResolution.resolvePlugin(gradleInternal, requestedPluginId));
                if (!pluginResolution.isPresent()) continue;
                return (PluginResolution)pluginResolution.get();
            }
            return null;
        }
    }
}

