/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.Collection;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.execution.BuildExecutionAction;
import org.gradle.execution.BuildExecutionContext;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;

public class DryRunBuildExecutionAction
implements BuildExecutionAction {
    private final StyledTextOutputFactory textOutputFactory;

    public DryRunBuildExecutionAction(StyledTextOutputFactory textOutputFactory) {
        this.textOutputFactory = textOutputFactory;
    }

    @Override
    public void execute(BuildExecutionContext context, Collection<? super Throwable> taskFailures) {
        GradleInternal gradle = context.getGradle();
        if (gradle.getStartParameter().isDryRun()) {
            for (Task task : gradle.getTaskGraph().getAllTasks()) {
                this.textOutputFactory.create(DryRunBuildExecutionAction.class).append(((TaskInternal)task).getIdentityPath().getPath()).append(" ").style(StyledTextOutput.Style.ProgressStatus).append("SKIPPED").println();
            }
        } else {
            context.proceed();
        }
    }
}

