/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import java.util.stream.Stream;
import org.gradle.api.Describable;
import org.gradle.internal.execution.history.changes.ChangeContainer;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.execution.history.changes.DescriptiveChange;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class PropertyChanges
implements ChangeContainer {
    private final ImmutableSortedSet<String> previous;
    private final ImmutableSortedSet<String> current;
    private final String title;
    private final Describable executable;

    public PropertyChanges(ImmutableSortedSet<String> previous, ImmutableSortedSet<String> current, String title, Describable executable) {
        this.previous = previous;
        this.current = current;
        this.title = title;
        this.executable = executable;
    }

    @Override
    public boolean accept(ChangeVisitor visitor) {
        if (this.previous.equals(this.current)) {
            return true;
        }
        Stream<DescriptiveChange> removedProperties = Sets.difference(this.previous, this.current).stream().map(removedProperty -> new DescriptiveChange("%s property '%s' has been removed for %s", this.title, removedProperty, this.executable.getDisplayName()));
        Stream<DescriptiveChange> addedProperties = Sets.difference(this.current, this.previous).stream().map(addedProperty -> new DescriptiveChange("%s property '%s' has been added for %s", this.title, addedProperty, this.executable.getDisplayName()));
        return Stream.concat(removedProperties, addedProperties).map(visitor::visitChange).filter(shouldContinue -> shouldContinue == false).findFirst().orElse(true);
    }
}

