/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.aws.s3;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.credentials.AwsCredentials;
import org.gradle.authentication.Authentication;
import org.gradle.authentication.aws.AwsImAuthentication;
import org.gradle.internal.authentication.AllSchemesAuthentication;
import org.gradle.internal.resource.connector.ResourceConnectorFactory;
import org.gradle.internal.resource.connector.ResourceConnectorSpecification;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transport.aws.s3.S3Client;
import org.gradle.internal.resource.transport.aws.s3.S3ConnectionProperties;
import org.gradle.internal.resource.transport.aws.s3.S3ResourceConnector;

public class S3ConnectorFactory
implements ResourceConnectorFactory {
    @Override
    public Set<String> getSupportedProtocols() {
        return Collections.singleton("s3");
    }

    @Override
    public Set<Class<? extends Authentication>> getSupportedAuthentication() {
        HashSet<Class<? extends Authentication>> supported = new HashSet<Class<? extends Authentication>>();
        supported.add(AwsImAuthentication.class);
        supported.add(AllSchemesAuthentication.class);
        return supported;
    }

    @Override
    public ExternalResourceConnector createResourceConnector(ResourceConnectorSpecification connectionDetails) {
        Collection<Authentication> authentications = connectionDetails.getAuthentications();
        for (Authentication authentication : authentications) {
            if (authentication instanceof AllSchemesAuthentication) {
                AwsCredentials awsCredentials = connectionDetails.getCredentials(AwsCredentials.class);
                if (awsCredentials == null) {
                    throw new IllegalArgumentException("AwsCredentials must be set for S3 backed repository.");
                }
                return new S3ResourceConnector(new S3Client(awsCredentials, new S3ConnectionProperties()));
            }
            if (!(authentication instanceof AwsImAuthentication)) continue;
            return new S3ResourceConnector(new S3Client(new S3ConnectionProperties()));
        }
        throw new IllegalArgumentException("S3 resource should either specify AwsImAuthentication or provide some AwsCredentials.");
    }
}

