/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.util.function.Predicate;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.internal.JavaToolchain;

public class ToolchainMatcher
implements Predicate<JavaToolchain> {
    private final JavaToolchainSpec filter;

    public ToolchainMatcher(JavaToolchainSpec filter) {
        this.filter = filter;
    }

    @Override
    public boolean test(JavaToolchain toolchain) {
        return this.languagePredicate().and(this.vendorPredicate()).and(this.implementationPredicate()).test(toolchain);
    }

    private Predicate<JavaToolchain> languagePredicate() {
        return toolchain -> toolchain.getLanguageVersion().equals(this.filter.getLanguageVersion().get());
    }

    private Predicate<? super JavaToolchain> implementationPredicate() {
        return toolchain -> {
            boolean isJ9Vm = toolchain.getMetadata().hasCapability(JvmInstallationMetadata.JavaInstallationCapability.J9_VIRTUAL_MACHINE);
            boolean j9Requested = this.filter.getImplementation().get() == JvmImplementation.J9;
            return j9Requested == isJ9Vm;
        };
    }

    private Predicate<? super JavaToolchain> vendorPredicate() {
        return (Predicate)this.filter.getVendor().get();
    }
}

