/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.internal;

import java.util.Collections;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.internal.Cast;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.nativeplatform.internal.ComponentWithNames;
import org.gradle.language.nativeplatform.internal.DefaultNativeComponent;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.swift.SwiftBinary;
import org.gradle.language.swift.SwiftComponent;
import org.gradle.language.swift.SwiftVersion;
import org.gradle.nativeplatform.TargetMachine;

public abstract class DefaultSwiftComponent<T extends SwiftBinary>
extends DefaultNativeComponent
implements SwiftComponent,
ComponentWithNames {
    private final DefaultBinaryCollection<T> binaries;
    private final FileCollection swiftSource;
    private final Property<String> module;
    private final String name;
    private final Names names;
    private final Property<SwiftVersion> sourceCompatibility;
    private final SetProperty<TargetMachine> targetMachines;

    public DefaultSwiftComponent(String name, ObjectFactory objectFactory) {
        this(name, SwiftBinary.class, objectFactory);
    }

    public DefaultSwiftComponent(String name, Class<? extends SwiftBinary> binaryType, ObjectFactory objectFactory) {
        super(objectFactory);
        this.name = name;
        this.swiftSource = this.createSourceView("src/" + name + "/swift", Collections.singletonList("swift"));
        this.module = objectFactory.property(String.class);
        this.sourceCompatibility = objectFactory.property(SwiftVersion.class);
        this.names = Names.of(name);
        this.binaries = (DefaultBinaryCollection)Cast.uncheckedCast(objectFactory.newInstance(DefaultBinaryCollection.class, binaryType));
        this.targetMachines = objectFactory.setProperty(TargetMachine.class);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Names getNames() {
        return this.names;
    }

    @Override
    public Property<String> getModule() {
        return this.module;
    }

    @Override
    public FileCollection getSwiftSource() {
        return this.swiftSource;
    }

    public DefaultBinaryCollection<T> getBinaries() {
        return this.binaries;
    }

    @Override
    public Property<SwiftVersion> getSourceCompatibility() {
        return this.sourceCompatibility;
    }

    @Override
    public SetProperty<TargetMachine> getTargetMachines() {
        return this.targetMachines;
    }
}

