/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.remote.internal.Connection;
import org.gradle.internal.remote.internal.MessageIOException;
import org.gradle.internal.remote.internal.RemoteConnection;
import org.gradle.launcher.daemon.client.DaemonConnectionException;
import org.gradle.launcher.daemon.client.StaleDaemonAddressException;
import org.gradle.launcher.daemon.context.DaemonConnectDetails;
import org.gradle.launcher.daemon.protocol.Message;

public class DaemonClientConnection
implements Connection<Message> {
    private static final Logger LOG = Logging.getLogger(DaemonClientConnection.class);
    private final RemoteConnection<Message> connection;
    private final DaemonConnectDetails daemon;
    private final StaleAddressDetector staleAddressDetector;
    private boolean hasReceived;
    private final Lock dispatchLock = new ReentrantLock();

    public DaemonClientConnection(RemoteConnection<Message> connection, DaemonConnectDetails daemon, StaleAddressDetector staleAddressDetector) {
        this.connection = connection;
        this.daemon = daemon;
        this.staleAddressDetector = staleAddressDetector;
    }

    public DaemonConnectDetails getDaemon() {
        return this.daemon;
    }

    @Override
    public void dispatch(Message message2) throws DaemonConnectionException {
        LOG.debug("thread {}: dispatching {}", Thread.currentThread().getId(), message2.getClass());
        try {
            this.dispatchLock.lock();
            try {
                this.connection.dispatch(message2);
                this.connection.flush();
            }
            finally {
                this.dispatchLock.unlock();
            }
        }
        catch (MessageIOException e) {
            LOG.debug("Problem dispatching message to the daemon. Performing 'on failure' operation...");
            if (!this.hasReceived && this.staleAddressDetector.maybeStaleAddress(e)) {
                throw new StaleDaemonAddressException("Could not dispatch a message to the daemon.", e);
            }
            throw new DaemonConnectionException("Could not dispatch a message to the daemon.", e);
        }
    }

    @Override
    @Nullable
    public Message receive() throws DaemonConnectionException {
        try {
            Message message2 = this.connection.receive();
            return message2;
        }
        catch (MessageIOException e) {
            LOG.debug("Problem receiving message to the daemon. Performing 'on failure' operation...");
            if (!this.hasReceived && this.staleAddressDetector.maybeStaleAddress(e)) {
                throw new StaleDaemonAddressException("Could not receive a message from the daemon.", e);
            }
            throw new DaemonConnectionException("Could not receive a message from the daemon.", e);
        }
        finally {
            this.hasReceived = true;
        }
    }

    @Override
    public void stop() {
        LOG.debug("thread {}: connection stop", Thread.currentThread().getId());
        this.connection.stop();
    }

    static interface StaleAddressDetector {
        public boolean maybeStaleAddress(Exception var1);
    }
}

