/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.util.Collection;
import java.util.Date;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;

public class NotMostRecentlyUsedDaemonExpirationStrategy
implements DaemonExpirationStrategy {
    private final Daemon daemon;
    public static final String EXPIRATION_REASON = "not recently used";

    NotMostRecentlyUsedDaemonExpirationStrategy(Daemon daemon) {
        this.daemon = daemon;
    }

    @Override
    public DaemonExpirationResult checkExpiration() {
        if (!this.isMostRecentlyUsed(this.daemon.getDaemonRegistry().getIdle(), this.daemon.getDaemonContext())) {
            return new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, EXPIRATION_REASON);
        }
        return DaemonExpirationResult.NOT_TRIGGERED;
    }

    private boolean isMostRecentlyUsed(Collection<DaemonInfo> daemonInfos, DaemonContext thisDaemonContext) {
        String mruUid = null;
        Date mruTimestamp = new Date(Long.MIN_VALUE);
        for (DaemonInfo daemonInfo : daemonInfos) {
            Date daemonAccessTime = daemonInfo.getLastBusy();
            if (!daemonAccessTime.after(mruTimestamp)) continue;
            mruUid = daemonInfo.getUid();
            mruTimestamp = daemonAccessTime;
        }
        return thisDaemonContext.getUid().equals(mruUid);
    }
}

