/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.logging.LoggingBuildOperationProgressBroadcaster;
import org.gradle.internal.operations.notify.BuildOperationNotificationValve;
import org.gradle.internal.session.BuildSessionActionExecutor;
import org.gradle.internal.session.BuildSessionContext;
import org.gradle.launcher.exec.RunBuildBuildOperationType;

public class RunAsBuildOperationBuildActionExecutor
implements BuildSessionActionExecutor {
    private static final RunBuildBuildOperationType.Details DETAILS = new RunBuildBuildOperationType.Details(){};
    private static final RunBuildBuildOperationType.Result RESULT = new RunBuildBuildOperationType.Result(){};
    private final BuildSessionActionExecutor delegate;
    private final BuildOperationExecutor buildOperationExecutor;
    private final LoggingBuildOperationProgressBroadcaster loggingBuildOperationProgressBroadcaster;
    private final BuildOperationNotificationValve buildOperationNotificationValve;

    public RunAsBuildOperationBuildActionExecutor(BuildSessionActionExecutor delegate, BuildOperationExecutor buildOperationExecutor, LoggingBuildOperationProgressBroadcaster loggingBuildOperationProgressBroadcaster, BuildOperationNotificationValve buildOperationNotificationValve) {
        this.delegate = delegate;
        this.buildOperationExecutor = buildOperationExecutor;
        this.loggingBuildOperationProgressBroadcaster = loggingBuildOperationProgressBroadcaster;
        this.buildOperationNotificationValve = buildOperationNotificationValve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildActionRunner.Result execute(final BuildAction action, final BuildSessionContext context) {
        this.buildOperationNotificationValve.start();
        try {
            BuildActionRunner.Result result = this.buildOperationExecutor.call(new CallableBuildOperation<BuildActionRunner.Result>(){

                @Override
                public BuildActionRunner.Result call(BuildOperationContext buildOperationContext) {
                    RunAsBuildOperationBuildActionExecutor.this.loggingBuildOperationProgressBroadcaster.rootBuildOperationStarted();
                    BuildActionRunner.Result result = RunAsBuildOperationBuildActionExecutor.this.delegate.execute(action, context);
                    buildOperationContext.setResult(RESULT);
                    if (result.getBuildFailure() != null) {
                        buildOperationContext.failed(result.getBuildFailure());
                    }
                    return result;
                }

                @Override
                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName("Run build").details(DETAILS);
                }
            });
            return result;
        }
        finally {
            this.buildOperationNotificationValve.stop();
        }
    }
}

