/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.Action;
import org.gradle.internal.Actions;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.type.ModelType;

@ThreadSafe
public class InstanceModelView<T>
implements ModelView<T> {
    private final ModelPath path;
    private final ModelType<T> type;
    private final T instance;
    private final Action<? super T> onClose;

    public InstanceModelView(ModelPath path, ModelType<T> type, T instance, Action<? super T> onClose) {
        this.path = path;
        this.type = type;
        this.instance = instance;
        this.onClose = onClose;
    }

    public static <T> ModelView<T> of(ModelPath path, ModelType<T> type, T instance) {
        return InstanceModelView.of(path, type, instance, Actions.doNothing());
    }

    public static <T> ModelView<T> of(ModelPath path, ModelType<T> type, T instance, Action<? super T> onClose) {
        return new InstanceModelView<T>(path, type, instance, onClose);
    }

    @Override
    public ModelPath getPath() {
        return this.path;
    }

    @Override
    public ModelType<T> getType() {
        return this.type;
    }

    @Override
    public T getInstance() {
        return this.instance;
    }

    @Override
    public void close() {
        this.onClose.execute(this.instance);
    }
}

