/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import groovy.lang.GroovyObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.internal.impldep.com.google.common.base.Equivalence;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.Multimaps;
import org.gradle.internal.impldep.com.google.common.collect.Ordering;
import org.gradle.internal.reflect.GroovyMethods;
import org.gradle.internal.reflect.Methods;
import org.gradle.internal.reflect.Types;
import org.gradle.model.Managed;
import org.gradle.model.internal.manage.schema.extract.CandidateMethods;

public class ModelSchemaUtils {
    public static final List<Class<?>> IGNORED_OBJECT_TYPES = ImmutableList.of(Object.class, GroovyObject.class);

    public static <T> CandidateMethods getCandidateMethods(Class<T> clazz) {
        final ImmutableListMultimap.Builder methodsByNameBuilder = ImmutableListMultimap.builder();
        Types.walkTypeHierarchy(clazz, IGNORED_OBJECT_TYPES, new Types.TypeVisitor<T>(){

            @Override
            public void visitType(Class<? super T> type) {
                Method[] declaredMethods = type.getDeclaredMethods();
                Arrays.sort(declaredMethods, Ordering.usingToString());
                for (Method method : declaredMethods) {
                    if (ModelSchemaUtils.isIgnoredMethod(method)) continue;
                    methodsByNameBuilder.put((Object)method.getName(), (Object)method);
                }
            }
        });
        ImmutableListMultimap methodsByName = methodsByNameBuilder.build();
        ImmutableSortedMap.Builder candidatesBuilder = ImmutableSortedMap.naturalOrder();
        for (String methodName : methodsByName.keySet()) {
            ImmutableList methodsWithSameName = methodsByName.get((Object)methodName);
            ImmutableListMultimap equivalenceIndex = Multimaps.index((Iterable)methodsWithSameName, (Function)new Function<Method, Equivalence.Wrapper<Method>>(){

                public Equivalence.Wrapper<Method> apply(Method method) {
                    return Methods.SIGNATURE_EQUIVALENCE.wrap((Object)method);
                }
            });
            candidatesBuilder.put((Object)methodName, (Object)equivalenceIndex.asMap());
        }
        return new CandidateMethods((Map<String, Map<Equivalence.Wrapper<Method>, Collection<Method>>>)candidatesBuilder.build());
    }

    private static boolean isIgnoredMethod(Method method) {
        int modifiers = method.getModifiers();
        if (method.isSynthetic() || Modifier.isStatic(modifiers)) {
            return true;
        }
        return GroovyMethods.isObjectMethod(method);
    }

    public static Method findMostSpecificMethod(Iterable<Method> declaringMethods) {
        for (Method method : declaringMethods) {
            if (Proxy.isProxyClass(method.getDeclaringClass())) continue;
            return method;
        }
        throw new IllegalArgumentException("Cannot find most-specific declaration of method. Declarations checked: " + declaringMethods);
    }

    public static boolean isMethodDeclaredInManagedType(Iterable<Method> declarations) {
        Method mostSpecificDeclaration = ModelSchemaUtils.findMostSpecificMethod(declarations);
        return ModelSchemaUtils.isMethodDeclaredInManagedType(mostSpecificDeclaration);
    }

    public static boolean isMethodDeclaredInManagedType(Method method) {
        return method.getDeclaringClass().isAnnotationPresent(Managed.class);
    }
}

