/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.ConfigEncodingManager;
import org.editorconfig.configmanagement.EditorConfigEncodingCache;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigOption;
import org.editorconfig.language.psi.EditorConfigSection;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;

public class EditorConfigStatusListener
implements CodeStyleSettingsListener,
Disposable {
    private boolean myEnabledStatus;
    private final VirtualFile myVirtualFile;
    private final Project myProject;
    private Set<String> myEncodings;
    private MyReloadTask myReloadTask;

    public EditorConfigStatusListener(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myEnabledStatus = Utils.isEnabled(project);
        this.myVirtualFile = virtualFile;
        this.myEncodings = this.extractEncodings();
        CodeStyleSettingsManager.getInstance((Project)project).addListener((CodeStyleSettingsListener)this);
    }

    public final void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        Set<String> newEncodings;
        CodeStyleSettings settings;
        if (event == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(2);
        }
        if ((settings = CodeStyle.getSettings((Project)this.myProject)).getCustomSettingsIfCreated(EditorConfigSettings.class) == null) {
            return;
        }
        boolean newEnabledStatus = Utils.isEnabled(this.myProject);
        if (this.myEnabledStatus != newEnabledStatus) {
            this.myEnabledStatus = newEnabledStatus;
            this.onEditorConfigEnabled(newEnabledStatus);
        }
        if (!this.myEncodings.equals(newEncodings = this.extractEncodings())) {
            if (EditorConfigStatusListener.containsValidEncodings(newEncodings)) {
                this.onEncodingChanged();
            }
            this.myEncodings = newEncodings;
        }
    }

    private void onEditorConfigEnabled(boolean isEnabled) {
        if (!isEnabled) {
            FileEditorManager.getInstance((Project)this.myProject).closeFile(this.myVirtualFile);
            FileEditorManager.getInstance((Project)this.myProject).openFile(this.myVirtualFile, false);
        }
        EditorNotifications.getInstance((Project)this.myProject).updateNotifications(this.myVirtualFile);
        ObjectUtils.consumeIfNotNull((Object)FileDocumentManager.getInstance().getDocument(this.myVirtualFile), document -> ObjectUtils.consumeIfNotNull((Object)PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document), psiFile -> DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(psiFile)));
    }

    public void dispose() {
        CodeStyleSettingsManager.removeListener((Project)this.myProject, (CodeStyleSettingsListener)this);
    }

    private void onEncodingChanged() {
        if (this.myReloadTask != null) {
            this.myReloadTask.interrupt();
        }
        MyReloadTask reloadTask = new MyReloadTask();
        ProgressManager.getInstance().run((Task)reloadTask);
        this.myReloadTask = reloadTask;
    }

    private static boolean containsValidEncodings(@NotNull Set<String> encodings) {
        if (encodings == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(3);
        }
        return ContainerUtil.and(encodings, encoding -> ConfigEncodingManager.toCharset(encoding) != null);
    }

    @NotNull
    private Set<String> extractEncodings() {
        final HashSet<String> charsets = new HashSet<String>();
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myVirtualFile);
        if (psiFile != null) {
            PsiRecursiveElementVisitor visitor2 = new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    String charsetStr;
                    String keyName;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element instanceof PsiFile || element instanceof EditorConfigSection) {
                        super.visitElement(element);
                    } else if (element instanceof EditorConfigOption && "charset".equals(keyName = (String)ObjectUtils.doIfNotNull((Object)((EditorConfigOption)element).getFlatOptionKey(), NavigationItem::getName)) && (charsetStr = (String)ObjectUtils.doIfNotNull((Object)((EditorConfigOption)element).getOptionValueIdentifier(), NavigationItem::getName)) != null) {
                        charsets.add(charsetStr);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/editorconfig/configmanagement/editor/EditorConfigStatusListener$1", "visitElement"));
                }
            };
            psiFile.accept((PsiElementVisitor)visitor2);
        }
        HashSet<String> hashSet = charsets;
        if (hashSet == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encodings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/editor/EditorConfigStatusListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/editor/EditorConfigStatusListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "extractEncodings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "codeStyleSettingsChanged";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsValidEncodings";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyReloadTask
    extends Task.Backgroundable {
        private volatile boolean myInterrupted;

        private MyReloadTask() {
            super(EditorConfigStatusListener.this.myProject, EditorConfigBundle.message("encoding.change.reloading.files"), false);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyReloadTask.$$$reportNull$$$0(0);
            }
            EditorConfigEncodingCache.getInstance().reset();
            final ArrayList filesToReload = new ArrayList();
            VirtualFile parentDir = EditorConfigStatusListener.this.myVirtualFile.getParent();
            final FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            VfsUtilCore.visitChildrenRecursively((VirtualFile)parentDir, (VirtualFileVisitor)new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (MyReloadTask.this.myInterrupted) {
                        throw new ProcessCanceledException();
                    }
                    if (!file.isDirectory() && !".editorconfig".equals(file.getName()) && fileDocumentManager.getCachedDocument(file) != null) {
                        filesToReload.add(file);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/editorconfig/configmanagement/editor/EditorConfigStatusListener$MyReloadTask$1", "visitFile"));
                }
            });
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myProject != null) {
                    filesToReload.forEach(file -> EditorConfigEncodingCache.getInstance().cacheEncoding(this.myProject, (VirtualFile)file));
                }
                fileDocumentManager.reloadFiles(filesToReload.toArray(VirtualFile.EMPTY_ARRAY));
            });
        }

        void interrupt() {
            this.myInterrupted = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/editorconfig/configmanagement/editor/EditorConfigStatusListener$MyReloadTask", "run"));
        }
    }
}

