/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IconUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.XmlDomBundle;
import com.intellij.util.xml.highlighting.DomCollectionProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.ui.AbstractTableView;
import com.intellij.util.xml.ui.CommitListener;
import com.intellij.util.xml.ui.DomEditorManager;
import com.intellij.util.xml.ui.DomTableView;
import com.intellij.util.xml.ui.DomUIControl;
import com.intellij.util.xml.ui.Highlightable;
import com.intellij.util.xml.ui.actions.AddDomElementAction;
import com.intellij.util.xml.ui.actions.DefaultAddAction;
import java.awt.Container;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomCollectionControl<T extends DomElement>
extends DomUIControl
implements Highlightable,
DataProvider {
    private static final DataKey<DomCollectionControl> DOM_COLLECTION_CONTROL = DataKey.create((String)"DomCollectionControl");
    private final EventDispatcher<CommitListener> myDispatcher;
    private DomTableView myCollectionPanel;
    private final DomElement myParentDomElement;
    private final DomCollectionChildDescription myChildDescription;
    private List<T> myCollectionElements;
    private ColumnInfo<T, ?>[] myColumnInfos;
    private boolean myEditable;

    public DomCollectionControl(@NotNull DomElement parentElement, @NotNull DomCollectionChildDescription description, boolean editable, ColumnInfo<T, ?> ... columnInfos) {
        if (parentElement == null) {
            DomCollectionControl.$$$reportNull$$$0(0);
        }
        if (description == null) {
            DomCollectionControl.$$$reportNull$$$0(1);
        }
        this.myDispatcher = EventDispatcher.create(CommitListener.class);
        this.myCollectionElements = new ArrayList<T>();
        this.myEditable = false;
        this.myChildDescription = description;
        this.myParentDomElement = parentElement;
        this.myColumnInfos = columnInfos;
        this.myEditable = editable;
    }

    public DomCollectionControl(DomElement parentElement, @NonNls String subTagName, boolean editable, ColumnInfo<T, ?> ... columnInfos) {
        this(parentElement, Objects.requireNonNull(parentElement.getGenericInfo().getCollectionChildDescription(subTagName)), editable, columnInfos);
    }

    public DomCollectionControl(@NotNull DomElement parentElement, @NotNull DomCollectionChildDescription description) {
        if (parentElement == null) {
            DomCollectionControl.$$$reportNull$$$0(2);
        }
        if (description == null) {
            DomCollectionControl.$$$reportNull$$$0(3);
        }
        this.myDispatcher = EventDispatcher.create(CommitListener.class);
        this.myCollectionElements = new ArrayList<T>();
        this.myEditable = false;
        this.myChildDescription = description;
        this.myParentDomElement = parentElement;
    }

    public DomCollectionControl(@NotNull DomElement parentElement, @NotNull @NonNls String subTagName) {
        if (parentElement == null) {
            DomCollectionControl.$$$reportNull$$$0(4);
        }
        if (subTagName == null) {
            DomCollectionControl.$$$reportNull$$$0(5);
        }
        this(parentElement, Objects.requireNonNull(parentElement.getGenericInfo().getCollectionChildDescription(subTagName)));
    }

    public boolean isEditable() {
        return this.myEditable;
    }

    @Override
    public void bind(JComponent component) {
        assert (component instanceof DomTableView);
        this.initialize((DomTableView)component);
    }

    @Override
    public void addCommitListener(CommitListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void removeCommitListener(CommitListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    @Override
    public boolean canNavigate(DomElement element) {
        Class aClass = ReflectionUtil.getRawType((Type)this.myChildDescription.getType());
        Object domElement = element.getParentOfType(aClass, false);
        return domElement != null && this.myCollectionElements.contains(domElement);
    }

    @Override
    public void navigate(DomElement element) {
        Class aClass = ReflectionUtil.getRawType((Type)this.myChildDescription.getType());
        Object domElement = element.getParentOfType(aClass, false);
        int index = this.myCollectionElements.indexOf(domElement);
        if (index < 0) {
            index = 0;
        }
        this.myCollectionPanel.getTable().setRowSelectionInterval(index, index);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            DomCollectionControl.$$$reportNull$$$0(6);
        }
        if (DOM_COLLECTION_CONTROL.is(dataId)) {
            return this;
        }
        return null;
    }

    @Nullable
    @NonNls
    protected String getHelpId() {
        return null;
    }

    @Nullable
    @Nls
    protected String getEmptyPaneText() {
        return null;
    }

    protected void initialize(DomTableView boundComponent) {
        this.myCollectionPanel = boundComponent == null ? new DomTableView(this.getProject(), this.getEmptyPaneText(), this.getHelpId()) : boundComponent;
        this.myCollectionPanel.setToolbarActions(new AddAction(), new EditAction(), new RemoveAction());
        this.myCollectionPanel.installPopup("J2EEAttributesViewPopup", this.createPopupActionGroup());
        this.myCollectionPanel.initializeTable();
        this.myCollectionPanel.addCustomDataProvider(this);
        this.myCollectionPanel.addChangeListener(new AbstractTableView.ChangeListener(){

            @Override
            public void changed() {
                DomCollectionControl.this.reset();
            }
        });
        this.reset();
    }

    protected DefaultActionGroup createPopupActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.addAll((ActionGroup)((DefaultActionGroup)ActionManager.getInstance().getAction("DomCollectionControl")));
        return group;
    }

    protected ColumnInfo[] createColumnInfos(DomElement parent) {
        return this.myColumnInfos;
    }

    protected int sortAdjustedIndex(int index) {
        return this.myCollectionPanel.getTable().convertRowIndexToModel(index);
    }

    protected final void doEdit() {
        this.doEdit((DomElement)this.myCollectionElements.get(this.sortAdjustedIndex(this.myCollectionPanel.getTable().getSelectedRow())));
    }

    protected void doEdit(T t) {
        DomEditorManager manager = DomCollectionControl.getDomEditorManager(this);
        if (manager != null) {
            manager.openDomElementEditor((DomElement)t);
        }
    }

    protected void doRemove(List<? extends T> toDelete) {
        HashSet files = new HashSet();
        for (DomElement t : toDelete) {
            XmlElement element = t.getXmlElement();
            if (element == null) continue;
            ContainerUtil.addIfNotNull(files, (Object)element.getContainingFile());
        }
        WriteCommandAction.writeCommandAction((Project)this.getProject(), (PsiFile[])PsiUtilCore.toPsiFileArray(files)).run(() -> {
            for (DomElement t : toDelete) {
                if (!t.isValid()) continue;
                t.undefine();
            }
        });
    }

    protected final void doRemove() {
        ApplicationManager.getApplication().invokeLater(() -> {
            int[] selected = this.myCollectionPanel.getTable().getSelectedRows();
            if (selected == null || selected.length == 0) {
                return;
            }
            ArrayList<DomElement> selectedElements = new ArrayList<DomElement>(selected.length);
            for (int i : selected) {
                selectedElements.add((DomElement)this.myCollectionElements.get(this.sortAdjustedIndex(i)));
            }
            this.doRemove(selectedElements);
            this.reset();
            int selection = selected[0];
            if (selection >= this.myCollectionElements.size()) {
                selection = this.myCollectionElements.size() - 1;
            }
            if (selection >= 0) {
                this.myCollectionPanel.getTable().setRowSelectionInterval(selection, selection);
            }
        });
    }

    @Override
    public void commit() {
        CommitListener listener = (CommitListener)this.myDispatcher.getMulticaster();
        listener.beforeCommit(this);
        listener.afterCommit(this);
        this.validate();
    }

    private void validate() {
        DomElement domElement = this.getDomElement();
        List<DomElementProblemDescriptor> list = DomElementAnnotationsManager.getInstance(this.getProject()).getCachedProblemHolder(domElement).getProblems(domElement);
        ArrayList<@InspectionMessage String> messages = new ArrayList<String>();
        for (DomElementProblemDescriptor descriptor : list) {
            if (!(descriptor instanceof DomCollectionProblemDescriptor) || !this.myChildDescription.equals(((DomCollectionProblemDescriptor)descriptor).getChildDescription())) continue;
            messages.add(descriptor.getDescriptionTemplate());
        }
        this.myCollectionPanel.setErrorMessages(ArrayUtilRt.toStringArray(messages));
        this.myCollectionPanel.repaint();
    }

    public void dispose() {
        if (this.myCollectionPanel != null) {
            this.myCollectionPanel.dispose();
        }
    }

    protected final Project getProject() {
        return this.myParentDomElement.getManager().getProject();
    }

    @Override
    public DomTableView getComponent() {
        if (this.myCollectionPanel == null) {
            this.initialize(null);
        }
        return this.myCollectionPanel;
    }

    public final DomCollectionChildDescription getChildDescription() {
        return this.myChildDescription;
    }

    public final DomElement getDomElement() {
        return this.myParentDomElement;
    }

    @Override
    public final void reset() {
        this.myCollectionElements = new ArrayList<T>(this.getCollectionElements());
        this.myCollectionPanel.reset(this.createColumnInfos(this.myParentDomElement), this.myCollectionElements);
        this.validate();
    }

    public List<T> getCollectionElements() {
        return this.myChildDescription.getValues(this.myParentDomElement);
    }

    protected AnAction @Nullable [] createAdditionActions() {
        return null;
    }

    protected DefaultAddAction createDefaultAction(@NlsActions.ActionText String name, Icon icon, final Type type) {
        return new ControlAddAction(name, name, icon){

            @Override
            protected Type getElementType() {
                return type;
            }
        };
    }

    @Nullable
    private static DomEditorManager getDomEditorManager(DomUIControl control) {
        JComponent component = control.getComponent();
        while (component != null && !(component instanceof DomEditorManager)) {
            Container parent = component.getParent();
            if (!(parent instanceof JComponent)) {
                return null;
            }
            component = (JComponent)parent;
        }
        return (DomEditorManager)((Object)component);
    }

    @Override
    public void updateHighlighting() {
        if (this.myCollectionPanel != null) {
            this.myCollectionPanel.revalidate();
            this.myCollectionPanel.repaint();
        }
    }

    public static DomCollectionControl getDomCollectionControl(AnActionEvent e) {
        return (DomCollectionControl)e.getData(DOM_COLLECTION_CONTROL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subTagName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/xml/ui/DomCollectionControl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RemoveAction
    extends AnAction {
        public RemoveAction() {
            super(XmlDomBundle.message("dom.action.remove", new Object[0]), null, IconUtil.getRemoveIcon());
            this.setShortcutSet(CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.REMOVE));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveAction.$$$reportNull$$$0(0);
            }
            DomCollectionControl control = DomCollectionControl.getDomCollectionControl(e);
            control.doRemove();
            control.reset();
        }

        public void update(@NotNull AnActionEvent e) {
            JTable table;
            DomCollectionControl control;
            if (e == null) {
                RemoveAction.$$$reportNull$$$0(1);
            }
            boolean enabled = (control = DomCollectionControl.getDomCollectionControl(e)) != null ? (table = control.getComponent().getTable()) != null && table.getSelectedRowCount() > 0 : false;
            e.getPresentation().setEnabled(enabled);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/util/xml/ui/DomCollectionControl$RemoveAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class EditAction
    extends AnAction {
        public EditAction() {
            super(XmlDomBundle.message("dom.action.edit", new Object[0]), null, IconUtil.getEditIcon());
            this.setShortcutSet(CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.EDIT));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditAction.$$$reportNull$$$0(0);
            }
            DomCollectionControl control = DomCollectionControl.getDomCollectionControl(e);
            control.doEdit();
            control.reset();
        }

        public void update(@NotNull AnActionEvent e) {
            DomCollectionControl control;
            if (e == null) {
                EditAction.$$$reportNull$$$0(1);
            }
            boolean visible = (control = DomCollectionControl.getDomCollectionControl(e)) != null && control.isEditable();
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && control.getComponent().getTable().getSelectedRowCount() == 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/util/xml/ui/DomCollectionControl$EditAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddAction
    extends AddDomElementAction {
        public AddAction() {
            this.setShortcutSet(CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD));
        }

        @Override
        protected boolean isEnabled(AnActionEvent e) {
            return this.getDomCollectionControl(e) != null;
        }

        protected DomCollectionControl getDomCollectionControl(AnActionEvent e) {
            return DomCollectionControl.getDomCollectionControl(e);
        }

        @Override
        protected DomCollectionChildDescription @NotNull [] getDomCollectionChildDescriptions(AnActionEvent e) {
            DomCollectionChildDescription[] domCollectionChildDescriptionArray = new DomCollectionChildDescription[]{this.getDomCollectionControl(e).getChildDescription()};
            if (domCollectionChildDescriptionArray == null) {
                AddAction.$$$reportNull$$$0(0);
            }
            return domCollectionChildDescriptionArray;
        }

        @Override
        protected DomElement getParentDomElement(AnActionEvent e) {
            return this.getDomCollectionControl(e).getDomElement();
        }

        @Override
        protected JComponent getComponent(AnActionEvent e) {
            return this.getDomCollectionControl(e).getComponent();
        }

        @Override
        public AnAction @NotNull [] getChildren(AnActionEvent e) {
            DomCollectionControl control = this.getDomCollectionControl(e);
            AnAction[] actions = control.createAdditionActions();
            AnAction[] anActionArray = actions == null ? super.getChildren(e) : actions;
            if (anActionArray == null) {
                AddAction.$$$reportNull$$$0(1);
            }
            return anActionArray;
        }

        @Override
        protected DefaultAddAction createAddingAction(AnActionEvent e, @NlsActions.ActionText String name, Icon icon, Type type, DomCollectionChildDescription description) {
            return this.getDomCollectionControl(e).createDefaultAction(name, icon, type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/util/xml/ui/DomCollectionControl$AddAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDomCollectionChildDescriptions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public class ControlAddAction
    extends DefaultAddAction<T> {
        public ControlAddAction() {
        }

        public ControlAddAction(String text) {
            super(text);
        }

        public ControlAddAction(@NlsActions.ActionDescription String text, String description, Icon icon) {
            super(text, description, icon);
        }

        @Override
        protected final DomCollectionChildDescription getDomCollectionChildDescription() {
            return DomCollectionControl.this.myChildDescription;
        }

        @Override
        protected final DomElement getParentDomElement() {
            return DomCollectionControl.this.myParentDomElement;
        }

        protected int getColumnToEditAfterAddition() {
            return 0;
        }

        protected void afterAddition(JTable table, int rowIndex) {
            table.setRowSelectionInterval(rowIndex, rowIndex);
            int column = this.getColumnToEditAfterAddition();
            if (column >= 0) {
                table.editCellAt(rowIndex, column);
            }
        }

        @Override
        protected final void afterAddition(@NotNull T newElement) {
            if (newElement == null) {
                ControlAddAction.$$$reportNull$$$0(0);
            }
            DomCollectionControl.this.reset();
            this.afterAddition(DomCollectionControl.this.myCollectionPanel.getTable(), DomCollectionControl.this.myCollectionElements.size() - 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/util/xml/ui/DomCollectionControl$ControlAddAction", "afterAddition"));
        }
    }
}

