/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.spell;

import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.word.HeuristicWordTokenizer;
import ai.grazie.spell.Speller;
import ai.grazie.spell.dictionary.RuleDictionary;
import ai.grazie.spell.language.English;
import ai.grazie.spell.lists.WordListWithFrequency;
import ai.grazie.spell.suggestion.filter.SuggestionFilter;
import ai.grazie.spell.suggestion.ranker.SuggestionRanker;
import ai.grazie.spell.utils.UtilsKt;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0016J$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lai/grazie/spell/GrazieSpeller;", "Lai/grazie/spell/Speller;", "config", "Lai/grazie/spell/GrazieSpeller$UserConfig;", "(Lai/grazie/spell/GrazieSpeller$UserConfig;)V", "isAlien", "", "word", "", "isMisspelled", "caseSensitive", "suggestAndRank", "", "", "max", "", "UserConfig", "gec-spell-local-engine"})
public final class GrazieSpeller
implements Speller {
    private final UserConfig config;

    @Override
    public boolean isMisspelled(@NotNull String word, boolean caseSensitive) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return this.config.getDictionary().getRules().check(word) != RuleDictionary.Result.CORRECT && !this.config.getDictionary().getDictionary().contains(word, caseSensitive);
    }

    @Override
    public boolean isAlien(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return (Boolean)this.config.getDictionary().isAlien().invoke((Object)word);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Double> suggestAndRank(@NotNull String word, int max) {
        Map.Entry $this$associateWithTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (!Speller.DefaultImpls.isMisspelled$default(this, word, false, 2, null)) {
            return MapsKt.emptyMap();
        }
        HashMap<void, Double> result2 = new HashMap<void, Double>();
        if (this.config.getDictionary().getRules().check(word) == RuleDictionary.Result.INCORRECT) {
            Map map2;
            void $this$associateWith$iv;
            Iterable iterable = this.config.getDictionary().getRules().suggest(word);
            HashMap<void, Double> hashMap = result2;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            Iterator iterator = $this$associateWithTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                String string = (String)element$iv$iv;
                Object t = element$iv$iv;
                map2 = result$iv;
                boolean bl = false;
                Double d = 1.0;
                map2.put(t, d);
            }
            map2 = result$iv;
            hashMap.putAll(map2);
        }
        LinkedHashSet<String> suggested = this.config.getDictionary().getDictionary().suggest(word);
        Map<String, Double> ranked = this.config.getModel().getRanker().score(word, suggested);
        Map<String, Double> filtered2 = this.config.getModel().getFilter().filter(ranked);
        Object $this$sortedByDescending$iv = filtered2.entrySet();
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        Iterator $i$f$associateWithTo = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a2, T b2) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)b2;
                boolean bl2 = false;
                Comparable comparable = (Double)it.getValue();
                it = (Map.Entry)a2;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = (Double)it.getValue();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        }).iterator();
        while ($i$f$associateWithTo.hasNext()) {
            void key;
            Map.Entry entry = $this$associateWithTo$iv$iv = (Map.Entry)$i$f$associateWithTo.next();
            boolean bl2 = false;
            $this$sortedByDescending$iv = (String)entry.getKey();
            entry = $this$associateWithTo$iv$iv;
            bl2 = false;
            double value = ((Number)entry.getValue()).doubleValue();
            result2.putIfAbsent(key, value);
        }
        Set set = result2.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"result.entries");
        Iterable $this$sortedByDescending$iv2 = set;
        boolean $i$f$sortedByDescending2 = false;
        boolean bl3 = false;
        return UtilsKt.toMap(CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator<T>(){

            public final int compare(T a2, T b2) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)b2;
                boolean bl2 = false;
                Comparable comparable = (Double)it.getValue();
                it = (Map.Entry)a2;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = (Double)it.getValue();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        }), (int)max));
    }

    public GrazieSpeller(@NotNull UserConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    public /* synthetic */ GrazieSpeller(UserConfig userConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            userConfig = new UserConfig(null, null, 3, null);
        }
        this(userConfig);
    }

    public GrazieSpeller() {
        this(null, 1, null);
    }

    @Override
    @NotNull
    public LinkedHashSet<String> suggest(@NotNull String word, int max) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return Speller.DefaultImpls.suggest(this, word, max);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lai/grazie/spell/GrazieSpeller$UserConfig;", "", "dictionary", "Lai/grazie/spell/GrazieSpeller$UserConfig$Dictionary;", "model", "Lai/grazie/spell/GrazieSpeller$UserConfig$Model;", "(Lai/grazie/spell/GrazieSpeller$UserConfig$Dictionary;Lai/grazie/spell/GrazieSpeller$UserConfig$Model;)V", "getDictionary", "()Lai/grazie/spell/GrazieSpeller$UserConfig$Dictionary;", "getModel", "()Lai/grazie/spell/GrazieSpeller$UserConfig$Model;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Dictionary", "Model", "gec-spell-local-engine"})
    public static final class UserConfig {
        @NotNull
        private final Dictionary dictionary;
        @NotNull
        private final Model model;

        @NotNull
        public final Dictionary getDictionary() {
            return this.dictionary;
        }

        @NotNull
        public final Model getModel() {
            return this.model;
        }

        public UserConfig(@NotNull Dictionary dictionary, @NotNull Model model) {
            Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            this.dictionary = dictionary;
            this.model = model;
        }

        public /* synthetic */ UserConfig(Dictionary dictionary, Model model, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                dictionary = new Dictionary(null, null, null, null, 15, null);
            }
            if ((n & 2) != 0) {
                model = new Model(null, null, 3, null);
            }
            this(dictionary, model);
        }

        public UserConfig() {
            this(null, null, 3, null);
        }

        @NotNull
        public final Dictionary component1() {
            return this.dictionary;
        }

        @NotNull
        public final Model component2() {
            return this.model;
        }

        @NotNull
        public final UserConfig copy(@NotNull Dictionary dictionary, @NotNull Model model) {
            Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return new UserConfig(dictionary, model);
        }

        public static /* synthetic */ UserConfig copy$default(UserConfig userConfig, Dictionary dictionary, Model model, int n, Object object) {
            if ((n & 1) != 0) {
                dictionary = userConfig.dictionary;
            }
            if ((n & 2) != 0) {
                model = userConfig.model;
            }
            return userConfig.copy(dictionary, model);
        }

        @NotNull
        public String toString() {
            return "UserConfig(dictionary=" + this.dictionary + ", model=" + this.model + ")";
        }

        public int hashCode() {
            Dictionary dictionary = this.dictionary;
            Model model = this.model;
            return (dictionary != null ? ((Object)dictionary).hashCode() : 0) * 31 + (model != null ? ((Object)model).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof UserConfig)) break block3;
                    UserConfig userConfig = (UserConfig)object;
                    if (!Intrinsics.areEqual((Object)this.dictionary, (Object)userConfig.dictionary) || !Intrinsics.areEqual((Object)this.model, (Object)userConfig.model)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lai/grazie/spell/GrazieSpeller$UserConfig$Model;", "", "filter", "Lai/grazie/spell/suggestion/filter/SuggestionFilter;", "ranker", "Lai/grazie/spell/suggestion/ranker/SuggestionRanker;", "(Lai/grazie/spell/suggestion/filter/SuggestionFilter;Lai/grazie/spell/suggestion/ranker/SuggestionRanker;)V", "getFilter", "()Lai/grazie/spell/suggestion/filter/SuggestionFilter;", "getRanker", "()Lai/grazie/spell/suggestion/ranker/SuggestionRanker;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "gec-spell-local-engine"})
        public static final class Model {
            @NotNull
            private final SuggestionFilter filter;
            @NotNull
            private final SuggestionRanker ranker;

            @NotNull
            public final SuggestionFilter getFilter() {
                return this.filter;
            }

            @NotNull
            public final SuggestionRanker getRanker() {
                return this.ranker;
            }

            public Model(@NotNull SuggestionFilter filter2, @NotNull SuggestionRanker ranker) {
                Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
                Intrinsics.checkNotNullParameter((Object)ranker, (String)"ranker");
                this.filter = filter2;
                this.ranker = ranker;
            }

            public /* synthetic */ Model(SuggestionFilter suggestionFilter, SuggestionRanker suggestionRanker, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    suggestionFilter = English.Filter.INSTANCE.getSpeller();
                }
                if ((n & 2) != 0) {
                    suggestionRanker = English.Ranker.INSTANCE.getSpeller();
                }
                this(suggestionFilter, suggestionRanker);
            }

            public Model() {
                this(null, null, 3, null);
            }

            @NotNull
            public final SuggestionFilter component1() {
                return this.filter;
            }

            @NotNull
            public final SuggestionRanker component2() {
                return this.ranker;
            }

            @NotNull
            public final Model copy(@NotNull SuggestionFilter filter2, @NotNull SuggestionRanker ranker) {
                Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
                Intrinsics.checkNotNullParameter((Object)ranker, (String)"ranker");
                return new Model(filter2, ranker);
            }

            public static /* synthetic */ Model copy$default(Model model, SuggestionFilter suggestionFilter, SuggestionRanker suggestionRanker, int n, Object object) {
                if ((n & 1) != 0) {
                    suggestionFilter = model.filter;
                }
                if ((n & 2) != 0) {
                    suggestionRanker = model.ranker;
                }
                return model.copy(suggestionFilter, suggestionRanker);
            }

            @NotNull
            public String toString() {
                return "Model(filter=" + this.filter + ", ranker=" + this.ranker + ")";
            }

            public int hashCode() {
                SuggestionFilter suggestionFilter = this.filter;
                SuggestionRanker suggestionRanker = this.ranker;
                return (suggestionFilter != null ? suggestionFilter.hashCode() : 0) * 31 + (suggestionRanker != null ? suggestionRanker.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Model)) break block3;
                        Model model = (Model)object;
                        if (!Intrinsics.areEqual((Object)this.filter, (Object)model.filter) || !Intrinsics.areEqual((Object)this.ranker, (Object)model.ranker)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u000bH\u00c6\u0003J?\u0010\u0018\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lai/grazie/spell/GrazieSpeller$UserConfig$Dictionary;", "", "tokenizer", "Lai/grazie/nlp/tokenizer/Tokenizer;", "dictionary", "Lai/grazie/spell/lists/WordListWithFrequency;", "isAlien", "Lkotlin/Function1;", "", "", "rules", "Lai/grazie/spell/dictionary/RuleDictionary;", "(Lai/grazie/nlp/tokenizer/Tokenizer;Lai/grazie/spell/lists/WordListWithFrequency;Lkotlin/jvm/functions/Function1;Lai/grazie/spell/dictionary/RuleDictionary;)V", "getDictionary", "()Lai/grazie/spell/lists/WordListWithFrequency;", "()Lkotlin/jvm/functions/Function1;", "getRules", "()Lai/grazie/spell/dictionary/RuleDictionary;", "getTokenizer", "()Lai/grazie/nlp/tokenizer/Tokenizer;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "gec-spell-local-engine"})
        public static final class Dictionary {
            @Nullable
            private final Tokenizer tokenizer;
            @NotNull
            private final WordListWithFrequency dictionary;
            @NotNull
            private final Function1<String, Boolean> isAlien;
            @NotNull
            private final RuleDictionary rules;

            @Nullable
            public final Tokenizer getTokenizer() {
                return this.tokenizer;
            }

            @NotNull
            public final WordListWithFrequency getDictionary() {
                return this.dictionary;
            }

            @NotNull
            public final Function1<String, Boolean> isAlien() {
                return this.isAlien;
            }

            @NotNull
            public final RuleDictionary getRules() {
                return this.rules;
            }

            public Dictionary(@Nullable Tokenizer tokenizer, @NotNull WordListWithFrequency dictionary, @NotNull Function1<? super String, Boolean> isAlien2, @NotNull RuleDictionary rules2) {
                Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
                Intrinsics.checkNotNullParameter(isAlien2, (String)"isAlien");
                Intrinsics.checkNotNullParameter((Object)rules2, (String)"rules");
                this.tokenizer = tokenizer;
                this.dictionary = dictionary;
                this.isAlien = isAlien2;
                this.rules = rules2;
            }

            public /* synthetic */ Dictionary(Tokenizer tokenizer, WordListWithFrequency wordListWithFrequency, Function1 function1, RuleDictionary ruleDictionary, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    tokenizer = new HeuristicWordTokenizer(true, false);
                }
                if ((n & 2) != 0) {
                    wordListWithFrequency = English.INSTANCE.getHunspell();
                }
                if ((n & 4) != 0) {
                    function1 = English.INSTANCE.isAlien();
                }
                if ((n & 8) != 0) {
                    ruleDictionary = new RuleDictionary.Aggregated(English.Rules.INSTANCE.getReplacing(), English.Rules.INSTANCE.getIgnore());
                }
                this(tokenizer, wordListWithFrequency, function1, ruleDictionary);
            }

            public Dictionary() {
                this(null, null, null, null, 15, null);
            }

            @Nullable
            public final Tokenizer component1() {
                return this.tokenizer;
            }

            @NotNull
            public final WordListWithFrequency component2() {
                return this.dictionary;
            }

            @NotNull
            public final Function1<String, Boolean> component3() {
                return this.isAlien;
            }

            @NotNull
            public final RuleDictionary component4() {
                return this.rules;
            }

            @NotNull
            public final Dictionary copy(@Nullable Tokenizer tokenizer, @NotNull WordListWithFrequency dictionary, @NotNull Function1<? super String, Boolean> isAlien2, @NotNull RuleDictionary rules2) {
                Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
                Intrinsics.checkNotNullParameter(isAlien2, (String)"isAlien");
                Intrinsics.checkNotNullParameter((Object)rules2, (String)"rules");
                return new Dictionary(tokenizer, dictionary, isAlien2, rules2);
            }

            public static /* synthetic */ Dictionary copy$default(Dictionary dictionary, Tokenizer tokenizer, WordListWithFrequency wordListWithFrequency, Function1 function1, RuleDictionary ruleDictionary, int n, Object object) {
                if ((n & 1) != 0) {
                    tokenizer = dictionary.tokenizer;
                }
                if ((n & 2) != 0) {
                    wordListWithFrequency = dictionary.dictionary;
                }
                if ((n & 4) != 0) {
                    function1 = dictionary.isAlien;
                }
                if ((n & 8) != 0) {
                    ruleDictionary = dictionary.rules;
                }
                return dictionary.copy(tokenizer, wordListWithFrequency, function1, ruleDictionary);
            }

            @NotNull
            public String toString() {
                return "Dictionary(tokenizer=" + this.tokenizer + ", dictionary=" + this.dictionary + ", isAlien=" + this.isAlien + ", rules=" + this.rules + ")";
            }

            public int hashCode() {
                Tokenizer tokenizer = this.tokenizer;
                WordListWithFrequency wordListWithFrequency = this.dictionary;
                Function1<String, Boolean> function1 = this.isAlien;
                RuleDictionary ruleDictionary = this.rules;
                return (((tokenizer != null ? tokenizer.hashCode() : 0) * 31 + (wordListWithFrequency != null ? wordListWithFrequency.hashCode() : 0)) * 31 + (function1 != null ? function1.hashCode() : 0)) * 31 + (ruleDictionary != null ? ruleDictionary.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Dictionary)) break block3;
                        Dictionary dictionary = (Dictionary)object;
                        if (!Intrinsics.areEqual((Object)this.tokenizer, (Object)dictionary.tokenizer) || !Intrinsics.areEqual((Object)this.dictionary, (Object)dictionary.dictionary) || !Intrinsics.areEqual(this.isAlien, dictionary.isAlien) || !Intrinsics.areEqual((Object)this.rules, (Object)dictionary.rules)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

